/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;

public final class ReheatFoodRecipe
extends VfpRecipe {
    public static final String NAME = ModInfo.rstring("reheat_shapeless");
    final int _required_heatUps;
    private ItemStack _output = ItemStack.field_190927_a;

    ReheatFoodRecipe(int min) {
        super(new ResourceLocation(NAME));
        this._required_heatUps = Math.max(1, min);
    }

    public ReheatFoodRecipe(ItemStack out) {
        this(1);
        this._output = out;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    private boolean canHeat(Item item, ItemStack stack) {
        boolean yes = false;
        if (item instanceof ITemperatureChangeable) {
            ITemperatureChangeable api = (ITemperatureChangeable)item;
            yes = api.canPlayerHeat(stack) && !api.isCooled(stack);
        }
        return yes;
    }

    public boolean matches(CraftingInventory grid, World world) {
        if (!VfpConfig.getInstance().allowReheatingAndChillingRecipes()) {
            return false;
        }
        int n_items = 0;
        int n_heatups = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            Item item = next.func_77973_b();
            if (item == VfpObj.Heat_Portion_obj) {
                ++n_heatups;
            } else if (this.canHeat(item, next)) {
                ++n_items;
            } else {
                return false;
            }
            if (n_items <= true) continue;
            return false;
        }
        return n_items == 1 && n_heatups >= this._required_heatUps;
    }

    public ItemStack func_77571_b() {
        return this._output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack out = ItemStacks.NULLSTACK();
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            Item item;
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next) || (item = next.func_77973_b()) == VfpObj.Heat_Portion_obj) continue;
            ITemperatureChangeable api = (ITemperatureChangeable)item;
            ItemStack heated = ItemStacks.copy1((ItemStack)next);
            api.setHeated(heated);
            if (!api.isHeated(heated)) break;
            out = heated;
            break;
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ReheatFoodRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ReheatFoodRecipe read(ResourceLocation recipeId, JsonObject json) {
            int min = JSONUtils.func_151208_a((JsonObject)json, (String)"required_heat", (int)-1);
            return new ReheatFoodRecipe(min);
        }

        public ReheatFoodRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            int min = data.func_150792_a();
            return new ReheatFoodRecipe(min);
        }

        public void write(PacketBuffer data, ReheatFoodRecipe recipe) {
            data.func_150787_b(recipe._required_heatUps);
        }
    }
}

