/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.meats.LlamaFleece;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;
import org.jwaresoftware.mcmods.vfp.runtime.network.ModMessages;

public final class ModDrops {
    public static final String MOB = "mobdrops";
    public static final ITag.INamedTag<EntityType<?>> FEEDABLES = RID.Tags.forEntities((String)ModInfo.rstring("feedable"));
    public static final ITag.INamedTag<EntityType<?>> BIRDIES = RID.Tags.forEntities((String)ModInfo.rstring("birdies"));
    static final ITag.INamedTag<EntityType<?>> BEARS = RID.Tags.forEntities((String)ModInfo.rstring("bears"));
    static final ITag.INamedTag<EntityType<?>> COWS = RID.Tags.forEntities((String)ModInfo.rstring("cows"));
    static final ITag.INamedTag<EntityType<?>> HORSES = RID.Tags.forEntities((String)ModInfo.rstring("horses"));
    static final ITag.INamedTag<EntityType<?>> HORSELIKE = RID.Tags.forEntities((String)ModInfo.rstring("horse_like"));
    static final ITag.INamedTag<EntityType<?>> LLAMAS = RID.Tags.forEntities((String)ModInfo.rstring("llamas"));
    static final ITag.INamedTag<EntityType<?>> PIGS = RID.Tags.forEntities((String)ModInfo.rstring("pigs"));
    static final ITag.INamedTag<EntityType<?>> SQUID = RID.Tags.forEntities((String)ModInfo.rstring("squid"));
    public static final ITag.INamedTag<Item> LIVESTOCK_FEED = RID.Tags.forItems((String)ModInfo.rstring("livestock_feed"));
    static final ITag.INamedTag<Item> POLARBEAR_FEED = RID.Tags.forItems((String)ModInfo.rstring("polarbear_feed"));
    public static final ITag.INamedTag<Item> BIRDY_FEED = RID.Tags.forItems((String)ModInfo.rstring("birdy_feed"));

    static final void registerHandlers(VfpConfig config) {
        MobDropsHandler.init(config);
        EntityInteractHandler.init(config);
        ModTradesInitializer.init(config);
    }

    static final void initFinal(VfpConfig config) {
        EntityInteractHandler.initFinal(config);
    }

    public static final class MobDropsHandler {
        static MobDropsHandler INSTANCE;
        private final boolean _batDrops;
        private final boolean _pigDrops;
        private final boolean _horseDrops;
        private final boolean _wolfDrops;
        private final boolean _squidDrops;
        private final boolean _calfDrops;
        private final boolean _bearDrops;
        private final boolean _llamaDrops;
        private final boolean _ocelotDrops;
        private final boolean _zombieDrops;
        private final boolean _phantomDrops;
        private final boolean _ravagerDrops;
        private final boolean _guardianDrops;
        private final boolean _skipHorseMeat;
        private final boolean _skipSquidMeat;
        private final boolean _skipWolfMeat;
        private final boolean _skipLlamaMeat;
        private final boolean _skipBearMeat;
        private final boolean _skipRavagerMeat;
        private final boolean _skipGuardianMeat;
        private final boolean _livingDrops;
        private final boolean _ensureDrops;
        private final boolean _skipBones;
        private final boolean _skipLeather;
        private final boolean _skipFleece;
        private final boolean _moreShrooms;
        private final boolean _moreWool;

        static final void init(VfpConfig config) {
            if (config.includeModDrops() && INSTANCE == null) {
                INSTANCE = new MobDropsHandler(config);
                if (INSTANCE.isEnabled()) {
                    MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
                } else {
                    INSTANCE = null;
                }
            }
        }

        private MobDropsHandler(VfpConfig config) {
            this._batDrops = config.includeBatDrops();
            this._pigDrops = config.includePigDrops();
            this._calfDrops = config.includeCalfDrops();
            this._wolfDrops = config.includeWolfDrops();
            this._squidDrops = config.includeSquidDrops();
            this._horseDrops = config.includeHorseDrops();
            this._bearDrops = config.includePolarBearDrops();
            this._llamaDrops = config.includeLlamaDrops();
            this._phantomDrops = config.includePhantomDrops();
            this._ravagerDrops = config.includeRavagerDrops();
            this._ocelotDrops = config.includeOcelotDrops();
            this._zombieDrops = config.includeZombieDrops() && config.allowSpawnEggCrafting();
            this._guardianDrops = config.includeGuardianDrops();
            this._skipLlamaMeat = config.excludeLlamaMeatDrops();
            this._skipHorseMeat = config.excludeHorseMeatDrops();
            this._skipSquidMeat = config.excludeSquidMeatDrops();
            this._skipWolfMeat = config.excludeWolfMeatDrops();
            this._skipBearMeat = config.excludePolarBearMeatDrops();
            this._skipGuardianMeat = config.excludeGuardianMeatDrops();
            this._skipRavagerMeat = config.excludeRavagerMeatDrops();
            this._ensureDrops = config.ensureDeathDrops();
            this._skipBones = !config.includeBoneDrops();
            this._skipLeather = !config.includeLeatherDrops();
            this._skipFleece = config.llamasDropRegularWool();
            this._moreShrooms = config.increaseShroomDrops();
            this._moreWool = this._ensureDrops && config.increaseWoolDrops() && !config.strictVanillaProgression(false);
            this._livingDrops = this._batDrops || this._pigDrops || this._horseDrops || this._wolfDrops || this._ocelotDrops || this._squidDrops || this._calfDrops || this._bearDrops || this._llamaDrops || this._zombieDrops || this._ravagerDrops || this._phantomDrops || this._guardianDrops || this._ensureDrops;
        }

        private final boolean isEnabled() {
            return this._livingDrops;
        }

        @Nullable
        private PlayerEntity getPlayer(LivingDropsEvent event) {
            PlayerEntity player = null;
            DamageSource attacksource = event.getSource();
            if (attacksource instanceof EntityDamageSource && ((EntityDamageSource)attacksource).func_76346_g() instanceof PlayerEntity && !SharedGlue.isaRealNonSpectatingPlayer((Entity)(player = (PlayerEntity)((EntityDamageSource)attacksource).func_76346_g()))) {
                player = null;
            }
            return player;
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onLivingDrops(LivingDropsEvent event) {
            LivingEntity entity = event.getEntityLiving();
            World world = entity.func_130014_f_();
            if (SharedGlue.isaServerWorld((IWorldReader)world) && world.func_82736_K().func_223586_b(SharedGlue.GAMERULE_MOB_LOOT())) {
                boolean all = MeatExtrasBuildHelper.isUsingButcheringTool(event);
                boolean onFire = entity.func_70027_ad();
                PlayerEntity player = this.getPlayer(event);
                boolean isLucky = player != null && player.func_184817_da() > 0.8f;
                boolean done = false;
                Random rng = entity.func_70681_au();
                if (!done && this._squidDrops) {
                    done = this.doSquidDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._llamaDrops) {
                    done = this.doLlamaDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._batDrops) {
                    done = this.doBatDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._horseDrops) {
                    done = this.doHorseDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._wolfDrops) {
                    done = this.doWolfDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._bearDrops) {
                    done = this.doBearDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._pigDrops) {
                    done = this.doPigDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._phantomDrops) {
                    done = this.doPhantomDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._ravagerDrops) {
                    done = this.doRavagerDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._ocelotDrops) {
                    done = this.doCreeperDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._zombieDrops) {
                    done = this.doZombieDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._guardianDrops) {
                    done = this.doGuardianDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (!done && this._calfDrops) {
                    done = this.doCowDrops(event, rng, entity, all, onFire, player, isLucky);
                }
                if (this._ensureDrops) {
                    done = this.upsizeDrops(event, rng, entity, all, onFire, player, isLucky);
                }
            }
        }

        private int bonusLivesStolen(ItemStack pufferonstick, Random rand) {
            if (!Instructions.isLooted((ItemStack)pufferonstick)) {
                return 0;
            }
            int level = EnchantmentHelper.func_77506_a((Enchantment)SharedGlue.Enchantment_bindingCurse, (ItemStack)pufferonstick);
            return level >= 3 ? MathHelper.func_76136_a((Random)rand, (int)1, (int)3) : 0;
        }

        @SubscribeEvent
        public void onTryStealOcelotLifeEssence(PlayerInteractEvent.EntityInteract event) {
            Entity target = event.getTarget();
            if (!this._ocelotDrops || SharedGlue.isaClientWorld((IWorldReader)target.func_130014_f_()) || event.isCanceled()) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            ItemStack holding = SharedGlue.getPlayerHeldItem((PlayerEntity)player, (Hand)event.getHand());
            if (holding != null && target.getClass() == OcelotEntity.class) {
                OcelotEntity ocelot = (OcelotEntity)target;
                if (ocelot.func_70631_g_()) {
                    return;
                }
                Item item = holding.func_77973_b();
                if (item == VfpObj.Bane_of_Ocelots_obj) {
                    float maxhealth = ocelot.func_110138_aP();
                    float health = ocelot.func_110143_aJ();
                    int bonus = 0;
                    if (health >= maxhealth * 0.334f) {
                        int n = 0;
                        if (!ocelot.func_70644_a(SharedGlue.Potion_slowness)) {
                            if (ocelot.func_70681_au().nextFloat() < 0.15f) {
                                ++n;
                            }
                        } else if (health > maxhealth * 0.89f) {
                            ++n;
                        } else if (ocelot.func_70681_au().nextFloat() < health / maxhealth - 0.15f) {
                            ++n;
                        }
                        if (n > 0) {
                            bonus = this.bonusLivesStolen(holding, player.func_70681_au());
                            ocelot.func_199702_a((IItemProvider)VfpObj.Feline_Life_obj, n + bonus);
                        }
                    }
                    ocelot.func_70097_a(SharedGlue.DamageSource_void, maxhealth * 0.1667f * (float)(1 + bonus));
                    SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                    event.setCanceled(true);
                }
            }
        }

        private int countDrops(LivingDropsEvent event, boolean first, Item ... items) {
            int n = 0;
            for (ItemEntity e : event.getDrops()) {
                ItemStack drop = e.func_92059_d();
                for (Item item : items) {
                    if (drop.func_77973_b() != item) continue;
                    ++n;
                    if (!first) continue;
                    return n;
                }
            }
            return n;
        }

        private int countDrops(LivingDropsEvent event, boolean first, ITag<Item> items) {
            int n = 0;
            for (ItemEntity e : event.getDrops()) {
                ItemStack drop = e.func_92059_d();
                if (drop.func_190926_b() || !drop.func_77973_b().func_206844_a(items)) continue;
                ++n;
                if (!first) continue;
                return n;
            }
            return n;
        }

        private boolean isXtremeLooting(int lootingLevel) {
            return lootingLevel > Enchants.HIGH_LOOTING * 2;
        }

        private static void dropItem(LivingDropsEvent event, ItemStack stack) {
            Loot.dropLoot((LivingDropsEvent)event, (ItemStack)stack);
        }

        private static void dropItem(LivingDropsEvent event, Item item, int count) {
            Loot.dropLoot((LivingDropsEvent)event, (ItemStack)new ItemStack((IItemProvider)item, count));
        }

        private boolean upsizeDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            ResourceLocation eid = entity.func_200600_R().getRegistryName();
            if (eid == null || !"minecraft".equals(eid.func_110624_b())) {
                return false;
            }
            if (!entity.func_70631_g_()) {
                int hide_count;
                int meat_count;
                int min_meat;
                Class<?> entityClass;
                int ll = event.getLootingLevel();
                boolean all_h = all && ll > 0;
                boolean hi_loot = ll > 2;
                int bonus_count = rand.nextInt(2);
                int bonus_bones = 0;
                if (!this._skipBones) {
                    bonus_bones = this.countDrops(event, false, Items.field_151103_aS);
                    bonus_bones = bonus_bones > 1 || !all && ll <= 0 ? 0 : bonus_count + (bonus_count == 0 && isLucky ? 1 : 0);
                }
                if ((entityClass = entity.getClass()) == CowEntity.class || entityClass == MooshroomEntity.class) {
                    min_meat = (all ? 5 : (player != null ? 2 : 0)) + 1 + bonus_count;
                    meat_count = this.countDrops(event, false, Items.field_151082_bd, Items.field_151083_be);
                    if (meat_count < min_meat) {
                        MobDropsHandler.dropItem(event, onFire ? Items.field_151083_be : Items.field_151082_bd, min_meat - meat_count);
                    }
                    if (all && !this._skipLeather) {
                        hide_count = this.countDrops(event, true, Items.field_151116_aA);
                        if (hide_count == 0) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1);
                        }
                        if (all && hide_count < 2) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1);
                        }
                    }
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, bonus_bones);
                    }
                    if (entityClass == CowEntity.class) {
                        return true;
                    }
                }
                if (entityClass == PigEntity.class || entityClass == HoglinEntity.class) {
                    min_meat = (all ? 2 : (player != null ? 1 : 0)) + 1 + bonus_count;
                    meat_count = this.countDrops(event, false, Items.field_151147_al, Items.field_151157_am);
                    if (meat_count < min_meat) {
                        MobDropsHandler.dropItem(event, onFire ? Items.field_151157_am : Items.field_151147_al, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == SheepEntity.class) {
                    min_meat = (all ? 2 : (player != null ? 1 : 0)) + 1 + bonus_count;
                    meat_count = this.countDrops(event, false, Items.field_179561_bm, Items.field_179557_bn);
                    if (meat_count < min_meat) {
                        MobDropsHandler.dropItem(event, onFire ? Items.field_179557_bn : Items.field_179561_bm, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, bonus_bones);
                    }
                    if (this._moreWool) {
                        int min_wool;
                        SheepEntity sheep = (SheepEntity)entity;
                        int wool_count = this.countDrops(event, false, ((Block)((Supplier)ItemSupport.WOOL_BY_COLOR.get(sheep.func_175509_cj())).get()).func_199767_j());
                        int n = min_wool = player != null ? 3 : 1;
                        if (wool_count < min_wool) {
                            wool_count = min_wool - wool_count;
                            MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)((Supplier)ItemSupport.WOOL_BY_COLOR.get(sheep.func_175509_cj())).get(), wool_count));
                        }
                    }
                    return true;
                }
                if (entityClass == ChickenEntity.class) {
                    int feather_count;
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    if (all && (feather_count = this.countDrops(event, false, Items.field_151008_G)) < 2) {
                        MobDropsHandler.dropItem(event, Items.field_151008_G, 2 - feather_count);
                    }
                    return true;
                }
                if (entityClass == LlamaEntity.class || entityClass == TraderLlamaEntity.class) {
                    if (all && !this._skipLeather) {
                        hide_count = this.countDrops(event, true, Items.field_151116_aA);
                        if (hide_count == 0) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1);
                        }
                        if (all && hide_count < 2) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1);
                        }
                    }
                    if (this._llamaDrops && bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == RabbitEntity.class) {
                    meat_count = this.countDrops(event, true, Items.field_179558_bo, Items.field_179559_bp);
                    if (meat_count == 0) {
                        MobDropsHandler.dropItem(event, onFire ? Items.field_179559_bp : Items.field_179558_bo, 1);
                    }
                    if (all && (hide_count = this.countDrops(event, true, Items.field_179555_bs)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_179555_bs, 1);
                    }
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == PolarBearEntity.class) {
                    int fish_count;
                    if (!this._skipBones) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, 3 + bonus_bones);
                    }
                    if ((fish_count = this.countDrops(event, true, Items.field_196086_aW, Items.field_196102_ba) + this.countDrops(event, true, Items.field_196087_aX, Items.field_196104_bb)) == 0) {
                        fish_count = 1 + bonus_count;
                        MobDropsHandler.dropItem(event, onFire ? LikeFood.salmon.sample(fish_count) : LikeFood.uncooked_salmon.sample(fish_count));
                    }
                    return true;
                }
                if (entityClass == PandaEntity.class) {
                    if (!this._skipBones) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, 2 + bonus_bones);
                    }
                    return true;
                }
                if (entityClass == HorseEntity.class || entityClass == DonkeyEntity.class || entityClass == MuleEntity.class) {
                    if (all && !this._skipLeather) {
                        hide_count = this.countDrops(event, true, Items.field_151116_aA);
                        if (hide_count == 0) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1 + rand.nextInt(all ? 3 : 2));
                        } else if (all && hide_count < 3) {
                            MobDropsHandler.dropItem(event, Items.field_151116_aA, 1 + rand.nextInt(2));
                        }
                    }
                    return true;
                }
                if (entityClass == CreeperEntity.class) {
                    int powder_count;
                    if (player != null && all_h && !VfpConfig.getInstance().strictVanillaProgression(false) && (powder_count = this.countDrops(event, true, Items.field_151016_H)) < 2) {
                        MobDropsHandler.dropItem(event, Items.field_151016_H, 2 - powder_count + rand.nextInt(2));
                    }
                    return true;
                }
                if (NPE.isaSkeleton((Entity)entity, (boolean)false, (boolean)false)) {
                    int real_bone_count;
                    if (all_h && !this._skipBones && (real_bone_count = this.countDrops(event, false, Items.field_151103_aS)) < 3) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, 3 - real_bone_count);
                    }
                    return true;
                }
                if (entityClass == PhantomEntity.class) {
                    int membrane_count;
                    if (player != null && all_h && !VfpConfig.getInstance().strictVanillaProgression(false) && (membrane_count = this.countDrops(event, true, Items.field_204840_eX)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_204840_eX, 1 + (hi_loot ? bonus_count : 0));
                    }
                    return true;
                }
                if (entityClass == ShulkerEntity.class) {
                    int shell_count;
                    if (player != null && all_h && !VfpConfig.getInstance().strictVanillaProgression(false) && (shell_count = this.countDrops(event, true, Items.field_190930_cZ)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_190930_cZ, 1 + bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EndermanEntity.class) {
                    int pearl_count;
                    if (player != null && all_h && !VfpConfig.getInstance().strictVanillaProgression(false) && (pearl_count = this.countDrops(event, true, Items.field_151079_bi)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_151079_bi, 1 + (hi_loot ? bonus_count : 0));
                    }
                    return true;
                }
                if (entityClass == MooshroomEntity.class && this._moreShrooms && player != null && !onFire) {
                    MooshroomEntity mooshroo = (MooshroomEntity)entity;
                    Block mushroom = mooshroo.func_213444_dV() == MooshroomEntity.Type.BROWN ? Blocks.field_150338_P : Blocks.field_150337_Q;
                    int shroom_count = this.countDrops(event, false, mushroom.func_199767_j());
                    if (shroom_count < 0 && (shroom_count = rand.nextInt(3)) > 0) {
                        MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)mushroom, shroom_count));
                    }
                    return true;
                }
                if (entityClass == BlazeEntity.class) {
                    int rod_count;
                    if (player != null && all_h && !VfpConfig.getInstance().strictVanillaProgression(false) && (rod_count = this.countDrops(event, true, Items.field_151072_bj) + this.countDrops(event, true, Items.field_151065_br)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_151065_br, 1 + (hi_loot ? bonus_count : 0));
                    }
                    return true;
                }
                if (entityClass == SpiderEntity.class || entityClass == CaveSpiderEntity.class) {
                    int eye_count;
                    if (all_h && player != null && (eye_count = this.countDrops(event, true, Items.field_151070_bp)) == 0) {
                        MobDropsHandler.dropItem(event, Items.field_151070_bp, 1 + rand.nextInt(2));
                    }
                    return true;
                }
                if (entityClass == OcelotEntity.class || entityClass == CatEntity.class || entityClass == FoxEntity.class) {
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == DolphinEntity.class) {
                    if (bonus_bones > 0) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean doBatDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine = entity instanceof BatEntity;
            if (mine) {
                int n;
                int n2 = n = event.getLootingLevel() > 0 || all ? 2 : 1;
                if (!onFire) {
                    entity.func_199702_a((IItemProvider)VfpObj.Bat_Poop_obj, n + rand.nextInt(2));
                    entity.func_199702_a((IItemProvider)VfpObj.Bat_Raw_obj, n + rand.nextInt(4));
                    if (!this._skipBones) {
                        entity.func_199702_a((IItemProvider)VfpObj.Small_Bone_obj, rand.nextInt(2));
                    }
                    if (entity.getClass() == BatEntity.class) {
                        boolean bonus;
                        boolean bl = bonus = rand.nextInt(all ? 2 : (isLucky ? 4 : 16)) == 0;
                        if (bonus) {
                            entity.func_199702_a((IItemProvider)VfpObj.Bat_Sonar_Sac_obj, 1);
                        }
                    }
                } else {
                    entity.func_199702_a((IItemProvider)VfpObj.Bat_Cooked_obj, n);
                    entity.func_199702_a((IItemProvider)VfpObj.Bat_Poop_obj, rand.nextInt(2));
                }
            }
            return mine;
        }

        private boolean doPigDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof PigEntity || PIGS.func_230235_a_((Object)entity.func_200600_R());
            if (mine) {
                int n;
                int n2 = n = event.getLootingLevel() > 1 || all ? 1 + rand.nextInt(2) : 1;
                if (!entity.func_70631_g_() && !onFire) {
                    MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)VfpObj.Hocks_Raw_obj, n + rand.nextInt(2)));
                    MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)VfpObj.Pigtail_Raw_obj, all ? 1 : rand.nextInt(2)));
                }
            }
            return mine;
        }

        private boolean doCowDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof CowEntity || COWS.func_230235_a_((Object)entity.func_200600_R());
            if (mine && entity.func_70631_g_() && !onFire) {
                entity.func_199702_a((IItemProvider)VfpObj.Calf_Stomach_obj, 1);
                if (!this._skipBones) {
                    entity.func_199702_a((IItemProvider)VfpObj.Small_Bone_obj, 1);
                }
            }
            return mine;
        }

        private boolean doSquidDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof SquidEntity || SQUID.func_230235_a_((Object)entity.func_200600_R());
            if (mine) {
                int n;
                int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean xlooting = this.isXtremeLooting(lootLevel);
                int n2 = n = lootLevel > 0 || all ? 2 : 1;
                if (!this._skipSquidMeat) {
                    if (onFire) {
                        MobDropsHandler.dropItem(event, VfpObj.Squid_Cooked_obj, n + rand.nextInt(2));
                    } else {
                        MobDropsHandler.dropItem(event, VfpObj.Squid_Raw_obj, n + rand.nextInt(2));
                    }
                }
                if (!onFire && entity.getClass() == SquidEntity.class) {
                    int n3 = n = rand.nextInt(all || xlooting ? 3 : 8) == 0 ? 1 : 0;
                    if (n > 0) {
                        MobDropsHandler.dropItem(event, VfpObj.Ink_Pearl_Shard_obj, n += player != null ? (rand.nextInt(isLucky ? 8 : 24) == 0 ? 1 : 0) : 0);
                    }
                }
            }
            return mine;
        }

        private boolean doHorseDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof HorseEntity || HORSELIKE.func_230235_a_((Object)entity.func_200600_R());
            if (mine) {
                boolean isAdult;
                boolean bl2 = isAdult = !entity.func_70631_g_();
                boolean uncommonDrop = isAdult && rand.nextInt(all || isLucky ? 8 : 16) == 0;
                int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean xlooting = this.isXtremeLooting(lootLevel);
                if (!onFire && isAdult) {
                    int n;
                    if (HORSES.func_230235_a_((Object)entity.func_200600_R()) && (all || uncommonDrop)) {
                        n = 1;
                        if (lootLevel > 1) {
                            n += rand.nextInt(2 + (xlooting ? 2 : 0));
                        }
                        MobDropsHandler.dropItem(event, VfpObj.Horse_Tear_obj, n);
                    }
                    if (all || rand.nextInt(4) == 0) {
                        n = all || event.getLootingLevel() > 0 ? 2 : 1;
                        MobDropsHandler.dropItem(event, VfpObj.Horse_Hoof_obj, n);
                    }
                    if (uncommonDrop) {
                        MobDropsHandler.dropItem(event, VfpObj.Horse_Sweat_obj, 1);
                    }
                }
                if (!this._skipHorseMeat) {
                    if (!isAdult) {
                        MobDropsHandler.dropItem(event, onFire ? VfpObj.Horse_Cooked_obj : VfpObj.Horse_Raw_obj, 1);
                    } else {
                        int n;
                        boolean bonanza = event.getLootingLevel() > 1 || all;
                        int n2 = n = bonanza ? 3 : 1;
                        if (all) {
                            ++n;
                        }
                        MobDropsHandler.dropItem(event, onFire ? VfpObj.Horse_Cooked_obj : VfpObj.Horse_Raw_obj, n + rand.nextInt(4));
                        if (!onFire) {
                            int bone_count = (bonanza ? 2 : 1) + rand.nextInt(3);
                            if (!this._skipBones) {
                                MobDropsHandler.dropItem(event, Items.field_151103_aS, bone_count);
                            }
                        }
                    }
                }
            }
            return mine;
        }

        private boolean doWolfDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine = entity instanceof WolfEntity;
            if (mine && !entity.func_70631_g_()) {
                if (((WolfEntity)entity).func_70909_n()) {
                    boolean uncommonDrop;
                    boolean bl = uncommonDrop = rand.nextInt(isLucky ? 32 : 64) == 0;
                    if (uncommonDrop) {
                        DamageSource ds = event.getSource();
                        if (player == null || ds.func_76346_g() != player) {
                            uncommonDrop = false;
                        }
                    }
                    if (uncommonDrop) {
                        entity.func_70099_a(WolfsSpiritElement.random(1, rand), 0.0f);
                    }
                } else {
                    boolean uncommonDrop;
                    int n;
                    int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                    boolean xlooting = this.isXtremeLooting(lootLevel);
                    int n2 = n = lootLevel > 1 || all ? 3 : 2;
                    boolean bl = uncommonDrop = rand.nextInt(xlooting ? 4 : (all || isLucky ? 8 : 16)) == 0;
                    if (!this._skipWolfMeat) {
                        if (onFire) {
                            entity.func_199702_a((IItemProvider)VfpObj.Wolf_Cooked_obj, n + rand.nextInt(2));
                        } else {
                            entity.func_199702_a((IItemProvider)VfpObj.Wolf_Raw_obj, n + rand.nextInt(2));
                        }
                    }
                    if (uncommonDrop && entity.getClass() == WolfEntity.class) {
                        Item using;
                        Item item = using = player != null ? SharedGlue.getPlayerUsingItemItem((PlayerEntity)player) : null;
                        ItemStack loot = using == Items.field_151010_B ? new ItemStack((IItemProvider)VfpObj.Wolf_Spirit_obj, 1 + (lootLevel > 0 ? 1 : 0)) : WolfsSpiritElement.random(1, rand);
                        entity.func_70099_a(loot, 0.0f);
                    }
                    if (!this._skipWolfMeat && !this._skipBones) {
                        entity.func_199702_a((IItemProvider)VfpObj.Small_Bone_obj, --n);
                    }
                }
            }
            return mine;
        }

        private boolean doBearDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof PolarBearEntity || BEARS.func_230235_a_((Object)entity.func_200600_R());
            if (mine && !entity.func_70631_g_()) {
                DamageSource ds = event.getSource();
                int lootLevel = player == null || ds.func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean uncommonDrop = false;
                if (lootLevel > 1 && !ds.func_180136_u() && !onFire) {
                    boolean xlooting = this.isXtremeLooting(lootLevel);
                    boolean bl2 = uncommonDrop = rand.nextInt(all || isLucky || xlooting ? 4 : 8) == 0;
                }
                if (!this._skipBearMeat) {
                    int n;
                    int n2 = n = lootLevel > 0 || all ? 3 : 2;
                    if (onFire) {
                        entity.func_199702_a((IItemProvider)VfpObj.Bear_Raw_Charred_obj, n + rand.nextInt(3));
                    } else {
                        entity.func_199702_a((IItemProvider)VfpObj.Bear_Raw_obj, n + rand.nextInt(5));
                    }
                    if (!this._skipBones && !this._ensureDrops) {
                        entity.func_199702_a((IItemProvider)Items.field_151103_aS, 2 + (uncommonDrop ? rand.nextInt(4) : 0));
                    }
                }
                if (uncommonDrop && entity.getClass() == PolarBearEntity.class) {
                    Item using;
                    Item item = using = player != null ? SharedGlue.getPlayerUsingItemItem((PlayerEntity)player) : null;
                    ItemStack loot = using == Items.field_151010_B ? new ItemStack((IItemProvider)VfpObj.Polar_Crystal_obj, 1 + (lootLevel > 0 ? 1 : 0)) : new ItemStack((IItemProvider)VfpObj.Polar_Raw_Crystal_obj);
                    entity.func_70099_a(loot, 0.0f);
                }
            }
            return mine;
        }

        private boolean doLlamaDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity instanceof LlamaEntity || LLAMAS.func_230235_a_((Object)entity.func_200600_R());
            if (mine && !entity.func_70631_g_()) {
                if (!this._skipLlamaMeat) {
                    int n;
                    int n2 = n = event.getLootingLevel() > 1 || all ? 3 : 2;
                    if (onFire) {
                        MobDropsHandler.dropItem(event, VfpObj.Llama_Cooked_obj, n + rand.nextInt(2));
                    } else {
                        MobDropsHandler.dropItem(event, VfpObj.Llama_Raw_obj, n + rand.nextInt(2));
                    }
                }
                if (!(onFire || entity.getClass() != LlamaEntity.class && entity.getClass() != TraderLlamaEntity.class)) {
                    int min_wool;
                    Block wool = LlamaFleece.forVariant((LlamaEntity)entity);
                    int wool_count = this.countDrops(event, false, wool.func_199767_j()) + this.countDrops(event, false, (ITag<Item>)ItemTags.field_199904_a);
                    int n = min_wool = player != null ? 3 : rand.nextInt(3);
                    if (wool_count < min_wool) {
                        wool_count = min_wool - wool_count;
                        if (this._skipFleece) {
                            wool = LlamaFleece.woolFor((LlamaEntity)entity);
                        }
                        MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)wool, wool_count));
                    }
                }
            }
            return mine;
        }

        private boolean doRavagerDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity.getClass() == RavagerEntity.class;
            if (mine) {
                DamageSource ds = event.getSource();
                int lootLevel = player == null || ds.func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean uncommonDrop = false;
                if (lootLevel > 1 && !ds.func_180136_u() && !onFire) {
                    boolean xlooting = this.isXtremeLooting(lootLevel);
                    boolean bl2 = uncommonDrop = rand.nextInt(all || isLucky || xlooting ? 4 : 8) == 0;
                }
                if (!this._skipRavagerMeat) {
                    int n;
                    int n2 = n = lootLevel > 0 || all ? 2 : 1;
                    if (onFire) {
                        MobDropsHandler.dropItem(event, VfpObj.Ravager_Raw_Charred_obj, n + rand.nextInt(3));
                    } else {
                        MobDropsHandler.dropItem(event, VfpObj.Ravager_Raw_obj, n + rand.nextInt(3));
                    }
                    if (!this._skipBones && !this._ensureDrops) {
                        MobDropsHandler.dropItem(event, Items.field_151103_aS, 2 + (!uncommonDrop ? rand.nextInt(4) : 0));
                        if (uncommonDrop) {
                            MobDropsHandler.dropItem(event, VfpObj.Ravager_Bone_obj, 1 + rand.nextInt(2));
                        }
                    }
                }
                if (uncommonDrop && rand.nextInt(all ? 4 : 8) == 0) {
                    MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)(rand.nextFloat() < 0.25f ? VfpObj.Ravager_Left_Horn_obj : VfpObj.Ravager_Right_Horn_obj)));
                }
                if (player != null || rand.nextFloat() < 0.15f) {
                    MobDropsHandler.dropItem(event, VfpObj.Ravager_Hide_obj, 1);
                }
            }
            return mine;
        }

        private boolean doPhantomDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity.getClass() == PhantomEntity.class;
            if (mine) {
                int n = event.getLootingLevel() > 1 || all ? 1 + rand.nextInt(3) : 1;
                MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)(onFire ? VfpObj.Phantom_Cooked_obj : VfpObj.Phantom_Raw_obj), n + rand.nextInt(2)));
                if (!onFire && !this._skipBones) {
                    n = 1 + (rand.nextInt(4) == 0 ? 1 : 0);
                    MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)VfpObj.Small_Bone_obj, n));
                }
            }
            return mine;
        }

        private boolean doCreeperDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine;
            boolean bl = mine = entity.getClass() == CreeperEntity.class;
            if (mine && player != null && rand.nextFloat() < 0.034f + 0.0167f * (float)Enchants.clampedLooting((int)event.getLootingLevel())) {
                ItemStack boo = new ItemStack((IItemProvider)VfpObj.Bane_of_Ocelots_obj);
                Enchants.addEnchantmentToStack((Enchantment)SharedGlue.Enchantment_bindingCurse, (int)3, (ItemStack)boo);
                MobDropsHandler.dropItem(event, boo);
            }
            return mine;
        }

        private boolean doZombieDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            float chance;
            boolean mine = entity.getClass() == ZombieVillagerEntity.class || entity.getClass() == ZombieEntity.class || entity.getClass() == DrownedEntity.class;
            float f = chance = entity.getClass() == ZombieVillagerEntity.class ? 0.134f : 0.034f;
            if (mine && player != null && rand.nextFloat() < chance + 0.0167f * (float)Enchants.clampedLooting((int)event.getLootingLevel())) {
                ItemStack soul = new ItemStack((IItemProvider)VfpObj.Villager_Soul_obj);
                Enchants.addEnchantmentToStack((Enchantment)SharedGlue.Enchantment_vanishingCurse, (int)1, (ItemStack)soul);
                MobDropsHandler.dropItem(event, soul);
            }
            return mine;
        }

        private boolean doGuardianDrops(LivingDropsEvent event, Random rand, LivingEntity entity, boolean all, boolean onFire, PlayerEntity player, boolean isLucky) {
            boolean mine = entity instanceof GuardianEntity;
            if (mine && entity.getClass() == GuardianEntity.class) {
                int lootBonus = Enchants.clampedLooting((int)event.getLootingLevel());
                if (lootBonus < 2 && all) {
                    lootBonus = 2;
                }
                float chance = 0.1f + 0.0167f * (float)lootBonus;
                if (rand.nextFloat() < chance) {
                    Loot.replaceLoot((LivingDropsEvent)event, (Item)Items.field_179562_cC, (Item)VfpObj.Guardian_Fins_obj);
                }
                if (!onFire) {
                    chance = 0.1f + 0.03f * (float)lootBonus;
                    if (rand.nextFloat() < chance) {
                        MobDropsHandler.dropItem(event, new ItemStack((IItemProvider)VfpObj.Guardian_AirSac_obj, 1 + (rand.nextFloat() < chance ? 1 : 0)));
                    }
                }
                if (!this._skipGuardianMeat && rand.nextFloat() < 0.25f) {
                    int n = Math.min(6, 1 + rand.nextInt(3) + 1 * lootBonus);
                    Loot.replaceLoot((LivingDropsEvent)event, (Item)Items.field_196086_aW, (Item)Items.field_196102_ba, (ItemStack)new ItemStack((IItemProvider)(onFire ? VfpObj.Guardian_Cooked_obj : VfpObj.Guardian_Raw_obj), n), (boolean)false);
                }
            }
            return mine;
        }
    }

    public static final class EntityInteractHandler {
        private static Ingredient POLARBEAR_TEMPTATION_ITEMS;
        private static Ingredient LIVESTOCK_TEMPTATION_ITEMS;
        private static Ingredient BIRDIES_TEMPTATION_ITEMS;
        static EntityInteractHandler INSTANCE;
        private final boolean _livestockFeedFlag;
        private final boolean _polarbearMateFlag;
        private Set<Item> _PARROT_TAME_ITEMS;

        static final void init(VfpConfig config) {
            if (INSTANCE == null) {
                INSTANCE = new EntityInteractHandler(config);
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            }
        }

        static final void initFinal(VfpConfig config) {
            if (INSTANCE != null) {
                try {
                    Field f = ObfuscationReflectionHelper.findField(ParrotEntity.class, (String)"field_192016_bJ");
                    EntityInteractHandler.INSTANCE._PARROT_TAME_ITEMS = (Set)Set.class.cast(f.get(null));
                    INSTANCE.iniBirdiesFood();
                    ModInfo.LOG.info("Parrot tame items hook initialized successfully!");
                }
                catch (Throwable igX) {
                    ModInfo.LOG.warn("Unable to initialize parrot tame items hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
                }
            }
        }

        static final void checkTags() {
        }

        EntityInteractHandler(VfpConfig config) {
            this._polarbearMateFlag = config.allowPolarbearBreeding();
            this._livestockFeedFlag = config.includeAcornDrops() || config.includeSpruceTipDrops();
        }

        final void iniBirdiesFood() {
            EntityInteractHandler.addBirdieFood(VfpObj.Bird_Food_obj);
            EntityInteractHandler.addBirdieFood(VfpObj.Roasted_Pumpkin_Seeds_obj);
            EntityInteractHandler.addBirdieFood(VfpObj.Roasted_Sunflower_Seeds_obj);
            EntityInteractHandler.addBirdieFood(VfpObj.Acorn_Nuts_obj);
        }

        public static final boolean addBirdieFood(Item food) {
            boolean present = false;
            if (INSTANCE != null && EntityInteractHandler.INSTANCE._PARROT_TAME_ITEMS != null && SharedGlue.isDefined((Item)food)) {
                EntityInteractHandler.INSTANCE._PARROT_TAME_ITEMS.add(food);
                present = true;
            }
            return present;
        }

        private boolean isaBirdie(Entity entity) {
            Class<?> e_klass = entity.getClass();
            return e_klass == ParrotEntity.class || e_klass == ChickenEntity.class || BIRDIES.func_230235_a_((Object)entity.func_200600_R()) && entity instanceof CreatureEntity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void initTemptationIngredients(FMLServerAboutToStartEvent event) {
            EntityInteractHandler entityInteractHandler = INSTANCE;
            synchronized (entityInteractHandler) {
                if (POLARBEAR_TEMPTATION_ITEMS == null) {
                    POLARBEAR_TEMPTATION_ITEMS = Ingredient.func_199805_a(POLARBEAR_FEED);
                    LIVESTOCK_TEMPTATION_ITEMS = Ingredient.func_199805_a(LIVESTOCK_FEED);
                    BIRDIES_TEMPTATION_ITEMS = Ingredient.func_199805_a(BIRDY_FEED);
                }
            }
        }

        private void addTemptGoalConditonally(MobEntity to, int priority, TemptGoal goal) {
            try {
                to.field_70714_bg.func_75776_a(priority, (Goal)goal);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onAnimalJoinWorld(EntityJoinWorldEvent event) {
            Entity joining = event.getEntity();
            if (this.isaBirdie(joining)) {
                CreatureEntity birdie = (CreatureEntity)joining;
                this.addTemptGoalConditonally((MobEntity)birdie, 3, new TemptGoal(birdie, 1.0, false, BIRDIES_TEMPTATION_ITEMS));
                return;
            }
            if (this._polarbearMateFlag && joining.getClass() == PolarBearEntity.class) {
                PolarBearEntity polarbear = (PolarBearEntity)joining;
                polarbear.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)polarbear, 1.0));
                this.addTemptGoalConditonally((MobEntity)polarbear, 3, new TemptGoal((CreatureEntity)polarbear, 1.2, false, POLARBEAR_TEMPTATION_ITEMS));
            }
            if (this._livestockFeedFlag && SharedGlue.isaAnimal((Entity)joining) && FEEDABLES.func_230235_a_((Object)joining.func_200600_R())) {
                AnimalEntity animal = (AnimalEntity)joining;
                this.addTemptGoalConditonally((MobEntity)animal, 3, new TemptGoal((CreatureEntity)animal, 1.0, false, LIVESTOCK_TEMPTATION_ITEMS));
            }
        }

        @SubscribeEvent
        public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity target = event.getTarget();
            if (SharedGlue.isaClientWorld((IWorldReader)target.func_130014_f_()) || event.isCanceled()) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            ItemStack holding = SharedGlue.getPlayerHeldItem((PlayerEntity)player, (Hand)event.getHand());
            if (holding != null && SharedGlue.isaAnimal((Entity)target)) {
                boolean hurt;
                AnimalEntity animal = (AnimalEntity)target;
                Item helditem = holding.func_77973_b();
                boolean fed = false;
                boolean birdie = this.isaBirdie((Entity)animal);
                boolean bl = hurt = birdie && animal.func_110143_aJ() < animal.func_110138_aP();
                if (animal.getClass() == PolarBearEntity.class) {
                    if (helditem.func_206844_a(POLARBEAR_FEED)) {
                        boolean salmon = helditem == Items.field_196087_aX;
                        boolean strong = salmon || !helditem.func_206844_a((ITag)ItemTags.field_206964_G);
                        if (NPE.healIfHurt((LivingEntity)animal, (float)(strong ? 8.0f : 5.0f))) {
                            fed = true;
                        } else if (animal.func_70631_g_()) {
                            fed = true;
                            animal.func_110195_a(strong ? 120 : 60);
                        } else if (salmon && animal.func_204701_dC()) {
                            fed = true;
                            if (this._polarbearMateFlag) {
                                animal.func_146082_f(player);
                            }
                        }
                        if (fed) {
                            SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                            ModMessages.sendShowHappySparklies((Entity)animal);
                        }
                    }
                } else if (helditem == VfpObj.Bird_Food_obj && birdie && hurt) {
                    if (NPE.healIfHurt((LivingEntity)animal, (float)-1.0f)) {
                        SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                        fed = true;
                        ModMessages.sendShowHappySparklies((Entity)animal);
                    }
                } else if (birdie && helditem.func_206844_a(BIRDY_FEED) || helditem.func_206844_a(LIVESTOCK_FEED) && FEEDABLES.func_230235_a_((Object)target.func_200600_R())) {
                    if (NPE.healIfHurt((LivingEntity)animal, (float)2.0f)) {
                        SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                        fed = true;
                        ModMessages.sendShowHappySparklies((Entity)animal);
                    } else if (animal.func_70631_g_()) {
                        SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                        animal.func_175501_a((int)((float)(-animal.func_70874_b()) / 20.0f * 0.1f), true);
                        fed = true;
                        ModMessages.sendShowHappySparklies((Entity)animal, 1.0f);
                    } else if (animal.func_204701_dC()) {
                        animal.func_146082_f(player);
                        if (animal.func_70880_s()) {
                            SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)holding, (Hand)event.getHand(), (boolean)true);
                            fed = true;
                        }
                    }
                }
                if (fed) {
                    player.func_226292_a_(event.getHand(), true);
                    event.setCanceled(true);
                }
            }
        }
    }

    public static final class ModTradesInitializer {
        static ModTradesInitializer INSTANCE;

        static final void init(VfpConfig config) {
            if (config.includeBartering(true) && INSTANCE == null) {
                INSTANCE = new ModTradesInitializer();
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            }
        }

        static final ItemStack stackOf(Item item, int amount) {
            return ItemStacks.create((Item)item, (int)amount);
        }

        static final ItemStack stackOf(Item item) {
            return ItemStacks.create((Item)item);
        }

        static final ItemStack emerald() {
            return new ItemStack((IItemProvider)Items.field_151166_bC);
        }

        static final ItemStack emeralds(int amount) {
            return new ItemStack((IItemProvider)Items.field_151166_bC, amount);
        }

        static final ItemStack diamonds(int amount) {
            return new ItemStack((IItemProvider)Items.field_151045_i, amount);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onInitVillagerTrades(VillagerTradesEvent event) {
            VfpConfig config = VfpConfig.getInstance();
            VillagerProfession vp = event.getType();
            if (vp == VillagerProfession.field_221153_c) {
                ((List)event.getTrades().get(1)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Knapped_Red_Flint_obj), ModTradesInitializer.stackOf(VfpObj.RockSalt_Crystals_obj, 2), 8, 1, 0.05f));
                if (config.includePigDrops()) {
                    ((List)event.getTrades().get(1)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Pigtail_Raw_obj, 4), ModTradesInitializer.emerald(), 4, 1, 0.05f));
                    ((List)event.getTrades().get(3)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Hocks_Raw_obj, 8), ModTradesInitializer.emerald(), 4, 3, 0.05f));
                }
                if (config.includeLlamaDrops() && !config.excludeLlamaMeatDrops()) {
                    ((List)event.getTrades().get(4)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Llama_Cooked_obj, 4), ModTradesInitializer.emerald(), 16, 5, 0.05f));
                }
                if (config.includeRavagerDrops()) {
                    ((List)event.getTrades().get(2)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ravager_Bone_obj), ModTradesInitializer.emerald(), 4, 3, 0.05f));
                    ((List)event.getTrades().get(4)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ravager_Hide_obj), ModTradesInitializer.emeralds(2), 2, 5, 0.05f));
                }
                if (config.includePolarBearDrops() && !config.excludePolarBearMeatDrops()) {
                    ((List)event.getTrades().get(5)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Bear_Raw_obj), 4, 1, 0.05f));
                }
                if (config.includeCalfDrops()) {
                    ((List)event.getTrades().get(5)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Calf_Stomach_obj), 4, 1, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221157_g) {
                ((List)event.getTrades().get(2)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Squid_OnStick_obj, 4), 8, 1, 0.05f));
                if (config.includeSquidDrops() && !config.excludeSquidMeatDrops()) {
                    ((List)event.getTrades().get(2)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Squid_Raw_obj, 8), ModTradesInitializer.emerald(), 16, 2, 0.05f));
                }
                if (config.includeGuardianDrops()) {
                    if (!config.excludeGuardianMeatDrops()) {
                        ((List)event.getTrades().get(3)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Guardian_Cooked_obj, 8), ModTradesInitializer.emerald(), 16, 2, 0.05f));
                        ((List)event.getTrades().get(4)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Guardian_Raw_obj, 2), 4, 1, 0.05f));
                    }
                    if (config.allowExoBoxes()) {
                        ((List)event.getTrades().get(5)).add(new BasicTrade(ModTradesInitializer.diamonds(2), ModTradesInitializer.stackOf(VfpObj.Guardian_Fins_obj, 3), 3, 1, 0.05f));
                    }
                    ((List)event.getTrades().get(5)).add(new BasicTrade(ModTradesInitializer.diamonds(1), ModTradesInitializer.stackOf(VfpObj.Guardian_AirSac_obj, 2), 3, 1, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221155_e) {
                if (config.includeGuardianDrops()) {
                    ((List)event.getTrades().get(2)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Guardian_AirSac_obj, 2), ModTradesInitializer.emerald(), 16, 2, 0.05f));
                }
                if (config.includeBatDrops()) {
                    ((List)event.getTrades().get(4)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Bat_Sonar_Sac_obj), ModTradesInitializer.emerald(), 4, 3, 0.05f));
                }
                if (config.includeSquidDrops()) {
                    ((List)event.getTrades().get(2)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ink_Pearl_Shard_obj, 2), ModTradesInitializer.emerald(), 16, 2, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221163_m && config.includeLlamaDrops() && !config.llamasDropRegularWool()) {
                for (ItemStack fleece : LlamaFleece.addSamples(new ArrayList<ItemStack>())) {
                    ((List)event.getTrades().get(1)).add(new BasicTrade(ItemStacks.copy((ItemStack)fleece, (int)12), ModTradesInitializer.emerald(), 16, 2, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221156_f) {
                ((List)event.getTrades().get(3)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Flesh_Meal_obj, 16), 8, 1, 0.05f));
                if (config.includeAcornDrops()) {
                    ((List)event.getTrades().get(2)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Oak_Acorn_obj, 24), ModTradesInitializer.emerald(), 16, 1, 0.05f));
                    ((List)event.getTrades().get(4)).add(new BasicTrade(1, ModTradesInitializer.stackOf(VfpObj.Acorn_Nuts_obj, 8), 8, 1, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221159_i || vp == VillagerProfession.field_221152_b) {
                if (config.includeRavagerDrops()) {
                    ((List)event.getTrades().get(3)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ravager_Hide_obj), ModTradesInitializer.emeralds(3), 2, 5, 0.05f));
                }
                if (vp == VillagerProfession.field_221159_i) {
                    ((List)event.getTrades().get(1)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Red_Flint_obj, 12), ModTradesInitializer.emerald(), 8, 2, 0.05f));
                }
                if (vp == VillagerProfession.field_221152_b && !config.strictVanillaProgression(false)) {
                    ((List)event.getTrades().get(1)).add(new BasicTrade(ModTradesInitializer.stackOf(Items.field_196155_l, 24), ModTradesInitializer.emerald(), 16, 1, 0.05f));
                }
            }
            if (vp == VillagerProfession.field_221165_o) {
                ((List)event.getTrades().get(3)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Red_Flint_obj, 10), ModTradesInitializer.emerald(), 8, 2, 0.05f));
                if (config.includeRavagerDrops()) {
                    ((List)event.getTrades().get(5)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ravager_Right_Horn_obj), ModTradesInitializer.diamonds(1), 2, 6, 0.05f));
                    ((List)event.getTrades().get(5)).add(new BasicTrade(ModTradesInitializer.stackOf(VfpObj.Ravager_Left_Horn_obj), ModTradesInitializer.diamonds(2), 1, 6, 0.05f));
                }
            }
        }

        @SubscribeEvent
        public void onInitWandererTrades(WandererTradesEvent event) {
            event.getGenericTrades().add(new BasicTrade(ModTradesInitializer.emerald(), ModTradesInitializer.stackOf(VfpObj.RockSalt_Crystals_obj, 2), 8, 1, 0.05f));
            event.getGenericTrades().add(new BasicTrade(ModTradesInitializer.emerald(), ModTradesInitializer.stackOf(VfpObj.Natron_Crystals_obj, 2), 8, 1, 0.05f));
            event.getRareTrades().add(new BasicTrade(ModTradesInitializer.emeralds(3), ModTradesInitializer.stackOf(VfpObj.Kelp_Shake_obj), 2, 1, 0.0f));
            event.getRareTrades().add(new BasicTrade(ModTradesInitializer.diamonds(4), ModTradesInitializer.stackOf(VfpObj.Uncooked_Golden_Fruit_Pie_obj), 2, 1, 0.0f));
        }
    }

    public static final class HarvestDropsHandler
    extends LootModifier {
        static ITag.INamedTag<Block> RED_FLINT_SOURCES = RID.Tags.forBlocks((String)ModInfo.rstring("red_flint_sources"));
        private final boolean _moreShrooms;
        private final boolean _acornDrops;
        private final boolean _uglifruitDrops;
        private final boolean _sprucetipDrops;
        private final boolean _bambooDrops;

        HarvestDropsHandler(ILootCondition[] conditions) {
            super(conditions == null ? Loot._NOC : conditions);
            VfpConfig config = VfpConfig.getInstance();
            this._moreShrooms = config.increaseShroomDrops();
            this._acornDrops = config.includeAcornDrops();
            this._uglifruitDrops = config.includeUgliFruitDrops();
            this._sprucetipDrops = config.includeSpruceTipDrops();
            this._bambooDrops = config.includeBambooShootsDrops();
        }

        ILootCondition[] getConditions() {
            return this.conditions;
        }

        private boolean skip(LootContext lc) {
            boolean skip = true;
            if (VfpConfig.getInstance().includeModDrops() && Loot.hasBlockHarvestingParameters((LootContext)lc) && SharedGlue.isBlockDropGameRuleEnabled((World)lc.func_202879_g()) && !Enchants.isSilkTouched((ItemStack)((ItemStack)lc.func_216031_c(LootParameters.field_216289_i)))) {
                skip = false;
            }
            return skip;
        }

        protected List<ItemStack> doApply(List<ItemStack> outDrops, LootContext lc) {
            ServerWorld world = lc.func_202879_g();
            if (!this.skip(lc)) {
                Block block = ((BlockState)lc.func_216031_c(LootParameters.field_216287_g)).func_177230_c();
                PlayerEntity harvester = SharedGlue.getPlayerOrNull((Entity)((Entity)lc.func_216031_c(LootParameters.field_216281_a)));
                int fortune = Loot.getBetterFortuneOrLuck((LootContext)lc);
                BlockPos hitpos = Loot.getHarvestedBlockPos((LootContext)lc);
                if (SharedGlue.isSame((Block)block, (Block)Blocks.field_150351_n) || block.func_203417_a(RED_FLINT_SOURCES)) {
                    if (harvester != null && harvester.func_70644_a(SharedGlue.Potion_luck)) {
                        fortune = 4;
                    }
                    if (fortune > 3) {
                        fortune = 3;
                    }
                    if (lc.func_216032_b().nextInt(20 - fortune * 3) == 0) {
                        int N = 1;
                        if (fortune > 2) {
                            ++N;
                        }
                        Item blockitem = block.func_199767_j();
                        ListIterator<ItemStack> litr = outDrops.listIterator();
                        while (litr.hasNext()) {
                            ItemStack next = litr.next();
                            if (next.func_77973_b() != blockitem) continue;
                            litr.set(new ItemStack((IItemProvider)VfpObj.Red_Flint_obj, N * next.func_190916_E()));
                        }
                    }
                    return outDrops;
                }
                if (this._moreShrooms && (SharedGlue.isSame((Block)block, (Block)Blocks.field_150419_aX) || SharedGlue.isSame((Block)block, (Block)Blocks.field_150420_aW))) {
                    if (fortune < 1 && MeatExtrasBuildHelper.isUsingButcheringTool(harvester, (ItemStack)lc.func_216031_c(LootParameters.field_216289_i))) {
                        fortune = 1;
                    }
                    int n = VfpUtils.countDrops(outDrops, false, Blocks.field_150337_Q.func_199767_j(), Blocks.field_150338_P.func_199767_j());
                    Block smallblock = SharedGlue.isSame((Block)block, (Block)Blocks.field_150419_aX) ? Blocks.field_150337_Q : Blocks.field_150338_P;
                    int N = n;
                    if (N == 0 && lc.func_216032_b().nextBoolean()) {
                        N = 1;
                    }
                    if ((N += fortune) > 3) {
                        N = 3;
                    }
                    if (N > n) {
                        outDrops.add(new ItemStack((IItemProvider)smallblock, N -= n));
                    }
                    return outDrops;
                }
                if (this._bambooDrops && SharedGlue.isSame((Block)block, (Block)Blocks.field_222404_kP) && RID.matches((ItemStack)((ItemStack)lc.func_216031_c(LootParameters.field_216289_i)), (String)"carrots:food_cutters", (Item)VfpObj.Flint_Cutter_obj)) {
                    int N = 3 + Math.min(3, Loot.getBetterFortuneOrLuck((LootContext)lc));
                    ListIterator<ItemStack> litr = outDrops.listIterator();
                    while (litr.hasNext()) {
                        if (litr.next().func_77973_b() != Items.field_222068_kQ) continue;
                        litr.set(new ItemStack((IItemProvider)VfpObj.Raw_Bamboo_Shoots_obj, 1 + lc.func_216032_b().nextInt(N)));
                    }
                    return outDrops;
                }
                if ((this._acornDrops || this._uglifruitDrops || this._sprucetipDrops) && block instanceof LeavesBlock) {
                    int n;
                    Random rng = lc.func_216032_b();
                    if (SharedGlue.isaRealPlayer((Entity)harvester)) {
                        rng = harvester.func_70681_au();
                    }
                    boolean dropAcorns = false;
                    boolean dropUglies = false;
                    boolean dropTips = false;
                    if (SharedGlue.isSame((Block)block, (Block)Blocks.field_196642_W) || SharedGlue.isSame((Block)block, (Block)Blocks.field_196574_ab)) {
                        dropAcorns = true;
                    } else if (SharedGlue.isSame((Block)block, (Block)Blocks.field_196648_Z)) {
                        dropUglies = true;
                    } else if (SharedGlue.isSame((Block)block, (Block)Blocks.field_196645_X)) {
                        dropTips = true;
                    }
                    if (dropAcorns && this._acornDrops && (n = rng.nextInt(2 + (fortune > 1 ? 1 : 0))) > 0 && rng.nextFloat() <= 0.08f) {
                        outDrops.add(new ItemStack((IItemProvider)VfpObj.Oak_Acorn_obj, n));
                    }
                    if (dropUglies && this._uglifruitDrops && (n = rng.nextInt(2 + (fortune > 2 ? 1 : 0))) > 0) {
                        PlayerEntity player;
                        float threshold = Locations.isaRegularJungle((RegistryKey)Locations.biomeKeyFor((IBiomeReader)world, (BlockPos)hitpos)) ? 0.032f : 0.016f;
                        Object object = player = SharedGlue.isaRealPlayer((Entity)harvester) ? harvester : null;
                        if (player != null && player.func_184817_da() >= 1.0f) {
                            threshold += 0.01f;
                        }
                        if (rng.nextFloat() <= threshold) {
                            outDrops.add(new ItemStack((IItemProvider)VfpObj.Raftugli_Fruit_obj, n));
                        }
                    }
                    if (dropTips && this._sprucetipDrops) {
                        ItemStack held;
                        float threshold = Locations.isaRegularTaiga((RegistryKey)Locations.biomeKeyFor((IBiomeReader)world, (BlockPos)hitpos)) ? 0.04f : 0.02f;
                        PlayerEntity player = SharedGlue.isaRealPlayer((Entity)harvester) ? harvester : null;
                        ItemStack itemStack = held = player != null ? (ItemStack)lc.func_216031_c(LootParameters.field_216289_i) : ItemStack.field_190927_a;
                        if (!held.func_190926_b() && RID.matches((ItemStack)held, (String)"rods/wooden", (Item)Items.field_151055_y)) {
                            threshold += 0.02f;
                        }
                        if (player != null && player.func_184817_da() >= 1.0f) {
                            threshold += 0.01f;
                        }
                        if (rng.nextFloat() <= threshold) {
                            outDrops.add(new ItemStack((IItemProvider)VfpObj.Spruce_Tips_obj));
                        }
                    }
                    return outDrops;
                }
            }
            return outDrops;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<HarvestDropsHandler> {
            public HarvestDropsHandler read(ResourceLocation unused, JsonObject object, ILootCondition[] conditions) {
                return new HarvestDropsHandler(conditions);
            }

            public JsonObject write(HarvestDropsHandler instance) {
                return this.makeConditions(instance.getConditions());
            }
        }
    }
}

