/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.lib.impl.item.NutritionProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;

public final class NutritionNotesInjector {
    static final Set<NutritionNote> BASE_NNOTES = NutritionNote.BASE_SET;

    private boolean apply(ItemStack stack) {
        return !NutritionNote.present((ItemStack)stack) && NutritionProfile.isTaggable((ItemStack)stack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        ItemStack crafted = e.getCrafting();
        if (this.apply(crafted)) {
            InvWrapper iih = new InvWrapper(e.getInventory());
            long nn = NutritionProfile.compute((ItemStack)crafted, (IItemHandler)iih, BASE_NNOTES);
            NutritionNote.addTo((ItemStack)crafted, (long)nn);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        ItemStack smelted = e.getSmelting();
        if (this.apply(smelted)) {
            long nn = NutritionProfile.compute((ItemStack)smelted, BASE_NNOTES);
            NutritionNote.addTo((ItemStack)smelted, (long)nn);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemBrewed(PlayerBrewedPotionEvent e) {
        ItemStack brewed = e.getStack();
        if (this.apply(brewed)) {
            long nn = NutritionProfile.compute((ItemStack)brewed, BASE_NNOTES);
            NutritionNote.addTo((ItemStack)brewed, (long)nn);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemFished(ItemFishedEvent e) {
        for (ItemStack fishedUp : e.getDrops()) {
            if (!this.apply(fishedUp)) continue;
            long nn = NutritionProfile.compute((ItemStack)fishedUp, BASE_NNOTES);
            NutritionNote.addTo((ItemStack)fishedUp, (long)nn);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemPickedUp(EntityItemPickupEvent e) {
        ItemStack pickedUp;
        if (VfpConfig.getInstance().checkNutritionNotesOnPickup() && this.apply(pickedUp = e.getItem().func_92059_d())) {
            long nn = NutritionProfile.compute((ItemStack)pickedUp, BASE_NNOTES);
            NutritionNote.addTo((ItemStack)pickedUp, (long)nn);
        }
    }
}

