/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementPredicate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.tonics.BatSightedEffect;

public final class SpecialDropsEventsHandler {
    private static final ResourceLocation BRAVE_STOMACH = ModInfo.r("mod/bravestomach");

    SpecialDropsEventsHandler() {
    }

    private boolean hasIronStomach(PlayerEntity player) {
        return SharedGlue.isAffectingPlayer((Item)VfpObj.Iron_Stomach_obj, (PlayerEntity)player, (boolean)false, (boolean)true) && (!SharedGlue.isaServerWorld((Entity)player) || AdvancementPredicate.isDone((ResourceLocation)BRAVE_STOMACH, (PlayerEntity)player));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onTryAddEffect(PotionEvent.PotionApplicableEvent event) {
        Effect potion = event.getPotionEffect().func_188419_a();
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)event.getEntity());
        if (player != null) {
            if (Potions.isIn((Effect)potion, (Effect)Effects.field_76436_u, (String)"poisons") || potion == Effects.field_76431_k || potion == Effects.field_76438_s) {
                if (this.hasIronStomach(player)) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (potion == Effects.field_76419_f && player.func_70644_a(VfpPotions.GUARDIANS_GRACE)) {
                event.setResult(Event.Result.DENY);
            } else if (Potions.isIn((Effect)potion, (Effect)Effects.field_76440_q, (String)"blindness") && (player.func_70644_a(VfpPotions.BAT_SIGHTED) || player.func_70644_a(VfpPotions.CARROT_VISION))) {
                event.setResult(Event.Result.DENY);
            }
        } else if (potion == VfpPotions.BAT_SIGHTED) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onLivingTicked(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)event.getEntity());
        if (player != null && player.field_70173_aa % 4 == 0 && SharedGlue.hasPotionsInEffect((LivingEntity)player) && SharedGlue.isaServerWorld((Entity)player) && this.hasIronStomach(player)) {
            Potions.CureProfiles.applyForPoison((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public final void onAboutToExpireEffect(PotionEvent.PotionExpiryEvent event) {
        Effect potion;
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)event.getEntity());
        if (SharedGlue.isaServerWorld((Entity)player) && (potion = event.getPotionEffect().func_188419_a()) == VfpPotions.BAT_SIGHTED) {
            BatSightedEffect.cleanUp((LivingEntity)player);
        }
    }
}

