/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.runtime.TooltipEnricher;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRuntimeSkeleton;

public final class VfpRuntimeSP
extends VfpRuntimeSkeleton {
    private final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static IItemColor ItemColorImplInstance = new IItemColor(){

        public int getColor(ItemStack stack, int tintIndex) {
            int color = 0xFFFFFF;
            if (!ItemStacks.isEmpty((ItemStack)stack)) {
                color = ((IMultiColored)stack.func_77973_b()).getColorFrom(stack, tintIndex);
            }
            return color;
        }
    };

    public VfpRuntimeSP() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sidedStartUp);
    }

    public final String getId() {
        return "SP";
    }

    public final boolean hasUI() {
        return true;
    }

    public PlayerEntity getClientPlayer() {
        return this.MINECRAFT.field_71439_g;
    }

    public World getClientWorld() {
        return this.MINECRAFT.field_71441_e;
    }

    public PlayerEntity getPlayer(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT ? this.MINECRAFT.field_71439_g : super.getPlayer(context);
    }

    @Override
    public void midStartUp(ModLifecycleEvent e) {
        super.midStartUp(e);
        for (Item item : VfpUtils.getItemsWithColor()) {
            this.MINECRAFT.getItemColors().func_199877_a(ItemColorImplInstance, new IItemProvider[]{item});
        }
        if (!this._mainConfig.isExtendedFoodPantryPresent() && this._mainConfig.showNutritionNotes()) {
            MinecraftForge.EVENT_BUS.register((Object)new TooltipEnricher());
        }
    }

    private void sidedStartUp(FMLClientSetupEvent event) {
        event.enqueueWork(() -> VfpObj.itemInstances.stream().filter(i -> i instanceof IItemPropertyExtender).forEach(ci -> ((IItemPropertyExtender)ci).registerPropertyOverrides()));
        if (VfpObj.Gelatin_Pantry_Block_obj != null) {
            RenderTypeLookup.setRenderLayer((Block)VfpObj.Gelatin_Pantry_Block_obj, (RenderType)RenderType.func_228645_f_());
        }
        if (VfpObj.Ink_KelpPlant_Top_obj != null) {
            RenderTypeLookup.setRenderLayer((Block)VfpObj.Ink_KelpPlant_Top_obj, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)VfpObj.Ink_KelpPlant_Body_obj, (RenderType)RenderType.func_228643_e_());
        }
    }
}

