/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Misc;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.api.ISoakable;
import org.jwaresoftware.mcmods.lib.impl.FoodItemBase;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.sandwiches.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.Sandwich;
import org.jwaresoftware.mcmods.vfp.wheat.Bread;
import org.jwaresoftware.mcmods.vfp.wheat.Minibread;

public final class DeckerSandwich
extends VfpPantryMultiItem
implements IItemPropertyExtender {
    static final String _NBT_KLINGON = "vfp:klingon";
    static final String _NBT_BEETS = "vfp:beets";
    static final String _NBT_MUSCLE = "vfp:muscle";
    static final String _NBT_EFFECTINATED = "vfp:effectinated";
    static final String _NBT_MUSCLE_AMT = "MuscleAmt";
    private static final int _GENERIC = 0;
    private static final int _KINGED = 1;
    private static final int _CHIKIN = 2;
    private static final int _OSTEAK = 3;
    private static final int _CSTEAK = 4;
    private static final int _MUTTON = 5;
    private static final int _FISH = 6;
    private static final int _VEGGIE = 7;
    private static final int _CUBAN = 8;
    private static final int _LUMBERJACK = 9;
    static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Decker_Generic.fmlid(), LikeFood.decker), new VfpVariant(1, VfpOid.Decker_Kinged.fmlid(), LikeFood.decker), new VfpVariant(2, VfpOid.Decker_Chicken.fmlid(), LikeFood.decker), new VfpVariant(3, VfpOid.Decker_Steak.fmlid(), LikeFood.decker), new VfpVariant(4, VfpOid.Decker_Cheesesteak.fmlid(), LikeFood.decker), new VfpVariant(5, VfpOid.Decker_Mutton.fmlid(), LikeFood.decker), new VfpVariant(6, VfpOid.Decker_Fish.fmlid(), LikeFood.decker), new VfpVariant(7, VfpOid.Decker_Veggie.fmlid(), LikeFood.decker), new VfpVariant(8, VfpOid.Decker_Cuban.fmlid(), LikeFood.decker), new VfpVariant(9, VfpOid.Decker_Lumberjack.fmlid(), LikeFood.decker)};
    static final NonNullList<ItemStack> SAMPLES_ARRAY = NonNullList.func_191197_a((int)VARIANT_ARRAY.length, (Object)ItemStack.field_190927_a);
    private static DeckerSandwich[] INSTANCES;
    private static final String _DELIM = "_||_";
    static ITag.INamedTag<Item> MUSCLE_FOODS;
    static boolean BUILDING_SAMPLES;
    private static final int _MAX_INGREDIENTS;
    private static final int _BONUS_EFFORT_THRESHOLD = 4;

    DeckerSandwich(VfpVariant variant) {
        super((VfpProfile)VfpOid.Decker, false, variant);
        this.autoregister();
    }

    static final boolean isGenericDecker(ItemStack decker) {
        return ((DeckerSandwich)decker.func_77973_b())._variant.index() == 0;
    }

    static final boolean isPackagedDecker(ItemStack decker) {
        DeckerSandwich deckerimpl = (DeckerSandwich)decker.func_77973_b();
        return deckerimpl._variant.index() != 0 && deckerimpl._variant.index() != 1;
    }

    static final boolean isLumberjack(ItemStack decker) {
        return ((DeckerSandwich)decker.func_77973_b())._variant.index() == 9;
    }

    static final boolean allowAnyFood() {
        return VfpConfig.getInstance().allowAnyFoodInGenericDecker();
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.decker.healAmount();
    }

    @Override
    public float getSaturationModifier(ItemStack stack) {
        float saturation = super.getSaturationModifier(stack);
        CompoundNBT instr = Instructions.get((ItemStack)stack);
        if (instr != null && instr.func_150297_b("FoodSaturation", 5)) {
            saturation = instr.func_74760_g("FoodSaturation");
        }
        return saturation;
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? 0.85f : -1.0f;
    }

    static final boolean isMuscleBoosted(ItemStack decker) {
        return ItemStacks.hasFlag((ItemStack)decker, (String)_NBT_MUSCLE, (boolean)false);
    }

    @Override
    protected boolean isRejuvenating(ItemStack eaten) {
        return DeckerSandwich.isLumberjack(eaten) && !DeckerSandwich.isMuscleBoosted(eaten);
    }

    @Override
    protected final void onPortionConsumed(ItemStack eaten, int eatenAmount, float foodSaturation, World world, PlayerEntity player) {
        super.onPortionConsumed(eaten, eatenAmount, foodSaturation, world, player);
        if (SharedGlue.isaServerWorld((IWorldReader)world) && DeckerSandwich.allowAnyFood() && INutritionSource.hasExportedIngredients((ItemStack)eaten)) {
            int totalAmount = this.getTotalFoodPoints(eaten);
            if (totalAmount <= 0) {
                return;
            }
            float duration_modifier = Math.min(1.0f, (float)eatenAmount / (float)totalAmount);
            Triple nn = INutritionSource.export((PlayerEntity)player, (ItemStack)eaten);
            ((List)nn.getLeft()).forEach(ing -> {
                Item fooditem = FoodItemBase.toFood((ItemStack)ing);
                if (fooditem != null) {
                    for (Pair p : fooditem.func_219967_s().func_221464_f()) {
                        if (!(player.func_70681_au().nextFloat() < ((Float)p.getSecond()).floatValue())) continue;
                        EffectInstance effect = (EffectInstance)p.getFirst();
                        int duration = Math.max(Math.min(Misc._1SEC_t, effect.func_76459_b()), (int)((float)effect.func_76459_b() * duration_modifier));
                        player.func_195064_c(Potions.newPotionEffect((Effect)effect.func_188419_a(), (int)duration, (int)effect.func_76458_c(), (boolean)effect.func_82720_e(), (boolean)effect.func_188418_e()));
                    }
                }
                if ((fooditem = ing.func_77973_b()) instanceof ISoakable && ((ISoakable)fooditem).isSoaked(ing)) {
                    for (EffectInstance effect : ((ISoakable)fooditem).getSoakingEffects(ing)) {
                        int duration = Math.max(2, (int)((float)effect.func_76459_b() * duration_modifier));
                        player.func_195064_c(Potions.newPotionEffect((Effect)effect.func_188419_a(), (int)duration, (int)effect.func_76458_c(), (boolean)effect.func_82720_e(), (boolean)effect.func_188418_e()));
                    }
                }
            });
        }
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(eaten, remaining, world, player);
        if (DeckerSandwich.isMuscleBoosted(eaten)) {
            int amount = Instructions.getInteger((ItemStack)eaten, (String)_NBT_MUSCLE_AMT, (int)1);
            Potions.onMuscleFoodEaten((LivingEntity)player, (int)(amount > 1 ? 5 : -1), (int)0);
        }
    }

    private boolean includeIngredientsInTooltip(boolean advancedTips) {
        return !(!advancedTips && !Tooltips.wantsFullDescriptionTip() || !VfpConfig.getInstance().isDebugMode() && !VfpConfig.getInstance().showDeckerIngredients());
    }

    private void addIngredientsInformation_(ItemStack decker, World world, List<ITextComponent> tooltip, boolean advanced) {
        String uitip;
        CompoundNBT instr = null;
        instr = Instructions.get((ItemStack)decker);
        if (instr != null && !(uitip = instr.func_74779_i("UiTip")).isEmpty()) {
            String[] lines = StringUtils.splitByWholeSeparator((String)uitip, (String)_DELIM, (int)17);
            for (int i = 0; i < lines.length; ++i) {
                ITextComponent ingredient_string = Strings.deserialize((String)lines[i]);
                if (ingredient_string == null) continue;
                tooltip.add((ITextComponent)new StringTextComponent(" + ").func_230529_a_(ingredient_string).func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    @Override
    protected void addFoodPointsInformation_(ItemStack decker, World world, List<ITextComponent> tooltip, boolean advanced) {
        TextFormatting highlighting;
        boolean muscled;
        super.addFoodPointsInformation_(decker, world, tooltip, true);
        if (this.includeIngredientsInTooltip(advanced)) {
            this.addIngredientsInformation_(decker, world, tooltip, advanced);
        }
        if (muscled = DeckerSandwich.isMuscleBoosted(decker)) {
            highlighting = TextFormatting.DARK_GREEN;
            if (Instructions.getInteger((ItemStack)decker, (String)_NBT_MUSCLE_AMT, (int)0) > 1) {
                highlighting = TextFormatting.DARK_PURPLE;
            }
            tooltip.add((ITextComponent)new StringTextComponent(" ! ").func_240699_a_(highlighting).func_230529_a_((ITextComponent)new TranslationTextComponent("item.vfp.decker.muscleboost").func_240699_a_(highlighting)));
        }
        if (ItemStacks.hasFlag((ItemStack)decker, (String)_NBT_EFFECTINATED, (boolean)false)) {
            highlighting = TextFormatting.DARK_GRAY;
            tooltip.add((ITextComponent)new StringTextComponent(" \u203c ").func_240699_a_(highlighting).func_230529_a_((ITextComponent)new TranslationTextComponent("item.vfp.decker.effectinated" + (muscled ? "_alt" : "")).func_240699_a_(highlighting)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isShowingUiTips(ItemStack decker) {
        return ItemStacks.isFlaggedAsSample((ItemStack)decker);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("muscle"), (decker, world, entity) -> DeckerSandwich.isMuscleBoosted(decker) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("variant"), (decker, world, entity) -> DeckerSandwich.isGenericDecker(decker) && ItemStacks.hasFlag((ItemStack)decker, (String)_NBT_KLINGON, (boolean)false) ? 1.0f : (ItemStacks.hasFlag((ItemStack)decker, (String)_NBT_BEETS, (boolean)false) ? 2.0f : 0.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack decker, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (ItemStacks.isFlaggedAsSample((ItemStack)decker)) {
            Tooltips.addSampleTipLine(tooltip);
            if (DeckerSandwich.isGenericDecker(decker)) {
                Tooltips.addDocTipDefault((ModIntegration)ModInfo.ID, (ItemStack)decker, tooltip);
            } else {
                Tooltips.addDocTipSharedDetails((ModIntegration)ModInfo.ID, (ItemStack)decker, tooltip, (String)"tooltip_full.vfp.decker_unstackit");
            }
            if (this.includeIngredientsInTooltip(flags.func_194127_a())) {
                this.addIngredientsInformation_(decker, world, tooltip, true);
            }
            this.addDebugInformation(decker, tooltip, flags);
        } else {
            super.func_77624_a(decker, world, tooltip, flags);
            if (!Tooltips.isHidden((ModIntegration)ModInfo.ID)) {
                Tooltips.addDocTip((ItemStack)decker, tooltip, (String)"tooltip_summ.vfp.decker_unstackit", (String)"tooltip_full.vfp.decker_unstackit", (boolean)false);
            }
        }
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        ItemStack sample;
        if (!this.isHiddenByDefault() && this.func_194125_a(tab) && !(sample = (ItemStack)SAMPLES_ARRAY.get(this._variant.index())).func_190926_b()) {
            items.add((Object)ItemStacks.copy1((ItemStack)sample));
        }
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new DeckerSandwich[VARIANT_ARRAY.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                DeckerSandwich.INSTANCES[i] = new DeckerSandwich(VARIANT_ARRAY[i]);
            }
        }
    }

    private static void buildSamples() {
        ItemStack french_bread = LikeFood.french_bread.sample(1);
        ItemStack steak = LikeFood.beef.sample(1);
        BUILDING_SAMPLES = true;
        SAMPLES_ARRAY.set(2, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.chicken.sample(1), new ItemStack((IItemProvider)VfpObj.Portion_Roasted_Veg_obj)), VfpOid.Decker_Chicken, LikeFood.chicken.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(3, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Steak, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(4, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.cheese_portion.sample(1), new ItemStack((IItemProvider)VfpObj.Sauteed_Alliums_Mushrooms_obj)), VfpOid.Decker_Cheesesteak, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(5, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.mutton.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Mutton, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(8, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.pork.sample(1), LikeFood.salt_pork.sample(1), LikeFood.cheese_portion.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Cuban, -1, -1, LikeFood.meat_pie.saturationModifier())));
        SAMPLES_ARRAY.set(6, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.salmon.sample(1), new ItemStack((IItemProvider)VfpObj.Portion_Roasted_Veg_obj)), VfpOid.Decker_Fish, LikeFood.salmon.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(7, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.roast_veg_medley.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Veggie, LikeFood.potato.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(9, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.mashed_potato.sample(), LikeFood.fried_egg.sample(), LikeFood.fried_egg.sample(), new ItemStack((IItemProvider)VfpObj.Edible_Cactus_Roasted_obj)), VfpOid.Decker_Lumberjack, -1, -1, LikeFood.golden_carrot.saturationModifier())));
        SAMPLES_ARRAY.set(0, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(LikeFood.sandwich_bread.sample(), LikeFood.roast_veg_medley.sample(), LikeFood.cheese_portion.sample(), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj), new ItemStack((IItemProvider)VfpObj.Roasted_Sunflower_Seeds_obj)), VfpOid.Decker_Generic, 0, -1, 0.0f)));
        SAMPLES_ARRAY.set(1, (Object)DeckerSandwich.marksample(DeckerSandwich.kingme(new FixedIItemHandler(Minibread.cookedEgg(1), new ItemStack((IItemProvider)VfpObj.Bat_CheeseBurger_obj), Sandwich.spamAndEgg(1)))));
        BUILDING_SAMPLES = false;
    }

    static final void setRecipeRewards() {
        GenericDeckerSandwichRecipe.initFinalize();
        DeckerSandwich.buildSamples();
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(7), VfpOid.Decker_Veggie.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(4), VfpOid.Decker_Cheesesteak.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(8), VfpOid.Decker_Cuban.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(9), VfpOid.Decker_Lumberjack.craftingXp());
    }

    public static final ItemStack empty() {
        return INSTANCES != null ? new ItemStack((IItemProvider)INSTANCES[0]) : new ItemStack((IItemProvider)Items.field_151025_P);
    }

    static final int getIngredientFoodTotal(Item food, ItemStack ingredient) {
        int ingredientTotal = food instanceof VfpPantryItem ? ((VfpPantryItem)food).getAvailableFoodPoints(ingredient) : (food instanceof INutritionSource ? (int)((INutritionSource)food).getNNCalories(ingredient) : food.func_219967_s().func_221466_a());
        return ingredientTotal;
    }

    private static final void addIngredients(ItemStack deckerSandwich, List<IngredientStats> ingredients, int foodTotal, int fpBonus, float saValue, int muscleBoost, @Nullable String variant) {
        Collections.sort(ingredients);
        if (fpBonus > 0) {
            IngredientStats stat = new IngredientStats(fpBonus);
            ingredients.add(stat);
        }
        float saturation = 0.0f;
        StringBuilder sb = new StringBuilder(150);
        NonNullList exportList = WellnessHelper.manageNutrition() ? NonNullList.func_191196_a() : null;
        for (IngredientStats ingredient : ingredients) {
            if (sb.length() > 0) {
                sb.append(_DELIM);
            }
            sb.append(Strings.serialize((ITextComponent)ingredient._foodDisplayName));
            saturation += (float)ingredient._foodPoints / (float)foodTotal * ingredient._foodSaturation;
            if (exportList == null || ingredient._food.func_190926_b()) continue;
            exportList.add((Object)ingredient._food);
        }
        if (saValue > 0.0f) {
            saturation = saValue;
        } else {
            if (saturation < LikeFood.decker.saturationModifier()) {
                saturation = LikeFood.decker.saturationModifier();
            }
            if (muscleBoost > 0) {
                saturation += LikeFood.muscle_boost.saturationModifier() * (float)muscleBoost;
            }
        }
        CompoundNBT instr = Instructions.get((ItemStack)deckerSandwich);
        instr.func_74776_a("FoodSaturation", saturation);
        instr.func_74778_a("UiTip", sb.toString());
        if (variant != null) {
            ItemStacks.setFlag((ItemStack)deckerSandwich, (String)variant, (boolean)true);
        }
        if (muscleBoost > 0) {
            ItemStacks.setFlag((ItemStack)deckerSandwich, (String)_NBT_MUSCLE, (boolean)true);
            instr.func_74768_a(_NBT_MUSCLE_AMT, muscleBoost);
        }
        if (exportList != null) {
            ItemStackHelper.func_191282_a((CompoundNBT)instr, (NonNullList)exportList);
            instr.func_74768_a("Size", exportList.size());
        }
    }

    public static final ItemStack create(IItemHandler grid, @Nonnull String oid, int recipeBonus, int maxValue, float saturationValue) {
        Validate.notNull((Object)grid, (String)"A valid non-null IItemHandler is required", (Object[])new Object[0]);
        recipeBonus = MathHelper.func_76125_a((int)recipeBonus, (int)0, (int)LikeFood.beef.healAmount());
        ItemStack deckerSandwich = ItemStack.field_190927_a;
        int foodTotal = 0;
        ArrayList<IngredientStats> stats = new ArrayList<IngredientStats>(_MAX_INGREDIENTS + 2);
        int effortBonus = 0;
        int muscleBoost = 0;
        int numEffects = 0;
        String variant = null;
        ITextComponent customName = null;
        int n = grid.getSlots();
        for (int i = 0; i < n; ++i) {
            int ingredientTotal;
            Item food;
            ItemStack ingredient = grid.getStackInSlot(i);
            if (ingredient.func_190926_b()) continue;
            Item item = ingredient.func_77973_b();
            if (item == VfpObj.Dollop_Muscle_obj) {
                ++muscleBoost;
            }
            if ((food = FoodItemBase.toFood((ItemStack)ingredient)) == null) {
                if (item != VfpObj.Sandwich_Press_Plate_obj || !ingredient.func_82837_s()) continue;
                customName = ingredient.func_200301_q();
                continue;
            }
            if (!BUILDING_SAMPLES) {
                if (Bread.isKlingon(ingredient)) {
                    variant = _NBT_KLINGON;
                } else if (Bread.isBeets(ingredient)) {
                    variant = _NBT_BEETS;
                } else if (food == VfpObj.Ravager_Cooked_obj || item.func_206844_a(MUSCLE_FOODS)) {
                    ++muscleBoost;
                } else if (!food.func_219967_s().func_221464_f().isEmpty()) {
                    ++numEffects;
                } else if (item instanceof ISoakable && ((ISoakable)item).isSoaked(ingredient)) {
                    ++numEffects;
                }
            }
            if ((ingredientTotal = DeckerSandwich.getIngredientFoodTotal(food, ingredient)) <= 0) continue;
            foodTotal += ingredientTotal;
            IngredientStats stat = new IngredientStats(ingredient, food);
            stat._foodPoints = ingredientTotal;
            stats.add(stat);
            if (stats.size() == _MAX_INGREDIENTS) break;
        }
        if (foodTotal > 0) {
            int index = 0;
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (!oid.equals(VARIANT_ARRAY[i].fmlid())) continue;
                index = i;
                break;
            }
            if (stats.size() > 4) {
                effortBonus = stats.size() - 3;
                foodTotal += effortBonus;
            }
            if (maxValue < 1) {
                maxValue = VfpConfig.maxFoodPointsPerMultiuseFood();
            }
            foodTotal = MathHelper.func_76125_a((int)foodTotal, (int)LikeFood.decker.healAmount(), (int)maxValue);
            deckerSandwich = DeckerSandwich.createMultiuseInstance((Item)INSTANCES[index], 1, foodTotal + recipeBonus, LikeFood.decker.healAmount());
            DeckerSandwich.addIngredients(deckerSandwich, stats, foodTotal, effortBonus, saturationValue, muscleBoost, variant);
            if (numEffects > 0) {
                ItemStacks.setFlag((ItemStack)deckerSandwich, (String)_NBT_EFFECTINATED, (boolean)true);
            }
            if (customName != null) {
                deckerSandwich.func_200302_a(customName);
            }
        }
        return deckerSandwich;
    }

    private static final ItemStack create(IItemHandler grid, VfpOid what, int recipeBonus, int maxValue, float saturationValue) {
        return DeckerSandwich.create(grid, what.fmlid(), recipeBonus, maxValue, saturationValue);
    }

    public static final ItemStack create(IItemHandler grid) {
        return DeckerSandwich.create(grid, VfpOid.Decker_Generic, 0, -1, 0.0f);
    }

    static final ItemStack marksample(ItemStack stack) {
        ItemStacks.setSampleFlag((ItemStack)stack);
        return stack;
    }

    public static final ItemStack kingme(IItemHandler grid) {
        return DeckerSandwich.create(grid, VfpOid.Decker_Kinged, 0, LikeFood.TOWERING_MEGAWICH.healAmount(), 0.0f);
    }

    static final NonNullList<ItemStack> deckerSamples() {
        NonNullList samples = NonNullList.func_191196_a();
        for (ItemStack sample : SAMPLES_ARRAY) {
            if (ItemStacks.isEmpty((ItemStack)sample)) continue;
            samples.add((Object)ItemStacks.copy1((ItemStack)sample));
        }
        return samples;
    }

    static {
        MUSCLE_FOODS = RID.Tags.forOptionalItems((String)ModInfo.rstring("muscle_edibles"));
        BUILDING_SAMPLES = false;
        _MAX_INGREDIENTS = SharedGlue.TABLE_CRAFT_GRID_SIZE();
    }

    static final class FixedIItemHandler
    implements IItemHandler {
        private final ItemStack[] _items;

        FixedIItemHandler(ItemStack ... items) {
            this._items = items;
        }

        public int getSlotLimit(int slot) {
            return SharedGlue.MAX_STACK_SIZE();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return this._items.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 0 || slot > this._items.length ? ItemStack.field_190927_a : this._items[slot];
        }
    }

    private static final class IngredientStats
    implements Comparable<IngredientStats> {
        public ITextComponent _foodDisplayName;
        public int _foodPoints;
        public float _foodSaturation;
        public ItemStack _food = ItemStack.field_190927_a;

        IngredientStats(int foodpoints) {
            this._foodDisplayName = new TranslationTextComponent("item.vfp.decker.bonus");
            this._foodPoints = foodpoints;
            this._foodSaturation = 10.0f / (float)foodpoints;
        }

        IngredientStats(ItemStack stack, Item food) {
            this._foodDisplayName = stack.func_200301_q();
            this._foodSaturation = food.func_219967_s().func_221469_b();
            this._food = ItemStacks.copy1((ItemStack)stack);
        }

        @Override
        public int compareTo(IngredientStats o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return this._foodDisplayName.getString().compareTo(o._foodDisplayName.getString());
        }
    }
}

