/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.DeckerSandwich;

public final class DefinedDeckerSandwichRecipe
extends VfpRecipe {
    final Serializer _serializer;
    final ShapedRecipe _layout;
    final int _bonusPts;
    final float _satValue;

    DefinedDeckerSandwichRecipe(Serializer serializer, int bonusPts, float saturationOverride, ShapedRecipe impl) {
        super(impl.func_199560_c());
        this._serializer = serializer;
        this._layout = impl;
        this._bonusPts = Math.max(0, bonusPts);
        this._satValue = Math.max(0.0f, saturationOverride);
    }

    public boolean matches(CraftingInventory grid, World world) {
        return this._layout.func_77569_a(grid, world);
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return this._layout.func_194133_a(width, height);
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        return DeckerSandwich.create((IItemHandler)new InvWrapper((IInventory)grid), this._serializer.decker_id(), this._bonusPts, -1, this._satValue);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return this._layout.func_179532_b((IInventory)grid);
    }

    public final ShapedRecipe templateRecipe() {
        return this._layout;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this._serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DefinedDeckerSandwichRecipe> {
        public static final Serializer CHEESESTEAK = new Serializer(VfpOid.Decker_Cheesesteak.fmlid());
        public static final Serializer CHICKEN = new Serializer(VfpOid.Decker_Chicken.fmlid());
        public static final Serializer CUBAN = new Serializer(VfpOid.Decker_Cuban.fmlid());
        public static final Serializer LUMBERJACK = new Serializer(VfpOid.Decker_Lumberjack.fmlid());
        public static final Serializer MUTTON = new Serializer(VfpOid.Decker_Mutton.fmlid());
        public static final Serializer ONIONSTEAK = new Serializer(VfpOid.Decker_Steak.fmlid());
        public static final Serializer FISH = new Serializer(VfpOid.Decker_Fish.fmlid());
        public static final Serializer VEGGIE = new Serializer(VfpOid.Decker_Veggie.fmlid());
        private final String _decker_id;

        public static final void registerAll(@Nonnull IForgeRegistry<IRecipeSerializer<?>> serializers) {
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)CHEESESTEAK.setRegistryName(ModInfo.rstring("cheesesteak_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)CHICKEN.setRegistryName(ModInfo.rstring("roast_chicken_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)CUBAN.setRegistryName(ModInfo.rstring("cubano_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)LUMBERJACK.setRegistryName(ModInfo.rstring("lumberjack_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)MUTTON.setRegistryName(ModInfo.rstring("roast_mutton_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)ONIONSTEAK.setRegistryName(ModInfo.rstring("onionsteak_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)FISH.setRegistryName(ModInfo.rstring("tasty_fish_decker_shaped"))));
            serializers.register((IForgeRegistryEntry)((IRecipeSerializer)VEGGIE.setRegistryName(ModInfo.rstring("fresh_veggie_decker_shaped"))));
        }

        Serializer(String decker_id) {
            this._decker_id = decker_id;
        }

        public DefinedDeckerSandwichRecipe read(ResourceLocation recipeId, JsonObject json) {
            int bonusPts = JSONUtils.func_151208_a((JsonObject)json, (String)"food_bonus", (int)0);
            float satModifier = JSONUtils.func_151221_a((JsonObject)json, (String)"saturation", (float)-1.0f);
            ShapedRecipe impl = JR.readShaped((ResourceLocation)recipeId, (JsonObject)json);
            return new DefinedDeckerSandwichRecipe(this, bonusPts, satModifier, impl);
        }

        public void write(PacketBuffer data, DefinedDeckerSandwichRecipe recipe) {
            data.func_150787_b(recipe._bonusPts);
            data.writeFloat(recipe._satValue);
            JR.writeShaped((PacketBuffer)data, (ShapedRecipe)recipe._layout);
        }

        public DefinedDeckerSandwichRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            int bonusPts = data.func_150792_a();
            float satModifier = data.readFloat();
            ShapedRecipe impl = JR.readShaped((ResourceLocation)recipeId, (PacketBuffer)data);
            return new DefinedDeckerSandwichRecipe(this, bonusPts, satModifier, impl);
        }

        final String decker_id() {
            return this._decker_id;
        }
    }
}

