/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpMultiUseJarIngredient;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;

public class DrinkSyrup
extends VfpMultiUseJarIngredient
implements IMultiColored,
FoodColor,
IVariant {
    public static final int MAX_USES = 3;
    private static DrinkSyrup[] INSTANCES;
    private static final String[] FLAVOR_NAMES;
    private static final int _NO_COLOR = 0xFFFFFF;
    @Nonnull
    private final Flavor _flavor;

    DrinkSyrup(Flavor flavor) {
        super(VfpOid.Drink_Syrup.derivative(flavor.name_lowercased()), 3, false);
        this._flavor = flavor;
        this._hidden = flavor == Flavor.SYRUP;
        this.setModelLocation(VfpOid.Drink_Syrup.fmlid());
    }

    @Nullable
    public static final Flavor getFlavor(ItemStack stack) {
        if (INSTANCES != null && DrinkSyrup.isa(stack)) {
            Item item = stack.func_77973_b();
            for (DrinkSyrup syrup : INSTANCES) {
                if (syrup != item) continue;
                return syrup._flavor;
            }
        }
        return null;
    }

    @Nonnull
    public static Flavor getIngredientFlavor(String syrup) {
        Flavor flavor = Flavor.SYRUP;
        if (syrup != null) {
            try {
                flavor = Flavor.valueOf(syrup.toUpperCase(Locale.US));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return flavor;
    }

    @Override
    public ItemStack getNewEmptyContainer(@Nonnull ItemStack syrup) {
        return new ItemStack((IItemProvider)VfpObj.Our_Empty_Bottle_obj);
    }

    public int getColorFrom(ItemStack stack, int tintIndex) {
        return tintIndex <= 0 ? this.color(stack) : 0xFFFFFF;
    }

    @Override
    public int color(ItemStack stack) {
        int color = 0xFFFFFF;
        if (DrinkSyrup.isa(stack)) {
            Flavor flavor = ((DrinkSyrup)stack.func_77973_b())._flavor;
            color = flavor.color();
        }
        return color;
    }

    public String varid() {
        return this.oid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 1; i < INSTANCES.length; ++i) {
            all.add(new ItemStack((IItemProvider)INSTANCES[i]));
        }
        return all;
    }

    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() && !this._hidden ? false : this._hidden || !DrinkSyrup.isAvailable(this._flavor);
    }

    @Override
    public ITextComponent func_200295_i(ItemStack syrup) {
        TranslationTextComponent flavor_string = new TranslationTextComponent("label.vfp.drink_syrup_" + this._flavor.name_lowercased());
        return new TranslationTextComponent("item.vfp.drink_syrup", new Object[]{flavor_string});
    }

    static void makeObjects() {
        if (INSTANCES == null) {
            Flavor[] flavors = Flavor.values();
            INSTANCES = new DrinkSyrup[flavors.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                DrinkSyrup.INSTANCES[i] = new DrinkSyrup(flavors[i]);
            }
        }
    }

    public static final boolean isAvailable(@Nullable Flavor flavor) {
        return flavor == null ? false : flavor.isAlwaysPresent() || flavor.foodPowder().isCraftable();
    }

    static {
        Flavor[] flavors = Flavor.values();
        FLAVOR_NAMES = new String[flavors.length];
        for (int i = 0; i < flavors.length; ++i) {
            DrinkSyrup.FLAVOR_NAMES[i] = i == 0 ? "plain" : "" + flavors[i].name_lowercased();
        }
    }

    public static enum Flavor {
        SYRUP(true, 14671579, true, false, FoodPowder.Type.SYRUP),
        APPLE(true, 16773841, true, true, FoodPowder.Type.APPLE),
        MELON(true, 0xFFBBBB, 0xFFD4D4, true, true, FoodPowder.Type.MELON),
        CHORUSFRUIT(true, 0xBA9BBA, 13150152, false, true, FoodPowder.Type.CHORUSFRUIT),
        CHOCOLATE(true, 3414272, 9396536, false, true, FoodPowder.Type.COCOA),
        BERRY(true, 16733536, false, true, FoodPowder.Type.BERRY_MIX),
        CITRUS(false, 13563136, true, true, FoodPowder.Type.CITRUS_MIX),
        MANGO(false, 16759296, false, true, FoodPowder.Type.MANGO),
        PINEAPPLE(false, 16769875, true, true, FoodPowder.Type.PINEAPPLE),
        COCONUT(false, 0xF5F5F5, 0xFFF5DD, false, false, FoodPowder.Type.COCONUT),
        MOCHA(false, 7289344, 10776384, false, true, FoodPowder.Type.MOCHA_MIX);

        private String _lc_name;
        private final boolean _vanillaFlag;
        private final int _colorValue;
        private int _lightcolorValue;
        private FoodPowder.Type _foodPowder;
        private final boolean _iceeeFlag;
        private final boolean _sodaFlag;

        private Flavor(boolean builtin, int colorValue, int lightcolorValue, boolean iceee, boolean soda, FoodPowder.Type fp) {
            this._vanillaFlag = builtin;
            this._colorValue = colorValue;
            this._lightcolorValue = lightcolorValue;
            this._foodPowder = Objects.requireNonNull(fp);
            this._iceeeFlag = iceee;
            this._sodaFlag = soda;
            this._lc_name = this.name().toLowerCase(Locale.US);
        }

        private Flavor(boolean builtin, int colorValue, boolean iceee, boolean drink, FoodPowder.Type fp) {
            this(builtin, colorValue, 0, iceee, drink, fp);
        }

        public String name_lowercased() {
            return this._lc_name;
        }

        public int color() {
            return this._colorValue;
        }

        public int lightcolor() {
            return this._lightcolorValue == 0 ? this._colorValue : this._lightcolorValue;
        }

        @Nonnull
        public final FoodPowder.Type foodPowder() {
            return this._foodPowder;
        }

        public final boolean isIceee() {
            return this._iceeeFlag;
        }

        public final boolean isSodaFlavor(boolean creamy) {
            return this._sodaFlag;
        }

        public final boolean isAlwaysPresent() {
            return this._vanillaFlag;
        }
    }
}

