/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.ITiny;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;

public class HoneyPortion
extends VfpPantryItem
implements IEssential,
ICurative,
ITiny {
    protected HoneyPortion(VfpOid oid, LikeFood like) {
        super(oid, like, null);
        this.setAlwaysEdible();
        Potions.addMilkBasedRegenEffect((Item)this, (int)this.getPotionEffectDurationSecs(true), (int)0);
        this.autoregister();
    }

    public HoneyPortion() {
        this(VfpOid.Portion_Honey, LikeFood.water);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.CureProfiles.applyForPoison((LivingEntity)player);
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack portion) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)portion);
        this.onFoodEaten(portion, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 3 : super.getPotionEffectDurationSecs(good);
    }
}

