/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.client.TemperatureItemProperty;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrup;

public final class ItalianSoda
extends VfpLiquidFood
implements IReheatable,
IMultiColored,
IVariant,
IItemPropertyExtender {
    private final boolean _creamyFlag;

    public ItalianSoda(VfpProfile profile, LikeFood like, boolean creamy) {
        super(profile, like, LiquidType.FIZZY);
        this._creamyFlag = creamy;
        this.autoregister();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Nonnull
    private DrinkSyrup.Flavor getFlavor(ItemStack soda) {
        DrinkSyrup.Flavor out = null;
        String syrup_name = (String)IVariant.BYNAME_LOOKUP.apply(soda, "");
        if (!syrup_name.isEmpty()) {
            out = DrinkSyrup.getIngredientFlavor(syrup_name);
        }
        return out == null ? DrinkSyrup.Flavor.SYRUP : out;
    }

    public static final boolean setFlavor(ItemStack soda, ItemStack syrup) {
        boolean done = false;
        DrinkSyrup.Flavor flavor = DrinkSyrup.getFlavor(syrup);
        if (flavor != null && !ItemStacks.isEmpty((ItemStack)soda)) {
            IVariant.BYNAME_STORAGE.accept(soda, flavor.name());
            done = true;
        }
        return done;
    }

    public int getColorFrom(ItemStack soda, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0 && (color_num = this.getFlavor(soda).color()) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    public void onCookedOrCrafted(ItemStack soda) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(soda);
        super.onCookedOrCrafted(soda);
        if (ITemperatureChangeable.UsedEffect.COOLED.equals((Object)e)) {
            this.setCooled(soda);
        }
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (this._creamyFlag) {
            Potions.CureProfiles.applyForMilk((LivingEntity)player);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (VfpConfig.manageTemperature()) {
            int baseDuration = this.getBonusTemperatureTimeLeftForApply(original, -1);
            WellnessHelper.coolIfHot((LivingEntity)player, (int)1, (int)baseDuration, (int)0);
        }
    }

    public void func_77663_a(ItemStack soda, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(soda, world, holder, slotindex, selected);
    }

    public ITextComponent func_200295_i(ItemStack soda) {
        TranslationTextComponent flavor_string = new TranslationTextComponent("label.vfp.drink_syrup_" + this.getFlavor(soda).name_lowercased());
        return new TranslationTextComponent("item.vfp." + this._oid, new Object[]{flavor_string});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        TemperatureItemProperty.addCoolable((Item)this);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && this.func_194125_a(group)) {
            boolean always = VfpConfig.getInstance().showAllItemsInUI();
            for (DrinkSyrup.Flavor flavor : DrinkSyrup.Flavor.values()) {
                if (!flavor.isSodaFlavor(this._creamyFlag) || !always && !DrinkSyrup.isAvailable(flavor)) continue;
                ItemStack soda = this.createInstance((Item)this);
                IVariant.BYNAME_STORAGE.accept(soda, flavor.name());
                items.add((Object)soda);
            }
        }
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> allflavors = new ArrayList<ItemStack>(13);
        for (DrinkSyrup.Flavor flavor : DrinkSyrup.Flavor.values()) {
            if (!flavor.isSodaFlavor(this._creamyFlag)) continue;
            ItemStack soda = this.createInstance((Item)this, 1);
            IVariant.BYNAME_STORAGE.accept(soda, flavor.name());
            allflavors.add(soda);
        }
        return allflavors;
    }

    @Override
    public boolean isHiddenByDefault() {
        VfpConfig config = VfpConfig.getInstance();
        return !config.showAllItemsInUI() && !config.isExtendedFoodPantryPresent();
    }
}

