/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class SimpleCookie
extends VfpSoakableFood
implements IVariant {
    private static final List<Ingredient> VARIANTS = new ArrayList<Ingredient>();
    private static SimpleCookie[] INSTANCES;

    public static final boolean register(Ingredient ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null ingredient is required for a cookie", (Object[])new Object[0]);
        boolean added = false;
        if (!VARIANTS.contains(ingredient)) {
            VARIANTS.add(ingredient);
            added = true;
        }
        return added;
    }

    public static final boolean register(String cookieName, Item ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null cookie flavor ingredient is required", (Object[])new Object[0]);
        return SimpleCookie.register(new Ingredient(cookieName, 0, new ItemStackDef(ingredient)));
    }

    public SimpleCookie(VfpVariant variant) {
        super((VfpProfile)VfpOid.Cookie, false, variant);
        this.setInstaConsume();
        this.autoregister();
    }

    public final String varid() {
        return this._variant.name();
    }

    public final List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (SimpleCookie cookie : INSTANCES) {
            all.add(cookie.createInstance((Item)cookie));
        }
        all.add(new ItemStack((IItemProvider)Items.field_151106_aX));
        return all;
    }

    static final void makeObjects() {
        if (INSTANCES == null && !VARIANTS.isEmpty()) {
            INSTANCES = new SimpleCookie[VARIANTS.size()];
            String basename = VfpOid.Cookie.fmlid() + "_";
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient ingredient = VARIANTS.get(i);
                String fmlid = basename + ingredient.name().toLowerCase(Locale.US);
                SimpleCookie.INSTANCES[i] = new SimpleCookie(new VfpTransientVariant(i, fmlid, LikeFood.cookie, ingredient, null));
            }
            VARIANTS.clear();
        }
    }
}

