/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrup;
import org.jwaresoftware.mcmods.vfp.sugar.Gelo;

public final class Snocone
extends VfpSoakableFood
implements IMultiColored,
IVariant {
    private static final int _SNOCONE = 0;
    private static final int _ICEEE = 1;
    private static final List<DrinkSyrup.Flavor> CONE_FLAVORS = new ArrayList<DrinkSyrup.Flavor>(23);
    private static Snocone[] INSTANCES;

    public static final boolean register(DrinkSyrup.Flavor flavor) {
        Validate.notNull((Object)((Object)flavor), (String)"A non-null flavor is required for a snocone", (Object[])new Object[0]);
        boolean added = false;
        if (!CONE_FLAVORS.contains((Object)flavor)) {
            CONE_FLAVORS.add(flavor);
            added = true;
        }
        return added;
    }

    Snocone(VfpVariant variant) {
        super((VfpProfile)VfpOid.Snocone, false, variant);
        this.setAlwaysEdible();
        WellnessHelper.addEnergizedEffects((Item)this, (int)60, (int)0);
        this.autoregister();
    }

    public String oid() {
        return this._variant.metadata() == 1 ? VfpOid.Iceee.fmlid() : VfpOid.Snocone.fmlid();
    }

    @Nonnull
    private DrinkSyrup.Flavor flavorFrom() {
        return this._variant.datadata(DrinkSyrup.Flavor.class);
    }

    public final boolean isSyrupSno() {
        return this.flavorFrom() == DrinkSyrup.Flavor.SYRUP;
    }

    public int getColorFrom(ItemStack snocone, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0) {
            DrinkSyrup.Flavor flavor = this.flavorFrom();
            if (flavor != DrinkSyrup.Flavor.SYRUP) {
                color_num = flavor.lightcolor();
                if (color_num == 0) {
                    color_num = default_color_num;
                }
            } else if (this.isSoaked(snocone)) {
                color_num = ItemSupport.getColorFromMoonshine((ItemStack)snocone, (int)tintIndex);
            }
        }
        return color_num;
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (VfpConfig.manageTemperature()) {
            WellnessHelper.coolIfHot((LivingEntity)player, (int)2, (int)120);
        }
    }

    public final String varid() {
        return this._variant.name();
    }

    public final List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (Snocone snocone : INSTANCES) {
            all.add(snocone.createInstance((Item)snocone));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !DrinkSyrup.isAvailable(this.flavorFrom());
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(17);
            variants.add(new VfpTransientVariant(1, VfpOid.Snocone.fmlid(), LikeFood.sugarbomb, (Object)DrinkSyrup.Flavor.SYRUP, null));
            String basename = VfpOid.Snocone.fmlid() + "_";
            for (DrinkSyrup.Flavor flavor : CONE_FLAVORS) {
                if (flavor == DrinkSyrup.Flavor.SYRUP) continue;
                String fmlid = basename + flavor.name_lowercased();
                LikeFood likeFood = Gelo.like(FoodPowder.toIngredient(flavor.foodPowder(), null, null));
                if (likeFood.healAmount() < LikeFood.sugarbomb.healAmount()) {
                    likeFood = LikeFood.sugarbomb;
                }
                int m = flavor.isIceee() ? 1 : 0;
                variants.add(new VfpTransientVariant(m, fmlid, likeFood, (Object)flavor, null));
                if (m == 1) continue;
                fmlid = fmlid + "_plain";
                variants.add(new VfpTransientVariant(1, fmlid, likeFood, (Object)flavor, null));
            }
            INSTANCES = new Snocone[variants.size()];
            for (int i = 0; i < INSTANCES.length; ++i) {
                Snocone.INSTANCES[i] = new Snocone((VfpVariant)variants.get(i));
            }
            CONE_FLAVORS.clear();
        }
    }
}

