/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Misc;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpMarkerPotion;

public final class BatSightedEffect
extends VfpMarkerPotion {
    public BatSightedEffect(String name, int effectColor, boolean milkCures) {
        super(name, true, false, effectColor, milkCures);
    }

    @Override
    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public static final void cleanUp(LivingEntity source) {
        if (SharedGlue.isaServerWorld((Entity)source)) {
            ServerWorld world = (ServerWorld)source.func_130014_f_();
            ServerScoreboard scoreboard = world.func_73046_m().func_200251_aP();
            new Teams((Scoreboard)scoreboard, false).cleanUp((Scoreboard)scoreboard);
        }
    }

    public void func_76394_a(LivingEntity source, int amplifier) {
        if (source.func_70644_a((Effect)this) && SharedGlue.isaRealPlayer((Entity)source) && SharedGlue.isaServerWorld((Entity)source)) {
            ServerWorld world = (ServerWorld)source.func_130014_f_();
            ServerScoreboard scoreboard = world.func_73046_m().func_200251_aP();
            Teams teams = new Teams((Scoreboard)scoreboard, true);
            double x = source.func_226277_ct_();
            double y = source.func_226278_cu_();
            double z = source.func_226281_cx_();
            AxisAlignedBB aabb = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(70.0).func_72321_a(0.0, (double)world.func_217301_I(), 0.0);
            List set = world.func_175647_a(LivingEntity.class, aabb, (Predicate)new Spottable(source));
            for (LivingEntity e : set) {
                if (SharedGlue.isAnyMonsterOrPiOoed((Entity)e, (LivingEntity)source)) {
                    scoreboard.func_197901_a(e.func_195047_I_(), teams.hostiles);
                } else if (SharedGlue.isaPassiveEntity((Entity)e)) {
                    scoreboard.func_197901_a(e.func_195047_I_(), teams.non_hostilesT);
                } else if (!SharedGlue.isaPlayer((Entity)e)) {
                    scoreboard.func_197901_a(e.func_195047_I_(), teams.non_hostilesW);
                }
                e.func_195064_c(new EffectInstance(SharedGlue.Potion_glowing, Misc._1SEC_t, 0, true, false, false));
            }
            int ticks_left = source.func_70660_b((Effect)this).func_76459_b();
            if (ticks_left <= 5) {
                teams.cleanUp((Scoreboard)scoreboard);
            }
        }
    }

    static final class Teams {
        static final String _HOSTILES = "hostiles";
        static final String _NON_HOSTILES_TERRA = "nonhostileT";
        static final String _NON_HOSTILES_WATER = "nonhostileW";
        @Nullable
        ScorePlayerTeam hostiles;
        @Nullable
        ScorePlayerTeam non_hostilesT;
        @Nullable
        ScorePlayerTeam non_hostilesW;

        Teams(@Nonnull Scoreboard scoreboard, boolean createIfMissing) {
            this.hostiles = Teams.createTeam(createIfMissing, scoreboard, _HOSTILES, TextFormatting.RED);
            this.non_hostilesT = Teams.createTeam(createIfMissing, scoreboard, _NON_HOSTILES_TERRA, TextFormatting.GREEN);
            this.non_hostilesW = Teams.createTeam(createIfMissing, scoreboard, _NON_HOSTILES_WATER, TextFormatting.BLUE);
        }

        final void cleanUp(@Nonnull Scoreboard scoreboard) {
            Teams.removeTeam(scoreboard, this.non_hostilesT);
            Teams.removeTeam(scoreboard, this.hostiles);
            Teams.removeTeam(scoreboard, this.non_hostilesW);
        }

        private static final String teamid(String name) {
            return "vfp." + name;
        }

        @Nullable
        private static final ScorePlayerTeam createTeam(boolean forced, Scoreboard scoreboard, String name, TextFormatting color) {
            String teamid = Teams.teamid(name);
            if (scoreboard.func_96531_f().contains(teamid)) {
                return scoreboard.func_96508_e(teamid);
            }
            if (!forced) {
                return null;
            }
            ScorePlayerTeam team = scoreboard.func_96527_f(teamid);
            team.func_96664_a((ITextComponent)new TranslationTextComponent("label.vfp.team.bat_sonar." + name));
            team.func_178774_a(color);
            return team;
        }

        private static final void removeTeam(@Nonnull Scoreboard scoreboard, @Nullable ScorePlayerTeam team) {
            if (team != null && scoreboard.func_96531_f().contains(team.func_96661_b())) {
                scoreboard.func_96511_d(team);
            }
        }
    }

    static final class Spottable
    implements Predicate<LivingEntity> {
        final LivingEntity _source;

        Spottable(LivingEntity e) {
            this._source = e;
        }

        @Override
        public boolean test(LivingEntity target) {
            boolean include;
            boolean bl = include = target != this._source && EntityPredicates.field_180132_d.test(target);
            if (include && SharedGlue.isaRealPlayer((Entity)target) && (LibConfig.fairplayPVP() || target.func_70644_a(SharedGlue.Potion_invisibility))) {
                include = false;
            }
            return include;
        }
    }
}

