/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class BootlegGelo
extends VfpLiquidNonFood
implements IMultiColored,
IEssential,
ICurative {
    public BootlegGelo() {
        super((VfpProfile)VfpOid.Bootleg_Gelo, LiquidType.TRACE);
        this._instaDrinkingAllowed = true;
        this.autoregister();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return null;
    }

    public ItemStack createInstance(Item item, int amount) {
        ItemStack gelo = new ItemStack((IItemProvider)item, amount);
        TonicDrink.initDefaultEffect(gelo);
        return gelo;
    }

    @Override
    protected int getRegularItemUseDuration() {
        return SharedGlue.SHORT_FOOD_CONSUME_DURATION();
    }

    @Override
    protected UseAction getRegularItemUseAction() {
        return UseAction.EAT;
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack gelo) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)gelo);
        this.onDrinkDrunk(gelo, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.addPotionEffects((LivingEntity)player, (ItemStack)original);
    }

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        return remaining;
    }

    public int getColorFrom(ItemStack gelo, int tintIndex) {
        return TonicDrink.getColorFromMoonshine(gelo, tintIndex);
    }

    public void onCookedOrCrafted(ItemStack gelo) {
        if (!Potions.isa((ItemStack)gelo, (boolean)true)) {
            TonicDrink.initDefaultEffect(gelo);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        return TonicDrink.initDefaultEffect(super.func_190903_i());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack tonic, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        Potions.addPotionInformation((Collection)Potions.getEffects((ItemStack)tonic, (boolean)false), tooltip, (boolean)true);
        super.func_77624_a(tonic, world, tooltip, flags);
    }

    static final boolean isa(ItemStack stack) {
        return stack.func_77973_b() == VfpObj.Bootleg_Gelo_obj;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull ItemStack origin, @Nonnull Collection<EffectInstance> effects) {
        ItemStack gelo = new ItemStack((IItemProvider)VfpObj.Bootleg_Gelo_obj);
        Potions.copyDefinition((ItemStack)gelo, effects, (Integer)Potions.getColorOrNull((ItemStack)origin, effects));
        return gelo;
    }
}

