/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.advancements.PlayerEarnedTrigger;
import org.jwaresoftware.mcmods.lib.api.IConsumable;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class KelpShake
extends TonicDrink {
    public static final Food FOOD_STAT = LikeFood.kelp_shake.food_stat().func_221453_d();
    private static final Map<String, Boolean> _SHAKE_CURES = Potions.CureProfiles.newopts(m -> {
        m.put("forced", true);
        m.put("combatant", false);
        m.put("boosted", false);
    });

    public KelpShake() {
        super((VfpProfile)VfpOid.Kelp_Shake, LiquidType.PLANTMILK);
    }

    @Override
    protected int getRegularItemUseDuration() {
        return SharedGlue.HEARTY_FOOD_CONSUME_DURATION();
    }

    public boolean func_219971_r() {
        return true;
    }

    public Food func_219967_s() {
        return FOOD_STAT;
    }

    @Override
    protected boolean isFortified(ItemStack shake) {
        return true;
    }

    public float getNNSaturationModifier() {
        return FOOD_STAT.func_221469_b();
    }

    public float getNNHealAmount() {
        return FOOD_STAT.func_221466_a();
    }

    public long getNNCheckList(ItemStack shake) {
        return NutritionNote.VEGAN.bit();
    }

    @Override
    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        ServerPlayerEntity mp = SharedGlue.getPlayerMPOrNull((Entity)player);
        if (mp != null) {
            Potions.CureProfiles.applyForMilk((LivingEntity)player, _SHAKE_CURES);
        }
        player.func_71024_bL().func_75122_a(FOOD_STAT.func_221466_a(), FOOD_STAT.func_221469_b());
        super.onDrinkDrunk(original, remaining, world, player);
        if (mp != null) {
            PlayerEarnedTrigger.doApply((ServerPlayerEntity)mp, (ResourceLocation)ModInfo.r("kelp_help"));
        }
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnDrunk(original, remaining, world, player);
        Potions.addFortifiedPotionEffect((LivingEntity)player, (Effect)VfpPotions.KELPED, (int)180, (int)0, (boolean)false, (boolean)false);
    }

    @Override
    public int getColorFrom(ItemStack shake, int drawLayer) {
        return drawLayer <= 0 ? 8033837 : -1;
    }

    @Override
    public ITextComponent func_200295_i(ItemStack shake) {
        return new TranslationTextComponent(this.func_77667_c(shake));
    }

    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !VfpConfig.getInstance().isDebugMode();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack shake, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        tooltip.add((ITextComponent)new TranslationTextComponent(Strings.tooltipKey((String)"itemsuffix.fortified")).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.DARK_PURPLE}));
        if (this.isShowingUiTips(shake)) {
            Tooltips.addDocTipDefault((ItemStack)shake, tooltip);
        }
        VfpPantryItem.addDebugInformation((IConsumable)this, shake, tooltip);
    }
}

