/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.recipes.ShapelessRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.tonics.BasicTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.BootlegGelo;
import org.jwaresoftware.mcmods.vfp.tonics.CompositeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public class SoakFoodShapelessRecipe
extends ShapelessRecipeWrapping {
    public static final String NAME = ModInfo.rstring("potion_soaked_shapeless");
    public static final ShapelessRecipeWrapping.Serializer<SoakFoodShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer(SoakFoodShapelessRecipe::new);

    SoakFoodShapelessRecipe(ShapelessRecipe from) {
        super(from);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        return SoakFoodShapelessRecipe.getCraftedSoakedFood(grid, this.func_77571_b());
    }

    static final ItemStack getCraftedSoakedFood(CraftingInventory grid, ItemStack recipe_output) {
        List<EffectInstance> effects;
        ItemStack out = ItemStack.field_190927_a;
        if (!VfpConfig.getInstance().allowMoonshineMixing()) {
            return out;
        }
        ItemStack item_prototoype = null;
        int n_spread = 0;
        ItemStack potionsource = null;
        boolean use_result = false;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            if (TonicDrink.isa(next) || Potions.isap((ItemStack)next, (boolean)true)) {
                if (potionsource != null) {
                    return out;
                }
                potionsource = next;
                continue;
            }
            if (RID.matches((ItemStack)next, (String)"nuggets/gold", (Item)Items.field_151074_bl)) {
                use_result = true;
                continue;
            }
            if (Potions.isa((ItemStack)next, (boolean)true)) {
                return out;
            }
            if (item_prototoype == null) {
                item_prototoype = next;
            } else if (!ItemStacks.areEqualIgnoreAmountsAndTags((ItemStack)next, (ItemStack)item_prototoype)) {
                return out;
            }
            if (++n_spread <= 1 || item_prototoype.func_77985_e()) continue;
            return out;
        }
        if (potionsource != null && item_prototoype != null && !(effects = Potions.getEffects(potionsource, (boolean)true)).isEmpty()) {
            if (use_result && (n_spread > 1 || ItemStacks.isEmpty((ItemStack)recipe_output))) {
                return out;
            }
            if ((effects = CompositeTonicRecipe.splitEffects(effects, n_spread)).isEmpty()) {
                return out;
            }
            if (use_result) {
                out = ItemStacks.copy1((ItemStack)recipe_output);
                PotionUtils.func_185184_a((ItemStack)out, effects);
            } else if (item_prototoype.func_77973_b() == VfpObj.Gelatin_Ball_obj) {
                out = BootlegGelo.create(potionsource, effects);
            } else {
                out = ItemStacks.copy1((ItemStack)item_prototoype);
                PotionUtils.func_185184_a((ItemStack)out, effects);
            }
            out.func_190920_e(n_spread);
        }
        return out;
    }
}

