/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class TonicDrink
extends VfpLiquidNonFood
implements IMultiColored,
IEssential,
ICurative {
    private static final String _NBT_FORTIFIED = "vfp_TonicFortified";

    protected TonicDrink(VfpProfile oid, LiquidType lqt) {
        super(oid, lqt);
        this.autoregister();
    }

    public TonicDrink() {
        this((VfpProfile)VfpOid.TonicDrink, LiquidType.POTION);
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    public ItemStack createInstance(Item item, int amount) {
        ItemStack out = new ItemStack((IItemProvider)item, amount);
        TonicDrink.initDefaultEffect(out);
        return out;
    }

    @Override
    protected int getRegularItemUseDuration() {
        return SharedGlue.SHORT_FOOD_CONSUME_DURATION();
    }

    protected boolean isFortified(ItemStack tonic) {
        return ItemStacks.hasFlag((ItemStack)tonic, (String)_NBT_FORTIFIED, (boolean)false);
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack tonic) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)tonic);
        this.onDrinkDrunk(tonic, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.CureProfiles.applyForBurning((LivingEntity)player);
        super.onDrinkDrunk(original, remaining, world, player);
    }

    public void onDrunk(ItemStack tonic, @Nonnull LivingEntity drinker) {
        Potions.cureExternalBurningEffects((LivingEntity)drinker, (boolean)true);
        if (SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
            Potions.addPotionEffects((LivingEntity)drinker, (ItemStack)tonic);
        }
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnDrunk(original, remaining, world, player);
        if (this.isFortified(original)) {
            Potions.addStubbornPotionEffects((LivingEntity)player, (ItemStack)original);
        } else {
            Potions.addPotionEffects((LivingEntity)player, (ItemStack)original);
        }
    }

    static final int getColorFromMoonshine(ItemStack moonshine, int tintIndex) {
        int rc = ItemSupport.getColorFromMoonshine((ItemStack)moonshine, (int)tintIndex);
        if (tintIndex <= 0 && rc < 0) {
            rc = 3694022;
        }
        return rc;
    }

    public int getColorFrom(ItemStack tonic, int tintIndex) {
        return TonicDrink.getColorFromMoonshine(tonic, tintIndex);
    }

    public ITextComponent func_200295_i(ItemStack tonic) {
        ITextComponent registeredName = Potions.getTypeDisplayNameOrNull((ItemStack)tonic);
        return registeredName != null ? registeredName : super.func_200295_i(tonic);
    }

    static final ItemStack initDefaultEffect(ItemStack moonshine) {
        return Potions.newSoakedPotionPlaceholderItem((ItemStack)moonshine);
    }

    public void onCookedOrCrafted(ItemStack tonic) {
        if (!Potions.isa((ItemStack)tonic, (boolean)true)) {
            TonicDrink.initDefaultEffect(tonic);
        }
    }

    @Override
    public void func_77622_d(ItemStack tonic, World world, PlayerEntity player) {
        super.func_77622_d(tonic, world, player);
        if (SharedGlue.isaRealPlayer((Entity)player)) {
            int n = Potions.getEffects((ItemStack)tonic, (boolean)false).size();
            if (n < 3) {
                player.func_195066_a(VfpObj.Simple_Tonic_stat);
            } else if (n > 2) {
                player.func_195066_a(VfpObj.Multi_Tonic_stat);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        return TonicDrink.initDefaultEffect(super.func_190903_i());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack tonic, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        Potions.addPotionInformation((Collection)Potions.getEffects((ItemStack)tonic, (boolean)false), tooltip, (boolean)true);
        if (this.isFortified(tonic)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(Strings.tooltipKey((String)"itemsuffix.fortified")).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.DARK_PURPLE}));
        }
        super.func_77624_a(tonic, world, tooltip, flags);
    }

    static final boolean isa(ItemStack stack) {
        return stack.func_77973_b() == VfpObj.Tonic_Drink_obj;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull ItemStack from_potion, int spread) {
        ItemStack tonic = new ItemStack((IItemProvider)VfpObj.Tonic_Drink_obj);
        Potions.copyDefinition((ItemStack)from_potion, (ItemStack)tonic);
        return tonic;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull Collection<EffectInstance> effects, boolean fortified, @Nullable Integer customColor, @Nullable String unlocalizedName) {
        ItemStack tonic = new ItemStack((IItemProvider)VfpObj.Tonic_Drink_obj);
        Potions.copyDefinition((ItemStack)tonic, effects, (Integer)customColor);
        if (fortified) {
            ItemStacks.setFlag((ItemStack)tonic, (String)_NBT_FORTIFIED, (boolean)true);
        }
        if (unlocalizedName != null) {
            ItemStacks.getOrCreateData((ItemStack)tonic).func_74778_a(SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME(), unlocalizedName);
        }
        return tonic;
    }
}

