/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.tonics.CompositeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class TonicToTippedArrowsRecipe
extends ShapedRecipeWrapping {
    public static final String NAME = ModInfo.rstring("tonic_tipped_arrow_shaped");
    public static final ShapedRecipeWrapping.Serializer<TonicToTippedArrowsRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer(TonicToTippedArrowsRecipe::new);

    TonicToTippedArrowsRecipe(ShapedRecipe template) {
        super(template);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        List<EffectInstance> effects;
        ItemStack out = ItemStack.field_190927_a;
        ItemStack tipped_arrow = new ItemStack((IItemProvider)Items.field_185167_i);
        if (tipped_arrow.func_190926_b()) {
            return out;
        }
        ItemStack tonic = null;
        int n_spread = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            if (RID.matches((ItemStack)next, (String)"minecraft:arrows", (Item)Items.field_151032_g)) {
                ++n_spread;
                continue;
            }
            if (!TonicDrink.isa(next)) continue;
            tonic = next;
        }
        if (tonic != null && n_spread > 0 && !(effects = Potions.getEffects(tonic, (boolean)false)).isEmpty() && !(effects = CompositeTonicRecipe.splitEffects(effects, n_spread)).isEmpty()) {
            out = tipped_arrow;
            Potions.copyDefinition((ItemStack)tonic, (ItemStack)out);
            this.initUnlocalizedName(tonic, out);
            if (tonic.func_82837_s()) {
                out.func_200302_a(tonic.func_200301_q());
            }
            out.func_190920_e(n_spread);
        }
        return out;
    }

    private void initUnlocalizedName(ItemStack tonic, ItemStack arrow) {
        Potion type = PotionUtils.func_185191_c((ItemStack)tonic);
        if (!Potions.isReal((Potion)type)) {
            ItemStacks.setUnlocalizedNameOverride((ItemStack)arrow, (String)"tipped_arrow.vfp.effect.moonshine_potion");
        }
    }
}

