/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.impl.fluid.BucketProperties;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBottleItem;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBucketItem;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class Bottle
extends UniversalBottleItem
implements VfpAware,
IItemPropertyExtender {
    protected final VfpProfile _profile;

    public Bottle(@Nonnull VfpProfile oid, boolean hidden, BucketProperties bp) {
        super(oid.fmlid(), hidden, bp.renderByColor());
        this._profile = oid;
        if (oid.isVFP()) {
            VfpUtils.autoregisterItem((Item)this, this._profile);
        }
    }

    public Bottle() {
        this(VfpOid.Full_Bottle, !VfpConfig.getInstance().isExtendedFoodPantryPresent(), new BucketProperties().zeroed().group(VfpObj.group).emptyBucket(() -> new ItemStack((IItemProvider)VfpObj.Bottle_obj)));
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    public int getColorFrom(ItemStack bottle, int tintIndex) {
        int color_num = 0xFFFFFF;
        if (tintIndex <= 0) {
            int custom = Instructions.getColorRgb((ItemStack)bottle, (int)color_num);
            color_num = custom != color_num ? custom : UniversalBucketItem.getColorFrom((ModIntegration)ModInfo.ID, (FluidStack)this.getFluid(bottle));
        }
        return color_num;
    }

    protected void initSamplingContents(ItemStack bottle, Fluid of) {
        Fluids.setBucketFluid((ItemStack)bottle, (FluidStack)Fluids.bottleOf((Fluid)of), (boolean)true);
    }

    public ITextComponent func_200295_i(ItemStack bottle) {
        FluidStack f = Fluids.sameOrNull((FluidStack)this.getFluid(bottle));
        return f != null ? new TranslationTextComponent("item.vfp.full_bottle_of", new Object[]{f.getDisplayName(), f.getAmount()}) : Tooltips.addMarkedSuffixTo((ITextComponent)new TranslationTextComponent("item.vfp.empty_bottle"));
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && tab == ItemGroup.field_78027_g && this == VfpObj.Bottle_obj) {
            ItemStack sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.potable_water());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.honey());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.oatmilk());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.seedoil());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.experience());
            items.add((Object)sampling);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        ItemStack sample = new ItemStack((IItemProvider)this);
        this.initSamplingContents(sample, (Fluid)Fluids.water());
        ItemStacks.setColorRgb((ItemStack)sample, (int)0xF800F8);
        return sample;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("carrots:empty"), (bottle, world, entity) -> ((Bottle)bottle.func_77973_b()).isEmpty(bottle) ? 1.0f : 0.0f);
    }
}

