/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;
import org.jwaresoftware.mcmods.vfp.utensils.FlintCutterItem;

public final class CutterItemRepairRecipe
extends VfpRecipe {
    public static final String NAME = ModInfo.rstring("repair_cutter_shapeless");

    CutterItemRepairRecipe() {
        super(new ResourceLocation(NAME));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public boolean matches(CraftingInventory grid, World world) {
        int n = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            Item item = next.func_77973_b();
            if (item != VfpObj.Flint_Cutter_obj) {
                return false;
            }
            ++n;
        }
        return n > 1;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        int n = 0;
        int usesLeft = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            Item item = next.func_77973_b();
            if (item != VfpObj.Flint_Cutter_obj) {
                return out;
            }
            ++n;
            usesLeft += next.func_77958_k() - next.func_77952_i();
        }
        if (n > 1 && usesLeft > 0) {
            out = FlintCutterItem.repaired(usesLeft);
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CutterItemRepairRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CutterItemRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new CutterItemRepairRecipe();
        }

        public CutterItemRepairRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            return new CutterItemRepairRecipe();
        }

        public void write(PacketBuffer data, CutterItemRepairRecipe recipe) {
        }
    }
}

