/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import org.jwaresoftware.mcmods.lib.Materials;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtensilToolItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.utensils.WorkedFlintTier;

public final class FlintButcherAxe
extends VfpUtensilToolItem {
    private static final VfpProfile _PROFILE = VfpOid.Flint_Butcher_Axe;
    static final float _TOOL_DAMAGE = 7.0f;
    private static final Set<Block> TOOL_EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_150440_ba, Blocks.field_196628_cT, Blocks.field_196553_aF, Blocks.field_235396_nb_, Blocks.field_150407_cf, Blocks.field_203216_jz, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_235377_mq_, Blocks.field_235368_mh_, Blocks.field_222405_kQ});
    private static final Material[] TOOL_EFFECTIVE_ON_MATERIALS = new Material[]{Material.field_151569_G, Material.field_151572_C, Material.field_151570_A, Material.field_215713_z, Material.field_215712_y, Material.field_151580_n, Material.field_151583_m, Material.field_215711_w, Material.field_151590_u, Material.field_151584_j, Materials.dried_leaves, Material.field_151585_k, Material.field_151582_l, Material.field_242934_h, Material.field_204868_h, Material.field_203243_f, Material.field_151568_F};

    public FlintButcherAxe() {
        super(_PROFILE, 7.0f, -3.0f, WorkedFlintTier.INSTANCE, false, TOOL_EFFECTIVE_ON_BLOCKS, VfpUtils.newproperties(VfpUtils.bestTab(_PROFILE, SharedGlue.CreativeTabs_tools)).addToolType(SharedGlue.AXE, SharedGlue.IRON_TOOL_LEVEL()).addToolType(SharedGlue.MACHETE, SharedGlue.IRON_TOOL_LEVEL()).addToolType(SharedGlue.KNIFE, SharedGlue.IRON_TOOL_LEVEL()));
        this.autoregister();
    }

    public final boolean func_150897_b(BlockState target) {
        return Whatis.isCobweb((BlockState)target) || Whatis.isLargeFungusStemBlock((BlockState)target) || Materials.isSquishyBlock((Material)target.func_185904_a()) || target.func_235714_a_((ITag)BlockTags.field_199897_a);
    }

    public boolean canHarvestBlock(ItemStack axe, BlockState target) {
        if (Whatis.isCobweb((BlockState)target)) {
            return true;
        }
        Block block = target.func_177230_c();
        if (block.getHarvestLevel(target) > SharedGlue.IRON_TOOL_LEVEL()) {
            return false;
        }
        if (this.func_150897_b(target)) {
            return true;
        }
        Material material = target.func_185904_a();
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack axe, BlockState target) {
        if (Whatis.isCobweb((BlockState)target)) {
            return SharedGlue.MAX_TOOL_EFFICIENCY();
        }
        Material material = target.func_185904_a();
        if (Whatis.isLargeFungusStemBlock((BlockState)target)) {
            material = Material.field_151572_C;
        }
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return this.field_77864_a;
        }
        return super.func_150893_a(axe, target);
    }

    public boolean func_77644_a(ItemStack axe, LivingEntity target, LivingEntity attacker) {
        int amount = SharedGlue.isaAnimal((Entity)target) && SharedGlue.isaRealPlayer((Entity)attacker) ? 1 : 2;
        axe.func_222118_a(amount, attacker, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }
}

