/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtensilToolItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.utensils.WorkedFlintTier;

public class FlintCutterItem
extends VfpUtensilToolItem {
    public static final int MAX_USES = 32;

    public static final FlintCutterItem tool() {
        return new FlintCutterItem((VfpProfile)VfpOid.Flint_Cutter, 32, WorkedFlintTier.INSTANCE);
    }

    protected FlintCutterItem(VfpProfile profile, IItemTier material, Item.Properties ip) {
        super(profile, material, ip);
        this.autoregister();
    }

    public FlintCutterItem(VfpProfile profile, int durability, IItemTier material) {
        this(profile, material, VfpUtils.newproperties(VfpUtils.bestTab(profile, SharedGlue.CreativeTabs_tools)).addToolType(ToolType.get((String)SharedGlue.KNIFE_TOOLNAME()), SharedGlue.STONE_TOOL_LEVEL()).func_200918_c(durability <= 0 ? 32 : durability).setNoRepair());
    }

    protected final boolean isa(ItemStack cutter) {
        return !cutter.func_190926_b() && cutter.func_77973_b() == VfpObj.Flint_Cutter_obj;
    }

    public boolean func_82789_a(ItemStack cutter, ItemStack material) {
        return this.isa(cutter) && (RID.matches((ItemStack)material, (String)"flint", (Item)Items.field_151145_ak) || super.func_82789_a(cutter, material));
    }

    public ActionResultType func_195939_a(ItemUseContext iuc) {
        BlockState after;
        BlockPos at;
        World world = iuc.func_195991_k();
        BlockState before = world.func_180495_p(at = iuc.func_195995_a());
        if (before.func_203425_a(Blocks.field_196619_M) && (after = before.getToolModifiedState(world, at, iuc.func_195999_j(), iuc.func_195996_i(), ToolType.AXE)) != null) {
            PlayerEntity player = iuc.func_195999_j();
            Effects.playStrippedLogSuccessfully((PlayerEntity)player, (World)world, (BlockPos)at);
            if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                world.func_180501_a(at, after, 11);
                if (player != null) {
                    iuc.func_195996_i().func_222118_a(3, (LivingEntity)player, u -> u.func_213334_d(iuc.func_221531_n()));
                }
                ItemStack bark = ItemStacks.create((Item)VfpObj.Birch_Bark_obj, (int)(6 + (player != null ? player.func_70681_au().nextInt(5) : world.func_201674_k().nextInt(5))));
                ItemEntity drop = new ItemEntity(world, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, bark);
                drop.func_174869_p();
                SharedGlue.spawnEntityInto((World)world, (Entity)drop);
            }
            return ActionResultType.func_233537_a_((boolean)SharedGlue.isaClientWorld((IWorldReader)world));
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack cutter, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(cutter, world, tooltip, flags);
        if (this.isa(cutter)) {
            Tooltips.addUsesLeftTipLine((int)ItemStacks.getUsesLeft((ItemStack)cutter), tooltip);
        }
    }

    static final FlintCutterItem cutterInstance() {
        return (FlintCutterItem)VfpObj.Flint_Cutter_obj;
    }

    public static final ItemStack gold() {
        return new ItemStack((IItemProvider)FlintCutterItem.cutterInstance());
    }

    public static final ItemStack repaired(int usesLeft) {
        usesLeft = Math.min(usesLeft, 32);
        ItemStack cutter = FlintCutterItem.gold();
        FlintCutterItem.cutterInstance().setUsed(cutter, cutter.func_77958_k() - usesLeft);
        return cutter;
    }
}

