/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.veggies;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class NomadFoodBar
extends VfpPantryItem {
    protected final boolean _longlastingFlag;
    protected final boolean _fullRejuvenated;

    public NomadFoodBar(@Nonnull VfpProfile profile, LikeFood food, boolean rejuv, boolean longlasting) {
        super(profile, food, null);
        this._longlastingFlag = longlasting;
        this._fullRejuvenated = rejuv;
        this.autoregister();
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        if (item == null) {
            item = this;
        }
        return new ItemStack((IItemProvider)item, amount);
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return !good ? super.getPotionEffectDurationSecs(false) : (this._longlastingFlag ? 960 : 480);
    }

    @Override
    protected void applyEatHappyFoodEffect(ItemStack eaten, PlayerEntity player) {
        int duration = this.getHappyFoodSideEffectDurationSecs();
        Potions.addPotionEffect((LivingEntity)player, (Effect)WellFedEffect.get_tier2(), (int)duration, (int)0);
        if (VfpConfig.manageStamina()) {
            WellnessHelper.rejuvenateIfTired((LivingEntity)player, (int)(this._fullRejuvenated ? 2 : 1), (int)duration);
        }
    }

    @Override
    public float getCompostChance(Item bar) {
        return bar == this ? (this._longlastingFlag ? 1.0f : 0.8f) : -1.0f;
    }

    public static final NomadFoodBar mealBar() {
        return new NomadFoodBar((VfpProfile)VfpOid.Nomads_Meal_Bar, LikeFood.nomads_fullbar, true, true);
    }

    public static final NomadFoodBar halfBar() {
        return new NomadFoodBar((VfpProfile)VfpOid.Nomads_Snack_Bar, LikeFood.nomads_halfbar, false, false);
    }
}

