/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.water;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.client.TemperatureItemProperty;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class BucketOfPotableWater
extends VfpLiquidFood
implements IReheatable,
IItemPropertyExtender {
    private static final int _1MIN = 60;
    private static final int _4MINS = 240;
    private static final int _COOLDOWN_TICKS_VAN = 60 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    private static final int _COOLDOWN_TICKS_EXT = 300 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();

    public BucketOfPotableWater() {
        super((VfpProfile)VfpOid.Bucket_Potable_Water, LikeFood.water, LiquidType.POTABLE_WATER);
        this.setHiddenByDefault(true);
        this.setContainerItem(Items.field_151133_ar);
        this.setAlwaysEdible();
        this.autoregister();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return Items.field_151133_ar;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.NONE;
    }

    @Override
    public final int getItemStackLimit(ItemStack bucket) {
        return 1;
    }

    public final int getCoolDuration(ItemStack bucket) {
        return 480;
    }

    public boolean canPlayerHeat(ItemStack stack) {
        return true;
    }

    @Override
    public void onCookedOrCrafted(ItemStack bucket) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(bucket);
        super.onCookedOrCrafted(bucket);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(bucket);
        }
    }

    @Override
    protected void onFoodEaten(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.CureProfiles.applyForBurning((LivingEntity)player);
        super.onFoodEaten(original, remaining, world, player);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        int cooldown = _COOLDOWN_TICKS_VAN;
        if (VfpConfig.manageThirst()) {
            cooldown = _COOLDOWN_TICKS_EXT;
        }
        if (VfpConfig.manageTemperature()) {
            int baseDuration = this.getBonusTemperatureTimeLeftForApply(original, 240);
            if (this.isHeated(original)) {
                WellnessHelper.warmIfCold((LivingEntity)player, (int)2, (int)baseDuration, (int)baseDuration);
            } else {
                WellnessHelper.coolIfHot((LivingEntity)player, (int)2, (int)baseDuration, (int)baseDuration);
            }
            cooldown = _COOLDOWN_TICKS_EXT;
        }
        player.func_184811_cZ().func_185145_a((Item)this, cooldown);
    }

    public void func_77663_a(ItemStack bucket, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(bucket, world, holder, slotindex, selected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        TemperatureItemProperty.addHeatable((Item)this);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
    }
}

