/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.water;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.fluid.PortionedItemStackFluidHandler;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrink;
import org.jwaresoftware.mcmods.vfp.water.EmptyFluidContainerItem;
import org.jwaresoftware.mcmods.vfp.water.Water;

public class EmptyBottle
extends EmptyFluidContainerItem {
    public EmptyBottle() {
        super(VfpOid.Empty_Bottle);
    }

    @Override
    @Nullable
    protected ItemStack getWaterFilledContainerItem(World world, BlockPos blockpos, PlayerEntity player) {
        ItemStack filled = EmptyBottle.isSwampishBiomeAtPos(world, blockpos) ? Water.swamp(1) : (VfpConfig.getInstance().useTreatedWaterRecipes() ? Water.dirty(1) : Water.plain(1));
        Effects.playBottleOfWaterScoopedUp((World)world, (PlayerEntity)player);
        ItemSupport.noteItemCraftedNontraditionalMeans((PlayerEntity)player, (World)world, (ItemStack)filled);
        return filled;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FluidHandler(stack);
    }

    static final class FluidHandler
    extends FluidHandlerItemStack {
        private static final String _BIRCH_SAP = "birch_sap";

        FluidHandler(ItemStack emptybottle) {
            super(emptybottle, 250);
        }

        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        private boolean isWater(Fluid fluid, String fluidname) {
            boolean treated_water = VfpConfig.getInstance().useTreatedWaterRecipes();
            return treated_water ? Fluids.isPotableWater((Fluid)fluid) : fluid == Fluids.water() || Fluids.isWater((String)fluidname);
        }

        private boolean isUnfilteredWater(Fluid fluid, String fluidname) {
            boolean treated_water = VfpConfig.getInstance().useTreatedWaterRecipes();
            return LiquidType.UNTREATED_WATER.matches(fluid) || treated_water && (fluid == Fluids.water() || "rain_water".equals(fluidname));
        }

        private boolean isBirchSap(Fluid fluid, String fluidname) {
            return ModIntegration.SUPERBLOCKS.belongsTo(fluid) && _BIRCH_SAP.equals(fluidname);
        }

        public boolean canFillFluidType(FluidStack supplied) {
            if (Fluids.sameOrNull((FluidStack)supplied) != null) {
                String fluidname;
                if (PortionedItemStackFluidHandler.IS_JARABLE_FLUID.test(supplied)) {
                    return true;
                }
                Fluid fluid = supplied.getFluid();
                if (this.isWater(fluid, fluidname = Fluids.name((Fluid)fluid))) {
                    return true;
                }
                if (Fluids.isMilk((String)fluidname)) {
                    return true;
                }
                if (Fluids.isCream((String)fluidname)) {
                    return true;
                }
                if (Fluids.isHoney((String)fluidname) || Fluids.isSeedoil((String)fluidname)) {
                    return true;
                }
                if (Fluids.isLiquidXp((String)fluidname)) {
                    return true;
                }
                if (this.isBirchSap(fluid, fluidname)) {
                    return true;
                }
            }
            return false;
        }

        public boolean canDrainFluidType(FluidStack wanted) {
            return false;
        }

        protected void setFluid(FluidStack supplied) {
            ItemStack bottle;
            IFluidHandlerItem fH;
            String fluidname;
            Fluid fluid = supplied.getFluid();
            if (this.isUnfilteredWater(fluid, fluidname = Fluids.name((Fluid)fluid))) {
                this.container = Water.dirty(1);
            } else if (this.isWater(fluid, fluidname)) {
                this.container = Water.plain(1);
            } else if (Fluids.isMilk((String)fluidname)) {
                this.container = MilkDrink.plain(1);
            } else if (Fluids.isCream((String)fluidname)) {
                this.container = MilkDrink.heavy(1);
            } else if (Fluids.isLiquidXp((String)fluidname)) {
                this.container = new ItemStack((IItemProvider)Items.field_151062_by);
            } else if (this.isBirchSap(fluid, fluidname)) {
                this.container = Water.birch(1);
            } else if (PortionedItemStackFluidHandler.IS_JARABLE_FLUID.test(supplied) && (fH = ItemStacks.getFluidHandler((ItemStack)(bottle = ItemStacks.create((Item)VfpObj.Bottle_obj)))) != null && fH.fill(supplied, IFluidHandler.FluidAction.EXECUTE) >= 250) {
                this.container = fH.getContainer();
            }
        }

        protected void setContainerToEmpty() {
        }

        public FluidStack drain(FluidStack wanted, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int wanted_amount, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public int fill(FluidStack supplied, IFluidHandler.FluidAction action) {
            if (this.container.func_190916_E() != 1 || supplied == null || supplied.getAmount() < 250 || !this.canFillFluidType(supplied)) {
                return 0;
            }
            int fillAmount = 250;
            if (action.execute()) {
                FluidStack filled = supplied.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
    }
}

