/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class Bread
extends VfpPantryMultiItem
implements IVariant {
    static final LikeFood B_PLAIN = LikeFood.flouronly_bread;
    static final LikeFood B_FRENCH = LikeFood.french_bread;
    static final LikeFood B_ENRICHED = LikeFood.enriched_bread;
    static final LikeFood B_SANDWICH = LikeFood.sandwich_bread;
    static final LikeFood B_SPECIALTY = LikeFood.specialty_bread;
    static final LikeFood B_MUSCLE = new LikeFood("musclebread", 0, B_SPECIALTY, LikeFood.muscle_boost, LikeFood.muscle_boost);
    private static Bread[] INSTANCES;
    private static final Map<String, Boolean> _HONEYBREAD_OPTS;

    Bread(BreadDef variant) {
        super((VfpProfile)VfpOid.Breads, false, variant);
        this.inGroup("bread");
        this.autoregister();
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    private BreadDef getDef() {
        return (BreadDef)this._variant;
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.bread.healAmount();
    }

    @Override
    protected boolean getPreferSingleUseFood() {
        boolean flat;
        BreadDef breadDef = this.getDef();
        boolean bl = flat = !breadDef.isMultiuse() || VfpConfig.getInstance().preferSingleUseFood("bread", false);
        if (flat && breadDef.cooked() && breadDef.food().isOversized()) {
            flat = false;
        }
        return flat;
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            if (this._variant == BreadDef.Muscle) {
                Potions.onMuscleFoodEaten((LivingEntity)player, (int)-1, (int)(this.isMultiuse(eaten) ? 0 : 1));
            }
            if (this._variant == BreadDef.Honey) {
                Potions.CureProfiles.applyForHoney((LivingEntity)player, _HONEYBREAD_OPTS);
            }
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    @Override
    public int func_77626_a(ItemStack bread) {
        int default_duration = super.func_77626_a(bread);
        if (this._variant == BreadDef.Muscle) {
            default_duration = SharedGlue.HEARTY_FOOD_CONSUME_DURATION();
        }
        return default_duration;
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        if (!SharedGlue.isDefined((Item)item)) {
            item = this;
        } else if (item != this) {
            return ItemStack.field_190927_a;
        }
        return Bread.newBread(amount, this.getDef());
    }

    private static ItemStack newBread(int amount, BreadDef breadDef) {
        Bread instance = INSTANCES[breadDef.index()];
        boolean flat = instance.getPreferSingleUseFood();
        ItemStack a_bread = breadDef.isMultiuse() && !flat ? Bread.createMultiuseInstance((Item)instance, amount, breadDef.food().healAmount(), LikeFood.bread.healAmount()) : new ItemStack((IItemProvider)instance, amount);
        return a_bread;
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all_baked = new ArrayList<ItemStack>(13);
        for (BreadDef breadDef : BreadDef.VALUES) {
            if (!breadDef.cooked()) continue;
            all_baked.add(Bread.newBread(1, breadDef));
        }
        return all_baked;
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? (this.getDef().cooked() ? 1.0f : 0.85f) : -1.0f;
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            int N = BreadDef.VALUES.size();
            INSTANCES = new Bread[N];
            for (int i = 0; i < N; ++i) {
                BreadDef breadDef = BreadDef.VALUES.get(i);
                Bread.INSTANCES[breadDef.index()] = new Bread(breadDef);
            }
            VfpObj.Portion_Bread_obj = VfpBuilder.newFood(VfpOid.Portion_Bread, LikeFood.sandwich);
            VfpObj.Flat_Bread_Pocket_obj = VfpBuilder.newFood(VfpOid.Flat_Bread_Pocket, LikeFood.bread_pocket);
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            for (BreadDef breadDef : BreadDef.VALUES) {
                if (breadDef.cooked()) continue;
                VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)INSTANCES[breadDef.index()]), breadDef.food().craftExperience());
            }
        }
    }

    public static final ItemStack french(int amount) {
        return Bread.newBread(amount, BreadDef.French);
    }

    public static final ItemStack enriched(int amount) {
        return Bread.newBread(amount, BreadDef.Plain);
    }

    public static final ItemStack potato(int amount) {
        return Bread.newBread(amount, BreadDef.Potato);
    }

    public static final ItemStack pumpkin(int amount) {
        return Bread.newBread(amount, BreadDef.Pumpkin);
    }

    public static final ItemStack flat(int amount) {
        return Bread.newBread(amount, BreadDef.Flat);
    }

    public static final boolean isKlingon(ItemStack stack) {
        return stack.func_77973_b() instanceof Bread && ((Bread)stack.func_77973_b())._variant == BreadDef.Klingon;
    }

    public static final boolean isBeets(ItemStack stack) {
        return stack.func_77973_b() instanceof Bread && ((Bread)stack.func_77973_b())._variant == BreadDef.Beets;
    }

    public static final boolean isMuscle(ItemStack stack) {
        return stack.func_77973_b() instanceof Bread && ((Bread)stack.func_77973_b())._variant == BreadDef.Muscle;
    }

    static {
        _HONEYBREAD_OPTS = Potions.CureProfiles.newopts(m -> {
            m.put("forced", false);
            m.put("combatant", false);
            m.put("boosted", false);
        });
    }

    static final class BreadDef
    extends VfpVariant {
        static final ArrayList<BreadDef> VALUES = new ArrayList(31);
        static final BreadDef Plain = new BreadDef(true, "enriched", B_ENRICHED, FoodPowder.Usage.BREAD_FLAVOR.idFirst(), true, false);
        static final BreadDef Uncooked_Plain = new BreadDef("enriched", B_ENRICHED, BreadDef.Plain._id + 1, false);
        static final BreadDef Molasses = new BreadDef(true, "molasses", B_SPECIALTY, BreadDef.Uncooked_Plain._id + 1, false, true);
        static final BreadDef Uncooked_Molasses = new BreadDef(BreadDef.Molasses._name, BreadDef.Molasses._food, BreadDef.Molasses._id + 1, true);
        static final BreadDef Egg = new BreadDef(true, "egg", B_SANDWICH, BreadDef.Uncooked_Molasses._id + 1, true, true);
        static final BreadDef Uncooked_Egg = new BreadDef(BreadDef.Egg._name, BreadDef.Egg._food, BreadDef.Egg._id + 1, true);
        static final BreadDef Honey = new BreadDef(true, "honey", B_ENRICHED, BreadDef.Uncooked_Egg._id + 1, true, true);
        static final BreadDef Uncooked_Honey = new BreadDef(BreadDef.Honey._name, BreadDef.Honey._food, BreadDef.Honey._id + 1, true);
        static final BreadDef Apple = new BreadDef(true, "apple", B_SPECIALTY, BreadDef.Uncooked_Honey._id + 1, false, true);
        static final BreadDef Uncooked_Apple = new BreadDef(BreadDef.Apple._name, BreadDef.Apple._food, BreadDef.Apple._id + 1, true);
        static final BreadDef Pumpkin = new BreadDef(true, "pumpkin", B_SPECIALTY, BreadDef.Uncooked_Apple._id + 1, false, true);
        static final BreadDef Uncooked_Pumpkin = new BreadDef(BreadDef.Pumpkin._name, BreadDef.Pumpkin._food, BreadDef.Pumpkin._id + 1, true);
        static final BreadDef French = new BreadDef(true, "french", B_FRENCH, BreadDef.Uncooked_Pumpkin._id + 1, true, false);
        static final BreadDef Uncooked_French = new BreadDef(BreadDef.French._name, BreadDef.French._food, BreadDef.French._id + 1, false);
        static final BreadDef Potato = new BreadDef(true, "potato", B_SANDWICH, BreadDef.Uncooked_French._id + 1, true, true);
        static final BreadDef Uncooked_Potato = new BreadDef(BreadDef.Potato._name, BreadDef.Potato._food, BreadDef.Potato._id + 1, true);
        static final BreadDef Muscle = new BreadDef(true, "muscle", B_MUSCLE, BreadDef.Uncooked_Potato._id + 1, false, true);
        static final BreadDef Uncooked_Muscle = new BreadDef(BreadDef.Muscle._name, BreadDef.Muscle._food, BreadDef.Muscle._id + 1, false);
        static final BreadDef Klingon = new BreadDef(true, "klingon", B_SANDWICH, BreadDef.Uncooked_Muscle._id + 1, true, true);
        static final BreadDef Uncooked_Klingon = new BreadDef(BreadDef.Klingon._name, BreadDef.Klingon._food, BreadDef.Klingon._id + 1, true);
        static final BreadDef Beets = new BreadDef(true, "beets", B_SPECIALTY, BreadDef.Uncooked_Klingon._id + 1, true, true);
        static final BreadDef Uncooked_Beets = new BreadDef(BreadDef.Beets._name, BreadDef.Beets._food, BreadDef.Beets._id + 1, false);
        static final BreadDef Allium = new BreadDef(true, "allium", B_ENRICHED, BreadDef.Uncooked_Beets._id + 1, true, true);
        static final BreadDef Uncooked_Allium = new BreadDef(BreadDef.Allium._name, BreadDef.Allium._food, BreadDef.Allium._id + 1, false);
        static final BreadDef Flat = new BreadDef(true, "flat", B_PLAIN, BreadDef.Uncooked_Allium._id + 1, false, false);
        static final BreadDef Uncooked_Flat = new BreadDef(BreadDef.Flat._name, BreadDef.Flat._food, BreadDef.Flat._id + 1, false);
        private final int _id;
        private final boolean _multi;
        private final boolean _sandwich;
        private final boolean _cooked;
        private final boolean _achievement;

        BreadDef(boolean cooked, String name, LikeFood like, int id, boolean sandwich, boolean achievement) {
            super(VALUES.size(), name, like);
            this._id = id;
            this._cooked = cooked;
            this._multi = cooked && (like == B_SANDWICH || like == B_SPECIALTY || like == B_MUSCLE);
            this._sandwich = cooked && sandwich;
            this._achievement = !cooked && achievement;
            VALUES.add(this);
        }

        BreadDef(String name, LikeFood like, int id, boolean achievement) {
            this(false, name, like, id, false, achievement);
        }

        @Override
        public String fmlid() {
            String p = this._cooked ? "" : "uncooked_";
            return this._name == null ? p + "bread" : p + this._name + "_bread";
        }

        @Override
        public int metadata() {
            return this._id;
        }

        @Override
        @Nonnull
        public LikeFood food() {
            return this._cooked ? super.food() : LikeFood.air;
        }

        @Override
        @Nullable
        public ItemGroup tab() {
            return this._cooked ? null : SharedGlue.CreativeTabs_misc;
        }

        boolean cooked() {
            return this._cooked;
        }

        boolean sandwichOk() {
            return this._sandwich;
        }

        boolean isMultiuse() {
            return this._multi;
        }

        boolean getsAchievement() {
            return this._achievement;
        }
    }
}

