/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class Minibread
extends VfpPantryMultiItem {
    private static Minibread[] INSTANCES;

    Minibread(BreadDef variant) {
        super((VfpProfile)VfpOid.Dough_Ball, false, variant);
        this.inGroup("bread");
        this.autoregister();
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? 0.65f : -1.0f;
    }

    @Override
    public IDrink defaultThirstAffect(ItemStack minibread) {
        return ((BreadDef)this._variant).cooked() ? VfpOid.Cooked_Dough.thirstType() : IDrink.NONE;
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            int N = BreadDef.VALUES.size();
            INSTANCES = new Minibread[N];
            for (int i = 0; i < N; ++i) {
                BreadDef breadDef = BreadDef.VALUES.get(i);
                Minibread.INSTANCES[breadDef.index()] = new Minibread(breadDef);
            }
        }
    }

    static final void setRecipeRewards() {
        VfpRewards.addRewardingCraftItem(Minibread.dough(1), LikeFood.mini_bread.craftExperience());
        VfpRewards.addRewardingCraftItem(Minibread.cheesedough(1), LikeFood.mini_bread.craftExperience());
        VfpRewards.addRewardingCraftItem(Minibread.meatdough(1), LikeFood.mini_bread.craftExperience());
    }

    private static final ItemStack create(int amount, BreadDef minibread) {
        Validate.validState((INSTANCES != null && minibread.index() < INSTANCES.length ? 1 : 0) != 0);
        return new ItemStack((IItemProvider)INSTANCES[minibread.index()], amount);
    }

    public static final Item doughball() {
        return INSTANCES != null ? INSTANCES[0] : Items.field_190931_a;
    }

    public static final ItemStack dough(int amount) {
        return Minibread.create(amount, BreadDef.DoughBall);
    }

    public static final ItemStack cookedPlain(int amount) {
        return Minibread.create(amount, BreadDef.PlainRoll);
    }

    public static final ItemStack sweetdough(int amount) {
        return Minibread.create(amount, BreadDef.SweetDough);
    }

    public static final ItemStack cookedSweet(int amount) {
        return Minibread.create(amount, BreadDef.SweetRoll);
    }

    public static final ItemStack eggdough(int amount) {
        return Minibread.create(amount, BreadDef.EggDough);
    }

    public static final ItemStack cookedEgg(int amount) {
        return Minibread.create(amount, BreadDef.EggRoll);
    }

    public static final ItemStack meatdough(int amount) {
        return Minibread.create(amount, BreadDef.MeatDough);
    }

    public static final ItemStack cookedMeat(int amount) {
        return Minibread.create(amount, BreadDef.MeatRoll);
    }

    public static final ItemStack cheesedough(int amount) {
        return Minibread.create(amount, BreadDef.CheeseDough);
    }

    public static final ItemStack cookedCheese(int amount) {
        return Minibread.create(amount, BreadDef.CheeseRoll);
    }

    static final class BreadDef
    extends VfpVariant {
        static final ArrayList<BreadDef> VALUES = new ArrayList(23);
        static final BreadDef DoughBall = new BreadDef(VfpOid.Dough_Ball);
        static final BreadDef PlainRoll = new BreadDef(true, (VfpProfile)VfpOid.Cooked_Dough, LikeFood.mini_bread);
        static final BreadDef SweetDough = new BreadDef(VfpOid.Sweet_Dough_Ball);
        static final BreadDef SweetRoll = new BreadDef(true, (VfpProfile)VfpOid.Cooked_Sweet_Dough, new LikeFood(-1, LikeFood.mini_bread, LikeFood.sugar));
        static final BreadDef EggDough = new BreadDef(VfpOid.Uncooked_Egg_Minibread);
        static final BreadDef EggRoll = new BreadDef(true, (VfpProfile)VfpOid.Egg_Minibread, new LikeFood(-1, LikeFood.mini_bread, LikeFood.egg));
        static final BreadDef MeatDough = new BreadDef(VfpOid.Uncooked_Meat_Minibread);
        static final BreadDef MeatRoll = new BreadDef(true, (VfpProfile)VfpOid.Meat_Minibread, new LikeFood(-1, LikeFood.mini_bread_halved, LikeFood.meat_portion, LikeFood.veg_portion));
        static final BreadDef CheeseDough = new BreadDef(VfpOid.Uncooked_Cheese_Minibread);
        static final BreadDef CheeseRoll = new BreadDef(true, (VfpProfile)VfpOid.Cheese_Minibread, new LikeFood(-1, LikeFood.mini_bread_halved, LikeFood.cheese_portion));
        private final boolean _cooked;

        BreadDef(boolean cooked, VfpProfile profile, LikeFood food) {
            super(VALUES.size(), profile, food);
            this._cooked = cooked && profile.isEdible();
            VALUES.add(this);
        }

        BreadDef(VfpProfile profile) {
            this(false, profile, (LikeFood)null);
        }

        boolean cooked() {
            return this._cooked;
        }

        @Override
        @Nonnull
        public LikeFood food() {
            return this._cooked ? super.food() : LikeFood.air;
        }

        @Override
        @Nullable
        public ItemGroup tab() {
            return this._cooked ? null : SharedGlue.CreativeTabs_misc;
        }
    }
}

