/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IHappyFood;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrink;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class Muffin
extends VfpSoakableFood
implements IMultiColored,
IHappyFood {
    private static Muffin[] INSTANCES;

    public Muffin(VfpVariant variant) {
        super((VfpProfile)VfpOid.Muffins, false, variant);
        this.autoregister();
    }

    private int getColorFromVariant_(ItemStack muffin, int tintIndex) {
        int color_num = 0;
        MuffinDef muffinDef = (MuffinDef)((Muffin)muffin.func_77973_b())._variant;
        Integer colorValue = muffinDef.colorValue();
        if (colorValue != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    public int getColorFrom(ItemStack stack, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0 && (color_num = this.getColorFromVariant_(stack, tintIndex)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    public String oid() {
        MuffinDef muffinDef = (MuffinDef)this._variant;
        return muffinDef.baked() ? (muffinDef.sweetcheese() ? VfpOid.Muffins.fmlid() + "_cheese" : VfpOid.Muffins.fmlid()) : VfpOid.Uncooked_Muffins.fmlid();
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new Muffin[MuffinDef.VALUES.size()];
            for (MuffinDef muffinDef : MuffinDef.VALUES) {
                Muffin.INSTANCES[muffinDef.index()] = new Muffin(muffinDef);
            }
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            for (int i = 0; i < MuffinDef.VALUES.size(); i += 2) {
                ItemStack baked_muffin = new ItemStack((IItemProvider)INSTANCES[i + 1]);
                VfpRewards.addRewardingCraftItem(baked_muffin, LikeFood.muffin.craftExperience());
            }
        }
    }

    public static final ItemStack pumpkin(int amount) {
        return INSTANCES != null ? new ItemStack((IItemProvider)INSTANCES[MuffinDef.Pumpkin_SweetCheese.index()]) : ItemStack.field_190927_a;
    }

    static final class MuffinDef
    extends VfpVariant {
        static final ArrayList<MuffinDef> VALUES = new ArrayList(13);
        static final MuffinDef Unbaked_Pumpkin_SweetCheese = new MuffinDef(false, "pumpkin", FoodPowder.Type.PUMPKIN, FoodPowder.Usage.BREAD_FLAVOR.idFirst(), 15719111, true);
        static final MuffinDef Pumpkin_SweetCheese = new MuffinDef(true, MuffinDef.Unbaked_Pumpkin_SweetCheese._name, FoodPowder.Type.PUMPKIN, MuffinDef.Unbaked_Pumpkin_SweetCheese._id + 1, 14126361, true);
        static final MuffinDef Unbaked_Cocoa_SweetCheese = new MuffinDef(false, "cocoa", FoodPowder.Type.COCOA, MuffinDef.Pumpkin_SweetCheese._id + 1, 0x887766, true);
        static final MuffinDef Cocoa_SweetCheese = new MuffinDef(true, MuffinDef.Unbaked_Cocoa_SweetCheese._name, FoodPowder.Type.COCOA, MuffinDef.Unbaked_Cocoa_SweetCheese._id + 1, true);
        static final MuffinDef Unbaked_Carrot_SweetCheese = new MuffinDef(false, "carrot", FoodPowder.Type.CARROT, MuffinDef.Cocoa_SweetCheese._id + 1, 14198911, true);
        static final MuffinDef Carrot_SweetCheese = new MuffinDef(true, MuffinDef.Unbaked_Carrot_SweetCheese._name, FoodPowder.Type.CARROT, MuffinDef.Unbaked_Carrot_SweetCheese._id + 1, true);
        static final MuffinDef Unbaked_Apple = new MuffinDef(false, "apple", FoodPowder.Type.APPLE, MuffinDef.Carrot_SweetCheese._id + 1, 14198911, false);
        static final MuffinDef Apple = new MuffinDef(true, MuffinDef.Unbaked_Apple._name, FoodPowder.Type.APPLE, MuffinDef.Unbaked_Apple._id + 1, 14120779, false);
        static final MuffinDef Unbaked_Honey = new MuffinDef(false, "honey", FoodPowder.Type.HONEY, MuffinDef.Apple._id + 1, 15391935, false);
        static final MuffinDef Honey = new MuffinDef(true, MuffinDef.Unbaked_Honey._name, FoodPowder.Type.HONEY, MuffinDef.Unbaked_Honey._id + 1, 12222506, false);
        static final MuffinDef Unbaked_UgliFruit = new MuffinDef(false, "uglifruit", FoodPowder.Type.UGLI_FRUIT, MuffinDef.Honey._id + 1, 0xFFFF8A, false);
        static final MuffinDef UgliFruit = new MuffinDef(true, MuffinDef.Unbaked_UgliFruit._name, FoodPowder.Type.UGLI_FRUIT, MuffinDef.Unbaked_UgliFruit._id + 1, 15454980, false);
        private final int _id;
        private final boolean _baked;
        private final FoodPowder.Type _flavor;
        private final Integer _color;
        private final boolean _dairy;

        MuffinDef(boolean baked, String name, FoodPowder.Type flavor, int id, Integer color, boolean dairy) {
            super(VALUES.size(), name, baked ? MuffinDef.like(flavor) : null);
            this._id = id;
            this._baked = baked;
            this._flavor = flavor;
            this._color = color;
            this._dairy = dairy;
            VALUES.add(this);
        }

        MuffinDef(boolean baked, String name, FoodPowder.Type flavor, int id, boolean dairy) {
            this(baked, name, flavor, id, null, dairy);
        }

        static final LikeFood like(FoodPowder.Type flavor) {
            return MilkDrink.like(FoodPowder.toIngredient(flavor, FoodPowder.Usage.BREAD_FLAVOR, null), LikeFood.muffin);
        }

        @Override
        public String fmlid() {
            String p = this._baked ? "" : "uncooked_";
            return this._name == null ? p + "muffin" : p + this._name + "_muffin";
        }

        @Override
        public int metadata() {
            return this._id;
        }

        boolean baked() {
            return this._baked;
        }

        boolean sweetcheese() {
            return this._dairy;
        }

        FoodPowder.Type flavor() {
            return this._flavor;
        }

        Integer colorValue() {
            return this._color != null ? this._color : this.flavor().colorValue();
        }

        @Override
        @Nullable
        public ItemGroup tab() {
            return this._baked ? null : SharedGlue.CreativeTabs_misc;
        }
    }
}

