/*
 * Decompiled with CFR 0.152.
 */
package net.smokinpatty.phone.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.smokinpatty.phone.JustaphoneMod;
import net.smokinpatty.phone.JustaphoneModElements;
import net.smokinpatty.phone.JustaphoneModVariables;
import net.smokinpatty.phone.procedures.OpenPhoneProcedure;
import net.smokinpatty.phone.procedures.SellItemsProcedure;
import org.lwjgl.opengl.GL11;

@JustaphoneModElements.ModElement.Tag
public class BankingGui
extends JustaphoneModElements.ModElement {
    public static HashMap guistate = new HashMap();
    private static ContainerType<GuiContainerMod> containerType = null;

    public BankingGui(JustaphoneModElements instance) {
        super(instance, 566);
        this.elements.addNetworkMessage(ButtonPressedMessage.class, ButtonPressedMessage::buffer, ButtonPressedMessage::new, ButtonPressedMessage::handler);
        this.elements.addNetworkMessage(GUISlotChangedMessage.class, GUISlotChangedMessage::buffer, GUISlotChangedMessage::new, GUISlotChangedMessage::handler);
        containerType = new ContainerType((ContainerType.IFactory)new GuiContainerModFactory());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initElements() {
        DeferredWorkQueue.runLater(() -> ScreenManager.func_216911_a(containerType, GuiWindow::new));
    }

    @SubscribeEvent
    public void registerContainer(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(containerType.setRegistryName("banking"));
    }

    private static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        HashMap<String, Object> $_dependencies;
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("world", world);
            SellItemsProcedure.executeProcedure($_dependencies);
        }
        if (buttonID == 1) {
            $_dependencies = new HashMap();
            $_dependencies.put("entity", entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", world);
            OpenPhoneProcedure.executeProcedure($_dependencies);
        }
    }

    private static void handleSlotAction(PlayerEntity entity, int slotID, int changeType, int meta, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    public static class GUISlotChangedMessage {
        int slotID;
        int x;
        int y;
        int z;
        int changeType;
        int meta;

        public GUISlotChangedMessage(int slotID, int x, int y, int z, int changeType, int meta) {
            this.slotID = slotID;
            this.x = x;
            this.y = y;
            this.z = z;
            this.changeType = changeType;
            this.meta = meta;
        }

        public GUISlotChangedMessage(PacketBuffer buffer) {
            this.slotID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
            this.changeType = buffer.readInt();
            this.meta = buffer.readInt();
        }

        public static void buffer(GUISlotChangedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.slotID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
            buffer.writeInt(message.changeType);
            buffer.writeInt(message.meta);
        }

        public static void handler(GUISlotChangedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                BankingGui.handleSlotAction((PlayerEntity)entity, slotID, changeType, meta, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    public static class ButtonPressedMessage {
        int buttonID;
        int x;
        int y;
        int z;

        public ButtonPressedMessage(PacketBuffer buffer) {
            this.buttonID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
        }

        public ButtonPressedMessage(int buttonID, int x, int y, int z) {
            this.buttonID = buttonID;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void buffer(ButtonPressedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.buttonID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
        }

        public static void handler(ButtonPressedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                BankingGui.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GuiWindow
    extends ContainerScreen<GuiContainerMod> {
        private World world;
        private int x;
        private int y;
        private int z;
        private PlayerEntity entity;
        private static final ResourceLocation texture = new ResourceLocation("justaphone:textures/banking.png");

        public GuiWindow(GuiContainerMod container, PlayerInventory inventory, ITextComponent text) {
            super((Container)container, inventory, text);
            this.world = container.world;
            this.x = container.x;
            this.y = container.y;
            this.z = container.z;
            this.entity = container.entity;
            this.field_146999_f = 176;
            this.field_147000_g = 166;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            int k = (this.width - this.field_146999_f) / 2;
            int l = (this.height - this.field_147000_g) / 2;
            GuiWindow.blit((int)k, (int)l, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/gold_ingot.png"));
            GuiWindow.blit((int)(this.field_147003_i + 90), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/coal.png"));
            GuiWindow.blit((int)(this.field_147003_i + 36), (int)(this.field_147009_r + 44), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/quartz.png"));
            GuiWindow.blit((int)(this.field_147003_i + 146), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/iron_ingot.png"));
            GuiWindow.blit((int)(this.field_147003_i + 117), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/lapis_lazuli.png"));
            GuiWindow.blit((int)(this.field_147003_i + 63), (int)(this.field_147009_r + 44), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/diamond.png"));
            GuiWindow.blit((int)(this.field_147003_i + 6), (int)(this.field_147009_r + 14), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/emerald.png"));
            GuiWindow.blit((int)(this.field_147003_i + 63), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/redstone.png"));
            GuiWindow.blit((int)(this.field_147003_i + 35), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("justaphone:textures/netherite_ingot_be1.png"));
            GuiWindow.blit((int)(this.field_147003_i + 6), (int)(this.field_147009_r + 44), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }

        public boolean keyPressed(int key, int b, int c) {
            if (key == 256) {
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
            return super.keyPressed(key, b, c);
        }

        public void tick() {
            super.tick();
        }

        protected void func_146979_b(int mouseX, int mouseY) {
            this.font.func_211126_b("Banking - Gems", 54.0f, 2.0f, -12829636);
            this.font.func_211126_b("$120", 3.0f, 32.0f, -12829636);
            this.font.func_211126_b("$30", 64.0f, 31.0f, -12829636);
            this.font.func_211126_b("$10", 35.0f, 31.0f, -12829636);
            this.font.func_211126_b("$15", 91.0f, 31.0f, -12829636);
            this.font.func_211126_b("$5", 121.0f, 31.0f, -12829636);
            this.font.func_211126_b("$10", 146.0f, 31.0f, -12829636);
            this.font.func_211126_b("$5", 68.0f, 64.0f, -12829636);
            this.font.func_211126_b("$2", 37.0f, 63.0f, -12829636);
            this.font.func_211126_b("$350", 3.0f, 63.0f, -12829636);
            this.font.func_211126_b("$", 6.0f, 2.0f, -12829636);
            this.font.func_211126_b("" + (int)JustaphoneModVariables.MapVariables.get((IWorld)this.world).bankAccountMoney + "", 12.0f, 2.0f, -12829636);
        }

        public void removed() {
            super.removed();
            Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
        }

        public void init(Minecraft minecraft, int width, int height) {
            super.init(minecraft, width, height);
            minecraft.field_195559_v.func_197967_a(true);
            this.addButton((Widget)new Button(this.field_147003_i + 94, this.field_147009_r + 51, 45, 20, "Sell", e -> {
                JustaphoneMod.PACKET_HANDLER.sendToServer((Object)new ButtonPressedMessage(0, this.x, this.y, this.z));
                BankingGui.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
            }));
            this.addButton((Widget)new Button(this.field_147003_i + 139, this.field_147009_r + 51, 30, 20, "B", e -> {
                JustaphoneMod.PACKET_HANDLER.sendToServer((Object)new ButtonPressedMessage(1, this.x, this.y, this.z));
                BankingGui.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
            }));
        }
    }

    public static class GuiContainerMod
    extends Container
    implements Supplier<Map<Integer, Slot>> {
        private World world;
        private PlayerEntity entity;
        private int x;
        private int y;
        private int z;
        private IItemHandler internal;
        private Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
        private boolean bound = false;

        public GuiContainerMod(int id, PlayerInventory inv, PacketBuffer extraData) {
            super(containerType, id);
            int si;
            this.entity = inv.field_70458_d;
            this.world = inv.field_70458_d.field_70170_p;
            this.internal = new ItemStackHandler(10);
            BlockPos pos = null;
            if (extraData != null) {
                pos = extraData.func_179259_c();
                this.x = pos.func_177958_n();
                this.y = pos.func_177956_o();
                this.z = pos.func_177952_p();
            }
            if (pos != null) {
                if (extraData.readableBytes() == 1) {
                    byte hand = extraData.readByte();
                    ItemStack itemstack = hand == 0 ? this.entity.func_184614_ca() : this.entity.func_184592_cb();
                    itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                } else if (extraData.readableBytes() > 1) {
                    extraData.readByte();
                    Entity entity = this.world.func_73045_a(extraData.func_150792_a());
                    if (entity != null) {
                        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                } else {
                    TileEntity ent;
                    TileEntity tileEntity = ent = inv.field_70458_d != null ? inv.field_70458_d.field_70170_p.func_175625_s(pos) : null;
                    if (ent != null) {
                        ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                }
            }
            this.customSlots.put(0, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 0, 6, 14){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151045_i, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(1, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 1, 35, 13){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151137_ax, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(2, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 2, 63, 13){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151166_bC, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(3, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 3, 90, 13){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151043_k, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(4, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 4, 117, 13){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151042_j, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(5, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 5, 146, 13){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151128_bU, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(6, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 6, 63, 44){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_196128_bn, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(7, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 7, 36, 44){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Items.field_151044_h, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            this.customSlots.put(9, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 9, 6, 44){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)Blocks.field_150350_a, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            for (si = 0; si < 3; ++si) {
                for (int sj = 0; sj < 9; ++sj) {
                    this.func_75146_a(new Slot((IInventory)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
                }
            }
            for (si = 0; si < 9; ++si) {
                this.func_75146_a(new Slot((IInventory)inv, si, 8 + si * 18, 142));
            }
        }

        @Override
        public Map<Integer, Slot> get() {
            return this.customSlots;
        }

        public boolean func_75145_c(PlayerEntity player) {
            return true;
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (index < 9) {
                    if (!this.func_75135_a(itemstack1, 9, this.field_75151_b.size(), true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(itemstack1, itemstack);
                } else if (!this.func_75135_a(itemstack1, 0, 9, false)) {
                    if (index < 36 ? !this.func_75135_a(itemstack1, 36, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 9, 36, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
            }
            return itemstack;
        }

        protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
            boolean flag = false;
            int i = startIndex;
            if (reverseDirection) {
                i = endIndex - 1;
            }
            if (stack.func_77985_e()) {
                while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    ItemStack itemstack;
                    Slot slot = (Slot)this.field_75151_b.get(i);
                    if (slot.func_75214_a(itemstack = slot.func_75211_c()) && !itemstack.func_190926_b() && GuiContainerMod.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                        int maxSize;
                        int j = itemstack.func_190916_E() + stack.func_190916_E();
                        if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                            stack.func_190920_e(0);
                            itemstack.func_190920_e(j);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        } else if (itemstack.func_190916_E() < maxSize) {
                            stack.func_190918_g(maxSize - itemstack.func_190916_E());
                            itemstack.func_190920_e(maxSize);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        }
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            if (!stack.func_190926_b()) {
                i = reverseDirection ? endIndex - 1 : startIndex;
                while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    Slot slot1 = (Slot)this.field_75151_b.get(i);
                    ItemStack itemstack1 = slot1.func_75211_c();
                    if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                        if (stack.func_190916_E() > slot1.func_75219_a()) {
                            slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                        } else {
                            slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                        }
                        slot1.func_75218_e();
                        flag = true;
                        break;
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            return flag;
        }

        public void func_75134_a(PlayerEntity playerIn) {
            block4: {
                super.func_75134_a(playerIn);
                if (this.bound || !(playerIn instanceof ServerPlayerEntity)) break block4;
                if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                    for (int j = 0; j < this.internal.getSlots(); ++j) {
                        playerIn.func_71019_a(this.internal.extractItem(j, this.internal.getStackInSlot(j).func_190916_E(), false), false);
                    }
                } else {
                    for (int i = 0; i < this.internal.getSlots(); ++i) {
                        playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.internal.extractItem(i, this.internal.getStackInSlot(i).func_190916_E(), false));
                    }
                }
            }
        }

        private void slotChanged(int slotid, int ctype, int meta) {
            if (this.world != null && this.world.field_72995_K) {
                JustaphoneMod.PACKET_HANDLER.sendToServer((Object)new GUISlotChangedMessage(slotid, this.x, this.y, this.z, ctype, meta));
                BankingGui.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
            }
        }
    }

    public static class GuiContainerModFactory
    implements IContainerFactory {
        public GuiContainerMod create(int id, PlayerInventory inv, PacketBuffer extraData) {
            return new GuiContainerMod(id, inv, extraData);
        }
    }
}

