/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.math.Vector3d;
import com.swdteam.panorama.main.Main;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Keybinds;
import com.swdteam.panorama.ui.GuiPanoramaSelector;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="panorama", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Events {
    public static Map<String, NativeImage[]> images = new HashMap<String, NativeImage[]>();
    public static Vector3d position;
    static String currentName;
    static NativeImage[] screenshots;
    static boolean takePanorama;
    public static int index;
    public static double backupFov;
    static int timer;

    @SubscribeEvent
    public static void screenshotEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91075_ != null && Keybinds.SCREENSHOT.m_90857_() && !takePanorama) {
            LocalPlayer pe = Minecraft.m_91087_().f_91074_;
            position = new Vector3d(pe.m_20185_(), pe.m_20186_(), pe.m_20189_());
            backupFov = Minecraft.m_91087_().f_91066_.f_92068_;
            Minecraft.m_91087_().f_91066_.f_92068_ = 90.0;
            currentName = "panorama-" + System.currentTimeMillis() / 100L;
            screenshots = new NativeImage[6];
            takePanorama = true;
            index = 0;
        }
    }

    public static void takeScreenshot(Window window, int index) {
        int fromX;
        int dimension;
        NativeImage image = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        File file = new File("temp/panorama_" + index + ".png");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        int imageWidth = image.m_84982_();
        int imageHeight = image.m_85084_();
        int fromY = 0;
        if (imageWidth > imageHeight) {
            dimension = imageHeight;
            fromX = imageWidth / 2 - dimension / 2;
        } else {
            dimension = imageWidth;
            fromX = imageWidth / 2 - dimension / 2;
        }
        NativeImage image2 = new NativeImage(dimension, dimension, true);
        image.m_85034_(fromX, fromY, dimension, dimension, image2);
        Events.screenshots[index] = image2;
    }

    @SubscribeEvent
    public static void cameraEvent(EntityViewRenderEvent.CameraSetup event) {
        if (takePanorama && index < 6) {
            Facing f = Facing.getIndex(index);
            event.setYaw(f.yaw);
            event.setPitch(f.pitch);
            event.setRoll(0.0f);
        }
    }

    @SubscribeEvent
    public static void fovEvent(EntityViewRenderEvent.FieldOfView event) {
        if (takePanorama) {
            event.setFOV(90.0);
        }
    }

    @SubscribeEvent
    public static void blockOverlayEvent(RenderBlockOverlayEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldEvent(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (takePanorama) {
            if (timer >= 2) {
                timer = 0;
                if (index < 6) {
                    mc.f_91066_.f_92068_ = 90.0;
                    Window window = mc.m_91268_();
                    Events.takeScreenshot(window, index);
                    ++index;
                } else {
                    takePanorama = false;
                    mc.f_91066_.f_92068_ = backupFov;
                    images.put(currentName, screenshots);
                    try {
                        Util.zipFiles(currentName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ++timer;
            }
        } else {
            timer = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void guiEvent(RenderHandEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void guiEvent(RenderGameOverlayEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void guiEvent(ScreenOpenEvent event) {
        if (event.getScreen() instanceof TitleScreen) {
            TitleScreen gui = (TitleScreen)event.getScreen();
            gui.f_96729_ = Main.SKYBOX;
        }
    }

    @SubscribeEvent
    public static void guiEvent(ScreenEvent.InitScreenEvent event) {
        if (event.getScreen() instanceof TitleScreen) {
            TitleScreen gui = (TitleScreen)event.getScreen();
            Button b = new Button(4, 4, 60, 20, (Component)new TextComponent("Panorama"), button -> Minecraft.m_91087_().m_91152_((Screen)new GuiPanoramaSelector()));
            gui.f_96540_.add(b);
            gui.f_169369_.add(b);
        }
    }

    static {
        currentName = "";
        takePanorama = false;
        index = 0;
        backupFov = 70.0;
        timer = 0;
    }

    public static enum Facing {
        SOUTH(0.0f, 0.0f),
        WEST(90.0f, 0.0f),
        NORTH(180.0f, 0.0f),
        EAST(-90.0f, 0.0f),
        UP(0.0f, -90.0f),
        DOWN(0.0f, 90.0f);

        float yaw;
        float pitch;

        private Facing(float yaw, float pitch) {
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public static Facing getIndex(int index) {
            return Facing.values()[index];
        }
    }
}

