/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.ui;

import com.swdteam.panorama.Config;
import com.swdteam.panorama.Panorama;
import com.swdteam.panorama.Util;
import com.swdteam.panorama.registry.PanoramaInstance;
import com.swdteam.panorama.registry.PanoramaRegistry;
import com.swdteam.panorama.ui.PanoramaButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;

public class GuiPanoramaSelector
extends class_437 {
    private class_342 searchBox;
    private List<PanoramaInstance> panoramas = new ArrayList<PanoramaInstance>();
    private List<PanoramaButton> panoButtons = new ArrayList<PanoramaButton>();
    private class_4185 btnPreviousPage;
    private class_4185 btnNextPage;
    private int page = 0;
    private class_2561 tooltip;

    public GuiPanoramaSelector() {
        super((class_2561)class_2561.method_43470((String)"Panorama Selection GUI"));
        this.panoramas = PanoramaRegistry.PANORAMAS;
    }

    protected void method_25426() {
        super.method_25426();
        this.page = 0;
        this.searchBox = new class_342(this.field_22787.field_1772, this.field_22789 / 2 - 148, this.field_22790 / 2 + 80, 70, 20, (class_342)null, (class_2561)class_2561.method_43471((String)"panorama.search"));
        this.method_37063((class_364)this.searchBox);
        this.method_20086((class_364)this.searchBox);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 72, this.field_22790 / 2 + 80, 46, 20, (class_2561)class_2561.method_43470((String)"Search"), p_86647_ -> {
            if (this.searchBox.method_1882() != null && this.searchBox.method_1882().length() > 0) {
                this.page = 0;
                this.panoramas = PanoramaRegistry.getAllForName(this.searchBox.method_1882());
                this.btnNextPage.field_22763 = this.panoramas.size() > 8;
                this.refreshButtons();
            }
        }));
        this.btnPreviousPage = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 22, this.field_22790 / 2 + 80, 80, 20, (class_2561)class_2561.method_43470((String)"Previous Page"), p_86647_ -> {
            if (this.page - 1 >= 0) {
                --this.page;
                this.btnNextPage.field_22763 = true;
                this.refreshButtons();
                if (this.page - 1 < 0) {
                    this.btnPreviousPage.field_22763 = false;
                }
            }
        }));
        this.btnPreviousPage.field_22763 = false;
        this.btnNextPage = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 62, this.field_22790 / 2 + 80, 80, 20, (class_2561)class_2561.method_43470((String)"Next Page"), p_86647_ -> {
            if ((this.page + 1) * 8 < this.panoramas.size()) {
                ++this.page;
                this.btnPreviousPage.field_22763 = true;
                this.refreshButtons();
                if ((this.page + 1) * 8 >= this.panoramas.size()) {
                    this.btnNextPage.field_22763 = false;
                }
            }
        }));
        this.method_37063((class_364)new class_4185(4, 4, 60, 20, (class_2561)class_2561.method_43470((String)"Back"), p_86647_ -> {
            if (class_310.method_1551().field_1687 == null) {
                class_310.method_1551().method_1507((class_437)new class_442());
            } else {
                class_310.method_1551().method_1507((class_437)new class_433(true));
            }
        }));
        this.method_37063((class_364)new class_4185(70, 4, 80, 20, (class_2561)class_2561.method_43470((String)("Res: " + Config.INSTANCE.save_resolution.name)), p_86647_ -> {
            switch (Config.INSTANCE.save_resolution) {
                case DEFAULT: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_64;
                    break;
                }
                case R_64: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_128;
                    break;
                }
                case R_128: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_256;
                    break;
                }
                case R_256: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_512;
                    break;
                }
                case R_512: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_1024;
                    break;
                }
                case R_1024: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_2048;
                    break;
                }
                case R_2048: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.R_4096;
                    break;
                }
                case R_4096: {
                    Config.INSTANCE.save_resolution = Panorama.CaptureResolution.DEFAULT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + Config.INSTANCE.save_resolution);
                }
            }
            p_86647_.method_25355((class_2561)class_2561.method_43470((String)("Res: " + Config.INSTANCE.save_resolution.name)));
            Config.save();
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 64, 4, 60, 20, (class_2561)class_2561.method_43470((String)"Reload"), p_86647_ -> {
            this.page = 0;
            PanoramaRegistry.setup();
            this.panoramas = PanoramaRegistry.PANORAMAS;
            this.btnNextPage.field_22763 = this.panoramas.size() > 8;
            this.refreshButtons();
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 128, 4, 60, 20, (class_2561)class_2561.method_43470((String)"Reset"), p_86647_ -> {
            try {
                Util.loadPack("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        if (this.panoramas.size() <= 8) {
            this.btnNextPage.field_22763 = false;
        }
        this.refreshButtons();
    }

    public void refreshButtons() {
        int i;
        for (i = 0; i < this.panoButtons.size(); ++i) {
            PanoramaButton b = this.panoButtons.get(i);
            this.method_37066((class_364)b);
        }
        for (i = this.page * 8; i < this.page * 8 + 8; ++i) {
            if (i >= this.panoramas.size()) continue;
            PanoramaInstance pan = this.panoramas.get(i);
            this.addPanoramaButton(new PanoramaButton(this, pan, this.field_22789 / 2 - 148 + i % 4 * 74, this.field_22790 / 2 + i % 8 / 4 * 74 - 74));
        }
    }

    public void addPanoramaButton(PanoramaButton btn) {
        this.method_37063((class_364)btn);
        this.panoButtons.add(btn);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        Panorama.SKYBOX.method_3317(partialTicks, class_3532.method_15363((float)1.0f, (float)0.0f, (float)1.0f));
        GuiPanoramaSelector.method_25300((class_4587)matrixStack, (class_327)this.field_22793, (String)"(Capture Res)", (int)110, (int)26, (int)-1052689);
        GuiPanoramaSelector.method_25300((class_4587)matrixStack, (class_327)this.field_22793, (String)"Panorama Selector", (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 102), (int)-1);
        if (this.panoramas.size() <= 0) {
            GuiPanoramaSelector.method_25300((class_4587)matrixStack, (class_327)this.field_22793, (String)"No Panoramas Found", (int)(this.field_22789 / 2), (int)(this.field_22790 / 2), (int)-1);
        }
        if (this.searchBox != null) {
            this.searchBox.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.tooltip = null;
        for (int i = 0; i < this.panoButtons.size(); ++i) {
            PanoramaButton bb;
            PanoramaButton b = this.panoButtons.get(i);
            if (!(b instanceof PanoramaButton) || !(bb = b).method_25367()) continue;
            this.tooltip = bb.method_25369();
        }
        if (this.tooltip != null) {
            this.method_25424(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public void method_25393() {
        if (this.searchBox != null) {
            this.searchBox.method_1865();
        }
        super.method_25393();
    }
}

