/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.swdteam.panorama.main.Config;
import com.swdteam.panorama.main.Main;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Panorama;
import com.swdteam.panorama.main.registry.PanoramaRegistry;
import com.swdteam.panorama.ui.PanoramaButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GuiPanoramaSelector
extends Screen {
    private EditBox searchBox;
    private List<Panorama> panoramas = new ArrayList<Panorama>();
    private List<PanoramaButton> panoButtons = new ArrayList<PanoramaButton>();
    private Button btnPreviousPage;
    private Button btnNextPage;
    private int page = 0;
    private Component tooltip;

    public GuiPanoramaSelector() {
        super((Component)Component.m_237113_((String)"Panorama Selection GUI"));
        this.panoramas = PanoramaRegistry.PANORAMAS;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.page = 0;
        this.searchBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 148, this.f_96544_ / 2 + 80, 70, 20, (EditBox)null, (Component)Component.m_237115_((String)"panorama.search"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_94718_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 72, this.f_96544_ / 2 + 80, 46, 20, (Component)Component.m_237113_((String)"Search"), p_86647_ -> {
            if (this.searchBox.m_94155_() != null && this.searchBox.m_94155_().length() > 0) {
                this.page = 0;
                this.panoramas = PanoramaRegistry.getAllForName(this.searchBox.m_94155_());
                this.btnNextPage.f_93623_ = this.panoramas.size() > 8;
                this.refreshButtons();
            }
        }));
        this.btnPreviousPage = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 22, this.f_96544_ / 2 + 80, 80, 20, (Component)Component.m_237113_((String)"Previous Page"), p_86647_ -> {
            if (this.page - 1 >= 0) {
                --this.page;
                this.btnNextPage.f_93623_ = true;
                this.refreshButtons();
                if (this.page - 1 < 0) {
                    this.btnPreviousPage.f_93623_ = false;
                }
            }
        }));
        this.btnPreviousPage.f_93623_ = false;
        this.btnNextPage = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 62, this.f_96544_ / 2 + 80, 80, 20, (Component)Component.m_237113_((String)"Next Page"), p_86647_ -> {
            if ((this.page + 1) * 8 < this.panoramas.size()) {
                ++this.page;
                this.btnPreviousPage.f_93623_ = true;
                this.refreshButtons();
                if ((this.page + 1) * 8 >= this.panoramas.size()) {
                    this.btnNextPage.f_93623_ = false;
                }
            }
        }));
        this.m_142416_((GuiEventListener)new Button(4, 4, 60, 20, (Component)Component.m_237113_((String)"Back"), p_86647_ -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                Minecraft.m_91087_().m_91152_((Screen)new TitleScreen());
            } else {
                Minecraft.m_91087_().m_91152_((Screen)new PauseScreen(true));
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 64, 4, 60, 20, (Component)Component.m_237113_((String)"Reload"), p_86647_ -> {
            this.page = 0;
            PanoramaRegistry.setup();
            this.panoramas = PanoramaRegistry.PANORAMAS;
            this.btnNextPage.f_93623_ = this.panoramas.size() > 8;
            this.refreshButtons();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 128, 4, 60, 20, (Component)Component.m_237113_((String)"Reset"), p_86647_ -> {
            try {
                Util.loadPack("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        this.m_142416_((GuiEventListener)new Button(70, 4, 80, 20, (Component)Component.m_237113_((String)("Res: " + Config.INSTANCE.save_resolution.name)), p_86647_ -> {
            switch (Config.INSTANCE.save_resolution) {
                case DEFAULT: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_64;
                    break;
                }
                case R_64: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_128;
                    break;
                }
                case R_128: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_256;
                    break;
                }
                case R_256: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_512;
                    break;
                }
                case R_512: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_1024;
                    break;
                }
                case R_1024: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_2048;
                    break;
                }
                case R_2048: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.R_4096;
                    break;
                }
                case R_4096: {
                    Config.INSTANCE.save_resolution = Main.CaptureResolution.DEFAULT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + Config.INSTANCE.save_resolution);
                }
            }
            p_86647_.m_93666_((Component)Component.m_237113_((String)("Res: " + Config.INSTANCE.save_resolution.name)));
            Config.save();
        }));
        if (this.panoramas.size() <= 8) {
            this.btnNextPage.f_93623_ = false;
        }
        this.refreshButtons();
    }

    public void refreshButtons() {
        this.f_96540_.removeAll(this.panoButtons);
        this.f_169369_.removeAll(this.panoButtons);
        for (int i = this.page * 8; i < this.page * 8 + 8; ++i) {
            if (i >= this.panoramas.size()) continue;
            Panorama pan = this.panoramas.get(i);
            this.addPanoramaButton(new PanoramaButton(this, pan, this.f_96543_ / 2 - 148 + i % 4 * 74, this.f_96544_ / 2 + i % 8 / 4 * 74 - 74));
        }
    }

    public void addPanoramaButton(PanoramaButton btn) {
        this.m_142416_((GuiEventListener)btn);
        this.panoButtons.add(btn);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Main.SKYBOX.m_110003_(partialTicks, Mth.m_14036_((float)1.0f, (float)0.0f, (float)1.0f));
        GuiPanoramaSelector.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"(Capture Res)", (int)110, (int)26, (int)-1052689);
        GuiPanoramaSelector.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Panorama Selector", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 102), (int)-1);
        if (this.panoramas.size() <= 0) {
            GuiPanoramaSelector.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"No Panoramas Found", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-1);
        }
        if (this.searchBox != null) {
            this.searchBox.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.tooltip = null;
        for (int i = 0; i < this.f_169369_.size(); ++i) {
            PanoramaButton bb;
            Widget b = (Widget)this.f_169369_.get(i);
            if (!(b instanceof PanoramaButton) || !(bb = (PanoramaButton)b).m_198029_()) continue;
            this.tooltip = bb.m_6035_();
        }
        if (this.tooltip != null) {
            this.m_96602_(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public void m_86600_() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        super.m_86600_();
    }
}

