/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.client.HookShotRenderer;
import com.endertech.minecraft.mods.adhooks.client.LauncherModel;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.init.Entities;
import com.endertech.minecraft.mods.adhooks.init.Items;
import com.endertech.minecraft.mods.adhooks.items.Properties;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adhooks")
public class AdHooks
extends ForgeMod {
    public static final String ID = "adhooks";
    public static final String NAME = "Advanced Hook Launchers";
    private static AdHooks instance;
    public final Items items;
    public final Entities entities;

    public static AdHooks getInstance() {
        return instance;
    }

    public AdHooks() {
        instance = this;
        this.items = new Items(this);
        this.entities = new Entities(this);
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(WatchedBoolMsg::new);
        this.registerNetMessage(MakeShotMsg::new);
        this.registerNetMessage(TarzanJumpMsg::new);
        this.registerNetMessage(Properties::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ControlBindings.initialize();
        this.registerEntityRender(this.entities.hookShot, HookShotRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (HookType type : HookType.values()) {
            IBakedModel hook = registry.getModelOf((Item)type.hook);
            IBakedModel launcher = registry.getModelOf((Item)type.launcher);
            registry.replaceModelOf((Item)type.launcher, (IBakedModel)new LauncherModel(launcher, hook));
        }
    }
}

