/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RopeRenderer {
    public static final RenderType RENDER_TYPE = RenderType.func_228634_a_((ResourceLocation)GameRendering.EMPTY_TEXTURE);
    protected final HookShot hookShot;
    protected final EntityRendererManager renderManager;
    protected final IVertexBuilder builder;
    protected final MatrixStack matrix;
    protected final ColorARGB color;
    protected final int light;

    public RopeRenderer(HookShot hookShot, EntityRendererManager renderManager, IRenderTypeBuffer buffer, MatrixStack matrix, int light) {
        this.hookShot = hookShot;
        this.renderManager = renderManager;
        this.builder = buffer.getBuffer(RENDER_TYPE);
        this.matrix = matrix;
        this.color = hookShot.getRope().color;
        this.light = light;
    }

    public void render(float partialTicks) {
        if (this.hookShot == null) {
            return;
        }
        LivingEntity shooter = this.hookShot.getShooter().orElse(null);
        if (shooter == null) {
            return;
        }
        Vect3d launcherPos = this.hookShot.getLauncherPosition(this.renderManager.field_78733_k.func_243230_g(), partialTicks);
        Vect3d hookShotPos = this.hookShot.getCurPosition(partialTicks);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = this.hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook.getStrength();
            float tensionForce = this.hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.getElasticity()) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(rope.width)).approxDown(tensionFactor).floatValue();
            float sagging = this.hookShot.getSagging();
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                Objects.requireNonNull(rope);
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                this.drawSegment(fromPoint, toPoint, ropeWidth);
                fromPoint = toPoint;
            }
        }
    }

    protected void vertex(MatrixStack.Entry matrixEntry, double x, double y, double z, float u, float v) {
        this.builder.func_227888_a_(matrixEntry.func_227870_a_(), (float)x, (float)y, (float)z).func_225586_a_(this.color.getRed().value, this.color.getGreen().value, this.color.getBlue().value, this.color.getAlpha().value).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(this.light).func_227887_a_(matrixEntry.func_227872_b_(), 0.0f, 0.0f, 1.0f).func_181675_d();
    }

    protected void drawSegment(Vect3d from, Vect3d to, float width) {
        Vect3d ropeVec = to.subtract(from);
        double length = ropeVec.length();
        double hw = (double)width / 2.0 * 0.01;
        this.matrix.func_227860_a_();
        this.matrix.func_227861_a_(from.x, from.y, from.z);
        this.matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ropeVec.yaw()));
        this.matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f - ropeVec.pitch()));
        MatrixStack.Entry matrixEntry = this.matrix.func_227866_c_();
        for (int j = 0; j < 4; ++j) {
            this.vertex(matrixEntry, -hw, 0.0, hw, 0.0f, 0.0f);
            this.vertex(matrixEntry, hw, 0.0, hw, 1.0f, 0.0f);
            this.vertex(matrixEntry, hw, length, hw, 1.0f, 1.0f);
            this.vertex(matrixEntry, -hw, length, hw, 0.0f, 1.0f);
            this.matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        }
        this.matrix.func_227865_b_();
    }
}

