/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.hook;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.endertech.minecraft.mods.adhooks.motion.ClientPlayerTarget;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HookShot
extends ForgeEntity {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = Rope.LENGTH_BOUNDS.getMax();
    private float shootStrength = 1.5f;
    protected Direction hitSide = null;
    protected LivingEntity shooter = null;
    protected final Combustion combustion = new Combustion();

    public HookShot(EntityType<HookShot> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public HookShot(World world, LivingEntity shooter, HookType hookType) {
        super(AdHooks.getInstance().entities.hookShot, world);
        this.shooter = shooter;
        this.field_70180_af.func_187227_b(WatchedInt.SHOOTER_ID.key, (Object)shooter.func_145782_y());
        this.field_70180_af.func_187227_b(WatchedInt.HOOK_TYPE.key, (Object)hookType.ordinal());
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.func_226277_ct_() - (double)GameMath.cos((float)this.field_70177_z) * 0.16, this.func_226278_cu_() - 0.1, this.func_226281_cx_() - (double)GameMath.sin((float)this.field_70177_z) * 0.16);
        float motionX = -GameMath.sin((float)this.field_70177_z) * GameMath.cos((float)this.field_70125_A);
        float motionZ = GameMath.cos((float)this.field_70177_z) * GameMath.cos((float)this.field_70125_A);
        float motionY = -GameMath.sin((float)this.field_70125_A);
        this.shoot(motionX, motionY, motionZ, this.shootStrength, 1.0f);
        if (world != null && shooter != null) {
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    protected void developMsg(String valueName, Object value) {
        ForgeEndertech.developMsg((String)((this.isClientSide() ? "CLIENT" : "SERVER") + ": " + valueName + " = " + value.toString()));
    }

    protected void func_70088_a() {
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.field_70180_af.func_187214_a(watchedBool.key, (Object)false);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.field_70180_af.func_187214_a(((WatchedInt)enum_).key, (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.field_70180_af.func_187214_a(((WatchedFloat)enum_).key, (Object)Float.valueOf(0.0f));
        }
        this.setState(State.SHOOTING);
    }

    public boolean isLoosening() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.LOOSENING.key);
    }

    public void setLoosening(boolean loosening) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedBool.LOOSENING.key, (Object)loosening);
        }
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.PULLING.key);
    }

    public void setPulling(boolean pulling) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedBool.PULLING.key, (Object)pulling);
        }
    }

    public State getPrevState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.PREV_STATE.key);
        return State.values()[i];
    }

    public State getState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.STATE.key);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState;
        if (this.isServerSide() && state != (prevState = this.getState())) {
            this.field_70180_af.func_187227_b(WatchedInt.PREV_STATE.key, (Object)prevState.ordinal());
            this.field_70180_af.func_187227_b(WatchedInt.STATE.key, (Object)state.ordinal());
        }
    }

    public float getRopeLength() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.ROPE_LENGTH.key)).floatValue();
    }

    public void setRopeLength(float ropeLength) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedFloat.ROPE_LENGTH.key, (Object)Float.valueOf(ropeLength));
        }
    }

    public float getSagging() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.SAGGING.key)).floatValue();
    }

    public void setSagging(float sagging) {
        if (this.isServerSide()) {
            if (sagging < 0.0f) {
                sagging = 0.0f;
            }
            this.field_70180_af.func_187227_b(WatchedFloat.SAGGING.key, (Object)Float.valueOf(sagging));
        }
    }

    public HookType getHookType() {
        int ordinal = (Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOK_TYPE.key);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public BlockAction getBlockAction(World world, BlockPos pos) {
        if (GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) {
            return BlockAction.PASS;
        }
        BlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        HookType hookType = this.getHookType();
        Hook hook = hookType.hook;
        switch (hookType) {
            case WEB: {
                if (hook.canHookAnyBlock) {
                    return BlockAction.HOOK;
                }
                if (material == Material.field_151595_p) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
            case PUDGE: {
                if (material == Material.field_151592_s) {
                    return BlockAction.BREAK;
                }
                if (material == Material.field_151584_j) {
                    return BlockAction.BREAK;
                }
                return BlockAction.BOUNCE;
            }
            case SPEAR: {
                float hardness;
                if (material == Material.field_151592_s) {
                    return BlockAction.BREAK;
                }
                if (material == Material.field_151584_j) {
                    return BlockAction.PASS;
                }
                if (material == Material.field_151575_d) {
                    return BlockAction.HOOK;
                }
                if (!hook.canHookAnyBlock && ((hardness = state.func_185887_b((IBlockReader)world, pos)) < 0.0f || hardness > hookType.hook.getStrength() / 2.0f)) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
        }
        return BlockAction.BOUNCE;
    }

    protected Vect3d getHitPosition() {
        return Vect3d.from((double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_X.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Y.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Z.key)).floatValue());
    }

    public Vect3d getLauncherPosition() {
        return this.getShooter().map(shooter -> HookShot.getCenterPosition((Entity)shooter)).orElse(Vect3d.ZERO);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vect3d getLauncherPosition(PointOfView pov, float partialTicks) {
        double dx;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter == null) {
            return Vect3d.ZERO;
        }
        Hand hand = this.getLauncherHand().orElse(null);
        double d = dx = hand != null ? 0.2 : 0.0;
        if (hand == Hand.MAIN_HAND) {
            dx = -dx;
        }
        Vect3d offset = Vect3d.from((double)dx, (double)0.0, (double)0.0);
        float yaw = shooter.field_70761_aq;
        if (shooter instanceof ClientPlayerEntity && pov == PointOfView.FIRST_PERSON) {
            offset = offset.move(0.0, 0.0, -0.6);
            yaw = shooter.func_195046_g(partialTicks);
        }
        offset = offset.rotateAroundY(-yaw);
        return HookShot.getCenterPosition((Entity)shooter, (float)partialTicks).add(offset);
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (this.isServerSide() && hitPosition != null) {
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_X.key, (Object)Float.valueOf((float)hitPosition.x));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Y.key, (Object)Float.valueOf((float)hitPosition.y));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Z.key, (Object)Float.valueOf((float)hitPosition.z));
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public Optional<Hand> getLauncherHand() {
        int value = (Integer)this.field_70180_af.func_187225_a(WatchedInt.LAUNCHER_HAND.key);
        return value >= 0 ? Optional.of(Hand.values()[value]) : Optional.empty();
    }

    protected void updateLauncherHand() {
        if (!this.isServerSide()) {
            return;
        }
        int value = -1;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter != null) {
            for (Hand hand : Hand.values()) {
                ItemStack itemStack = shooter.func_184586_b(hand);
                if (!Launcher.isAttachedToHookShot(itemStack, this)) continue;
                value = hand.ordinal();
                break;
            }
        }
        this.field_70180_af.func_187227_b(WatchedInt.LAUNCHER_HAND.key, (Object)value);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_X.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Y.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Z.key)).intValue());
    }

    protected void setHookedBlockPos(BlockRayTraceResult hit) {
        if (this.isServerSide()) {
            BlockPos pos = hit.func_216350_a();
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_X.key, (Object)pos.func_177958_n());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Y.key, (Object)pos.func_177956_o());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Z.key, (Object)pos.func_177952_p());
        }
    }

    protected void onTargetHit(RayTraceResult hit) {
        if (hit == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vector3d)hit.func_216347_e());
        if (hit instanceof BlockRayTraceResult) {
            BlockRayTraceResult trace = (BlockRayTraceResult)hit;
            BlockPos pos = trace.func_216350_a();
            BlockAction action = this.getBlockAction(this.field_70170_p, pos);
            if (action == BlockAction.BOUNCE && this.getHook().canHookAnyBlock) {
                action = BlockAction.HOOK;
            }
            switch (action) {
                case HOOK: {
                    break;
                }
                case BREAK: {
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    this.field_70170_p.func_175655_b(pos, state.func_185904_a() != Material.field_151592_s);
                }
                case BOUNCE: {
                    this.setState(State.REELING);
                }
                default: {
                    return;
                }
            }
            this.hitSide = trace.func_216354_b();
            Vect3d offsetVec = Vect3d.from((Vector3i)this.hitSide.func_176730_m()).scale(0.05);
            hitPosition = hitPosition.add(offsetVec);
            this.setHookedBlockPos(trace);
            this.setHitPosition(hitPosition);
            this.setState(State.HOOKING_BLOCK);
        } else if (hit instanceof EntityRayTraceResult) {
            Entity target = ((EntityRayTraceResult)hit).func_216348_a();
            if (target instanceof EnderDragonPartEntity) {
                target = ((EnderDragonPartEntity)target).field_213852_b;
            }
            if (!this.canBeAttachedTo(target)) {
                return;
            }
            float damage = this.getHookType().hook.getDamage();
            if (damage > 0.0f) {
                target.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.getShooter().orElse(null)).func_76349_b(), damage);
            }
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_ENTITY_ID.key, (Object)target.func_145782_y());
            this.setState(State.HOOKING_ENTITY);
        } else {
            return;
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)this.getHookType().launcher.getReelingSpeed());
        this.setRopeLength(ropeLength);
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    protected boolean canBeAttachedTo(Entity entity) {
        HookType type = this.getHookType();
        Hook hook = type.hook;
        if (entity == null || hook == null || this.getShooter() == null) {
            return false;
        }
        return entity instanceof PlayerEntity ? hook.affectsPlayers : hook.affectsNPCs;
    }

    protected void updatePhysics() {
        Entity hookedEntity;
        HookType hookType = this.getHookType();
        State state = this.getState();
        LivingEntity shooter = this.getShooter().orElse(null);
        Entity entity = hookedEntity = state == State.HOOKING_ENTITY ? (Entity)this.findHookedEntity().orElse(null) : null;
        if (shooter == null || !shooter.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)shooter;
            if (!Launcher.findAttachedLauncher(player.field_71071_by, this).isPresent()) {
                this.func_70106_y();
                return;
            }
        }
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        Vect3d hookPosition = this.getCurPosition();
        FloatBounds ropeLengthBounds = hookType.rope.getLengthBounds(shooter, hookedEntity);
        float ropeLength = ropeLengthBounds.enclose(Float.valueOf(this.getRopeLength())).floatValue();
        float reelingSpeed = hookType.launcher.getReelingSpeed();
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeLengthBounds.getMax().floatValue())) break;
                this.setState(State.REELING);
                return;
            }
            case REELING: {
                float reelingSpeedMult = 4.0f;
                if (this.isPulling()) {
                    reelingSpeedMult *= 2.0f;
                }
                Vect3d motionVec = launcherPosition.subtract(hookPosition).resize((double)(reelingSpeed * reelingSpeedMult));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeLengthBounds.getMin().floatValue()) && !(hookDistance <= hookNextDistance)) break;
                this.func_70106_y();
                return;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = hookPosition.subtract(launcherPosition).resize((double)tensionForce);
                float hookStrength = hookType.hook.getStrength();
                if (tensionForce > hookStrength) {
                    this.setState(State.REELING);
                    return;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                this.addMotionTo((Entity)shooter, tensionVec);
                break;
            }
            case HOOKING_ENTITY: {
                float targetWeight;
                if (hookedEntity == null) {
                    this.setState(State.REELING);
                    return;
                }
                if (ropeLength <= hookDistance || tensionVec.notZero()) {
                    HookShot.setFallDistance((Entity)hookedEntity, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    this.addMotionTo(hookedEntity, tensionVec);
                    this.func_70106_y();
                    return;
                }
                float shooterWeightAdvantage = hookType.launcher.getShooterWeightFactor();
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)false) * shooterWeightAdvantage;
                float totalWeight = (shooterWeight += HookShot.getWeight((Entity)shooter, (boolean)true)) + (targetWeight = HookShot.getWeight((Entity)hookedEntity, (boolean)true));
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                this.addMotionTo(hookedEntity, tensionVec.invert().scale((double)(shooterWeight / totalWeight)));
                this.addMotionTo((Entity)shooter, tensionVec.scale((double)(targetWeight / totalWeight)));
                break;
            }
        }
        ropeLength = ropeLengthBounds.enclose(Float.valueOf(ropeLength)).floatValue();
        if (this.isServerSide()) {
            this.setRopeLength(ropeLength);
            this.setSagging(ropeLength - hookDistance);
            this.setState(state);
            this.setTensionForce(tensionForce);
        }
    }

    protected void setTensionForce(float tensionForce) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedFloat.TENSION_FORCE.key, (Object)Float.valueOf(tensionForce));
        }
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    protected void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        LivingEntity shooter = this.getShooter().orElse(null);
        Hand launcherHand = this.getLauncherHand().orElse(null);
        if (hookType == null || shooter == null || launcherHand == null) {
            return;
        }
        State state = this.getState();
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.getReelingSpeed();
        switch (state) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (this.isPulling()) {
                    ropeLength -= pullingSpeed;
                }
                if (!this.isLoosening() || hookType == HookType.PUDGE) break;
                ropeLength += pullingSpeed;
                break;
            }
        }
        if (((Boolean)this.field_70180_af.func_187225_a(WatchedBool.UNHOOKING.key)).booleanValue()) {
            ropeLength -= (pullingSpeed *= 4.0f);
            if (((Boolean)this.field_70180_af.func_187225_a(WatchedBool.JUMPING.key)).booleanValue() && state == State.HOOKING_BLOCK && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
                this.doTarzanJump();
            }
            this.setState(State.REELING);
            return;
        }
        switch (state) {
            case HOOKING_BLOCK: {
                if (!shooter.func_70051_ag() || !CommonMath.notZero((double)this.getTensionForce())) break;
                ropeLength += pullingSpeed;
                break;
            }
            case HOOKING_ENTITY: {
                if (hookType != HookType.PUDGE || this.isLoosening()) break;
                ropeLength -= pullingSpeed * 2.0f;
                break;
            }
        }
        if (ropeLength < 0.0f) {
            ropeLength = 0.0f;
        }
        this.setRopeLength(ropeLength);
    }

    public Rope getRope() {
        return this.getHookType().rope;
    }

    public Launcher getLauncher() {
        return this.getHookType().launcher;
    }

    public Hook getHook() {
        return this.getHookType().hook;
    }

    protected void addMotionTo(Entity entity, Vect3d motion) {
        EntityTarget target = MotionController.getTarget(entity.func_184208_bv()).orElse(null);
        if (target != null) {
            target.addDampedMotion(motion);
            if (HookShot.isClientSide((Entity)entity) && target instanceof ClientPlayerTarget) {
                ((ClientPlayerTarget)target).setSwinging(!entity.func_233570_aj_());
            }
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    public Optional<LivingEntity> getShooter() {
        Entity entity;
        if (this.shooter == null && (entity = GameWorld.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.SHOOTER_ID.key)))) instanceof LivingEntity) {
            this.shooter = (LivingEntity)entity;
        }
        return Optional.ofNullable(this.shooter);
    }

    public Block getHookedBlock() {
        return GameWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos());
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.field_150350_a;
    }

    public Optional<Entity> findHookedEntity() {
        return Optional.ofNullable(HookShot.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_ENTITY_ID.key))));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.move();
        this.setPrevRotation(this.getCurRotation());
        this.updateLauncherHand();
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
    }

    protected void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = this.getHookType().hook.resistance;
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = GameWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos().func_177972_a(this.hitSide)) == Blocks.field_150480_ab;
                    break;
                }
                case HOOKING_ENTITY: {
                    fireInfluenced = this.findHookedEntity().map(entity -> entity.func_70027_ad()).orElse(false);
                    break;
                }
            }
            if (this.func_70027_ad()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.func_70015_d(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.func_70106_y();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    protected void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<Object> allHits = new ArrayList<Object>();
        BlockRayTraceResult hit = GameWorld.rayTraceBlocks((World)this.func_130014_f_(), (Vect3d)this.getPrevPosition(), (Vect3d)this.getCurPosition(), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE, (Entity)this);
        if (hit != null && hit.func_216346_c() != RayTraceResult.Type.MISS) {
            allHits.add(hit);
        }
        AxisAlignedBB aabb = this.getBB().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        List entities = this.getEntitiesWithinAABB(aabb);
        Entity shooter = this.getShooter().orElse(null);
        Entity shooterRide = shooter != null ? shooter.func_184187_bx() : null;
        for (Entity target : entities) {
            Optional hit2;
            if (target == shooter && state == State.REELING) {
                this.func_70106_y();
                return;
            }
            if (!this.isServerSide() || !target.func_70067_L() && !(target instanceof ItemEntity) || target == shooter || target == shooterRide || !(hit2 = HookShot.getBB((Entity)target).func_186662_g((double)target.func_70111_Y()).func_186662_g(0.2).func_216365_b(this.getCurPosition().toVector3d(), this.getNextPosition().toVector3d())).isPresent()) continue;
            allHits.add(new EntityRayTraceResult(target, HookShot.getCenterPosition((Entity)target).toVector3d()));
        }
        RayTraceResult nearestHit = null;
        double minDistance = Double.MAX_VALUE;
        for (RayTraceResult rayTraceResult : allHits) {
            double distance = this.getCurPosition().distance(Vect3d.from((Vector3d)rayTraceResult.func_216347_e()));
            if (!(distance < minDistance)) continue;
            nearestHit = rayTraceResult;
            minDistance = distance;
        }
        if (nearestHit != null) {
            this.onTargetHit(nearestHit);
        }
    }

    protected void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity().orElse(null);
                    if (!(entity == null || !entity.func_70089_S() || entity instanceof LivingEntity && ((LivingEntity)entity).field_82175_bq && entity.func_213453_ef() || entity instanceof PlayerEntity && entity.func_184218_aH() && ((PlayerEntity)entity).field_82175_bq) && !HookShot.hasSwingingPlayerPassenger((Entity)entity)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    public boolean isHookingTarget() {
        switch (this.getState()) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                return true;
            }
        }
        return false;
    }

    protected void updateRotation() {
        if (this.isHookingTarget()) {
            this.setAllRotations(this.getCurRotation());
        } else {
            Vect3d motion = this.getCurMotion();
            if (motion.notZero()) {
                if (this.getState() == State.REELING) {
                    motion = motion.invert();
                }
                this.setCurRotation(motion.rotation());
            }
        }
    }

    protected void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.field_70122_E = true;
                break;
            }
            case HOOKING_ENTITY: {
                if (!this.func_184218_aH()) {
                    this.findHookedEntity().ifPresent(entity -> {
                        this.stopMoving();
                        this.func_184205_a((Entity)entity, true);
                        if (this.getHookType() == HookType.PUDGE) {
                            entity.func_184210_p();
                        }
                    });
                }
                this.field_70122_E = true;
                break;
            }
            default: {
                if (this.func_184218_aH()) {
                    this.func_184210_p();
                }
                this.field_70122_E = false;
                double motionFactor = 0.99f;
                if (this.func_70090_H()) {
                    Vect3d bubblePos = this.getCurPosition().subtract(this.getCurMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        GameWorld.spawnParticle((World)this.field_70170_p, (Vect3d)bubblePos, (Vect3d)this.getCurMotion(), (IParticleData)ParticleTypes.field_197612_e);
                    }
                    motionFactor = 0.8f;
                }
                this.func_213317_d(this.func_213322_ci().func_186678_a(motionFactor).func_72441_c(0.0, (double)-0.005f, 0.0));
            }
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vect3d vec = Vect3d.from((double)x, (double)y, (double)z).normalize().scale((double)velocity);
        Rotation rotation = new Rotation(vec.pitch(), vec.yaw());
        this.setMotion(vec);
        this.setAllRotations(rotation);
    }

    public void func_70106_y() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof PlayerEntity) {
            PlayerInventory inventory = ((PlayerEntity)shooter).field_71071_by;
            Launcher.findAttachedLauncher(inventory, this).ifPresent(stack -> Launcher.unattach(stack));
        }
        super.func_70106_y();
    }

    public float getTensionForce() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.TENSION_FORCE.key)).floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < (double)(RENDER_DISTANCE * RENDER_DISTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        LivingEntity shooter = this.getShooter().orElse(null);
        return shooter != null ? this.getBB().func_111270_a(HookShot.getBB((Entity)shooter)) : AABB.ZERO;
    }

    protected void doTarzanJump() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof ServerPlayerEntity) {
            float strength = this.getLauncher().getTarzanJumpStrength();
            new TarzanJumpMsg(strength).sendTo((ServerPlayerEntity)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    static enum BlockAction {
        BOUNCE,
        BREAK,
        HOOK,
        PASS;

    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    public static enum WatchedFloat {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;

        public final DataParameter<Float> key = EntityDataManager.func_187226_a(HookShot.class, (IDataSerializer)DataSerializers.field_187193_c);
    }

    public static enum WatchedInt {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        PREV_STATE,
        SHOOTER_ID,
        STATE,
        LAUNCHER_HAND;

        public final DataParameter<Integer> key = EntityDataManager.func_187226_a(HookShot.class, (IDataSerializer)DataSerializers.field_187192_b);
    }

    public static enum WatchedBool implements IForgeEnum
    {
        LAUNCHING,
        PULLING,
        LOOSENING,
        UNHOOKING,
        JUMPING;

        public final DataParameter<Boolean> key = EntityDataManager.func_187226_a(HookShot.class, (IDataSerializer)DataSerializers.field_187198_h);
    }
}

