/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Launcher
extends DamageableItem {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final FloatBounds REELING_SPEED_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(4.0f));
    public static final FloatBounds TARZAN_JUMP_STRENGTH_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(3.0f));
    public static final FloatBounds WEIGHT_FACTOR_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(1000.0f));
    public static final int DAMAGE_ON_SHOT = 1;
    public final HookType hookType;
    protected float reelingSpeed;
    protected float tarzanJumpStrength;
    protected float shooterWeightFactor;
    protected final Map<Hand, Cooldowns> cooldownsByHand = new EnumMap<Hand, Cooldowns>(Hand.class);
    protected final Map<Hand, WatchedStates> watchedStatesByHand = new EnumMap<Hand, WatchedStates>(Hand.class);

    public Launcher(ForgeMod mod, UnitConfig config, HookType hookType, int durability, float reelingSpeed, float tarzanJumpStrength, float shooterWeightFactor) {
        super(mod, config, hookType.getName() + "_launcher", new Item.Properties().func_200916_a(ItemGroup.field_78040_i), durability, UnitId.from((String)"string"));
        String category = this.getUnitCategory();
        this.hookType = hookType;
        this.reelingSpeed = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"reelingSpeed", (float)reelingSpeed, (FloatBounds)REELING_SPEED_BOUNDS, (String)"Defines how fast the launcher reels in the rope.");
        this.tarzanJumpStrength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"tarzanJumpStrength", (float)tarzanJumpStrength, (FloatBounds)TARZAN_JUMP_STRENGTH_BOUNDS, (String)"Defines how far you will be thrown when performing Tarzan Jump");
        this.shooterWeightFactor = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"shooterWeightFactor", (float)shooterWeightFactor, (FloatBounds)WEIGHT_FACTOR_BOUNDS, (String)"Allows to adjust your weight advantage/disadvantage over the hooked entity.");
    }

    public float getReelingSpeed() {
        return this.reelingSpeed;
    }

    public float getTarzanJumpStrength() {
        return this.tarzanJumpStrength;
    }

    public float getShooterWeightFactor() {
        return this.shooterWeightFactor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        GameSettings gs = GameKeys.getGameSettings();
        Tooltip tip = Tooltip.of((ForgeMod)AdHooks.getInstance(), (String)"launcher", lines);
        TextFormatting formText = TextFormatting.RESET;
        if (Screen.func_231173_s_()) {
            tip.add(TextFormatting.RED, "hook_strength", (Object)Float.valueOf(this.hookType.hook.strength));
            tip.add(TextFormatting.AQUA, "rope_elasticity", (Object)Float.valueOf(this.hookType.rope.elasticity));
            tip.add(TextFormatting.YELLOW, "rope_max_length", (Object)this.hookType.rope.maxLength);
            tip.add(TextFormatting.GREEN, "reeling_speed", (Object)Float.valueOf(this.reelingSpeed));
            tip.add(TextFormatting.GOLD, "tarzan_jump_strength", (Object)Float.valueOf(this.tarzanJumpStrength));
        } else if (Screen.func_231172_r_()) {
            for (Hand hand : Hand.values()) {
                String textUnhooking = ControlBindings.getTextFor(hand, HookShot.WatchedBool.UNHOOKING);
                String textLoosening = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LOOSENING);
                String handName = hand.name().toLowerCase(Locale.ROOT);
                tip.add(handName, new Object[]{TextFormatting.UNDERLINE});
                String textLaunching = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LAUNCHING);
                tip.add("launch", new Object[]{TextFormatting.RED, formText, textLaunching});
                String textPulling = ControlBindings.getTextFor(hand, HookShot.WatchedBool.PULLING);
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.UNHOOKING)) {
                    tip.add("reel_unhook_same", new Object[]{TextFormatting.GREEN, formText, textPulling, textUnhooking});
                } else {
                    tip.add("reel_unhook", new Object[]{TextFormatting.GREEN, formText, textUnhooking});
                }
                tip.add("pull", new Object[]{TextFormatting.YELLOW, formText, textPulling});
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.LOOSENING)) {
                    tip.add("loosen_same", new Object[]{TextFormatting.AQUA, formText, textPulling, textLoosening});
                } else {
                    tip.add("loosen", new Object[]{TextFormatting.AQUA, formText, textLoosening});
                }
                tip.add("tarzan_jump", new Object[]{TextFormatting.GOLD, formText, textUnhooking, ControlBindings.getTextFor(hand, HookShot.WatchedBool.JUMPING)});
            }
            tip.add("other", new Object[]{TextFormatting.UNDERLINE});
            tip.add("swing", new Object[]{TextFormatting.BLUE, formText, Args.joinDelim((String)"-", (Object[])new Object[]{gs.field_74370_x.func_238171_j_().getString(), gs.field_74366_z.func_238171_j_().getString(), gs.field_74368_y.func_238171_j_().getString(), gs.field_74351_w.func_238171_j_().getString()})});
            tip.add("release", new Object[]{TextFormatting.LIGHT_PURPLE, formText, gs.field_74312_F.func_238171_j_().getString(), gs.field_228046_af_.func_238171_j_().getString()});
        } else {
            tip.add("more_info", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE});
            tip.add("controls", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE});
        }
    }

    public static boolean isShotAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isShotAttached(launcher) && Launcher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack.func_77973_b() instanceof Launcher;
    }

    public static Optional<HookShot> findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (Launcher.isShotAttached(launcher) && (entity = world.func_73045_a(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return Optional.of((HookShot)entity);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> findAttachedLauncher(PlayerInventory inventory, HookShot hookShot) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            CompoundNBT tag = launcher.func_196082_o();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && launcher.func_77942_o()) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        stack.func_196082_o();
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack launcher, PlayerEntity player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void makeShot(ItemStack launcher, LivingEntity shooter) {
        World world = shooter.func_130014_f_();
        if (this.isServerSide((IWorldReader)world) && this.hookType != HookType.PROTOTYPE && Launcher.notBroken((ItemStack)launcher)) {
            HookShot hookShot = new HookShot(world, shooter, this.hookType);
            world.func_217376_c((Entity)hookShot);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (boolean)false, (LivingEntity)shooter, null);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND || !Launcher.stackHasLauncher(player.func_184592_cb())) {
            player.func_184598_c(hand);
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void processPressedKeysBy(ClientPlayerEntity player, Hand activeHand) {
        RayTraceResult result;
        if (!GameKeys.affectPlayer()) {
            return;
        }
        Cooldowns cooldowns = this.cooldownsByHand.computeIfAbsent(activeHand, Cooldowns::new);
        WatchedStates states = this.watchedStatesByHand.computeIfAbsent(activeHand, WatchedStates::new);
        boolean launchingKeyDown = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LAUNCHING);
        boolean pullingKeyDown = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.PULLING);
        boolean looseningKeyDown = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LOOSENING);
        boolean unhookingKeyDown = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.UNHOOKING);
        boolean shotAttached = Launcher.isShotAttached(player.func_184586_b(activeHand));
        if (shotAttached) {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.UNHOOKING, b -> unhookingKeyDown);
        } else {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.LAUNCHING, b -> launchingKeyDown);
        }
        if (launchingKeyDown && !shotAttached && ((result = Minecraft.func_71410_x().field_71476_x) == null || result.func_216346_c() == RayTraceResult.Type.MISS) && cooldowns.expired(HookShot.WatchedBool.LAUNCHING)) {
            new MakeShotMsg(activeHand).sendToServer();
            cooldowns.reset(HookShot.WatchedBool.UNHOOKING);
            states.bools.clear();
        }
        states.updateAndSync(HookShot.WatchedBool.PULLING, pulling -> pullingKeyDown && !looseningKeyDown);
        states.updateAndSync(HookShot.WatchedBool.LOOSENING, loosening -> ControlBindings.areSameForBothHands(loosening) ? looseningKeyDown && pullingKeyDown : looseningKeyDown && !pullingKeyDown);
        states.updateAndSync(HookShot.WatchedBool.UNHOOKING, unhooking -> shotAttached && cooldowns.expired((HookShot.WatchedBool)((Object)unhooking)) && (ControlBindings.areSameForBothHands(unhooking) ? unhookingKeyDown && pullingKeyDown : unhookingKeyDown));
        states.updateAndSync(HookShot.WatchedBool.JUMPING, jumping -> ControlBindings.isKeyDownFor(activeHand, jumping));
        if (states.get(HookShot.WatchedBool.UNHOOKING)) {
            cooldowns.reset(HookShot.WatchedBool.LAUNCHING);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide((IWorldReader)world) && entity instanceof ClientPlayerEntity) {
            ClientPlayerEntity player = (ClientPlayerEntity)entity;
            Optional<Object> activeHand = Optional.empty();
            for (Hand hand : Hand.values()) {
                if (stack != player.func_184586_b(hand)) continue;
                activeHand = Optional.of(hand);
            }
            if (activeHand.isPresent()) {
                this.processPressedKeysBy(player, (Hand)activeHand.get());
            }
        }
    }

    public static class WatchedStates {
        protected final Hand hand;
        protected final Map<HookShot.WatchedBool, Boolean> bools;

        public WatchedStates(Hand hand) {
            this.hand = hand;
            this.bools = new EnumMap<HookShot.WatchedBool, Boolean>(HookShot.WatchedBool.class);
        }

        public boolean get(HookShot.WatchedBool action) {
            return this.bools.computeIfAbsent(action, a -> false);
        }

        public void updateAndSync(HookShot.WatchedBool action, Function<HookShot.WatchedBool, Boolean> newValueFunc) {
            boolean newValue;
            boolean oldValue = this.get(action);
            if (oldValue != (newValue = newValueFunc.apply(action).booleanValue())) {
                this.bools.put(action, newValue);
                WatchedBoolMsg.sendToServer(this.hand, action, newValue);
            }
        }
    }

    public static class Cooldowns {
        static final int TICKS_DEFAULT = 10;
        protected final Hand hand;
        protected final Map<HookShot.WatchedBool, Integer> cooldowns;

        public Cooldowns(Hand hand) {
            this.hand = hand;
            this.cooldowns = new EnumMap<HookShot.WatchedBool, Integer>(HookShot.WatchedBool.class);
        }

        public void tick(HookShot.WatchedBool key) {
            this.cooldowns.computeIfPresent(key, (k, ticks) -> ticks > 0 ? ticks - 1 : 0);
        }

        public boolean expired(HookShot.WatchedBool key) {
            return Optional.ofNullable(this.cooldowns.get((Object)key)).map(ticks -> ticks == 0).orElse(true);
        }

        public void set(HookShot.WatchedBool key, int ticks) {
            this.cooldowns.put(key, ticks > 0 ? ticks : 0);
        }

        public void reset(HookShot.WatchedBool key) {
            this.set(key, 10);
        }

        public void zero(HookShot.WatchedBool key) {
            this.set(key, 0);
        }

        public void tickIfTrueElseZero(HookShot.WatchedBool key, Predicate<HookShot.WatchedBool> predicate) {
            if (predicate.test(key)) {
                this.tick(key);
            } else {
                this.zero(key);
            }
        }
    }
}

