/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adhooks.motion.ClientPlayerTarget;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MotionController {
    public static float mainFactor = 1.3333334f;
    public static float motionDamping = 0.5f * mainFactor;
    protected static final Map<Entity, EntityTarget<?>> SERVER_TARGETS = new ConcurrentHashMap();
    protected static final Map<Entity, EntityTarget<?>> CLIENT_TARGETS = new ConcurrentHashMap();

    public static Optional<EntityTarget<?>> getTarget(Entity entity) {
        if (ForgeEntity.isClientSide((Entity)entity)) {
            return MotionController.getClientTarget(entity);
        }
        if (ForgeEntity.isServerSide((Entity)entity) && !(entity instanceof PlayerEntity)) {
            EntityTarget<Object> target = SERVER_TARGETS.get(entity);
            if (target == null) {
                target = new EntityTarget<Entity>(entity, motionDamping);
                SERVER_TARGETS.put(entity, target);
            }
            return Optional.of(target);
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    static Optional<EntityTarget<?>> getClientTarget(Entity entity) {
        if (entity instanceof ClientPlayerEntity) {
            ClientPlayerEntity player = (ClientPlayerEntity)entity;
            ClientPlayerTarget target = CLIENT_TARGETS.get(player);
            if (target == null) {
                target = new ClientPlayerTarget((AbstractClientPlayerEntity)player, (double)motionDamping);
                CLIENT_TARGETS.put((Entity)player, target);
            }
            return Optional.of(target);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionController.applyTo(SERVER_TARGETS.values());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionController.applyTo(CLIENT_TARGETS.values());
        }
    }

    protected static <T extends EntityTarget<?>> void applyTo(Collection<T> targets) {
        Iterator<T> iterator = targets.iterator();
        while (iterator.hasNext()) {
            EntityTarget target = (EntityTarget)iterator.next();
            if (target.exists()) {
                target.applyMotions();
                continue;
            }
            iterator.remove();
        }
    }
}

