/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft;

import com.github.platymemo.alaskanativecraft.client.renderer.entity.DogsledEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.HarpoonEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.MooseEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.PtarmiganEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.SealEntityRenderer;
import com.github.platymemo.alaskanativecraft.entity.AlaskaNativeEntities;
import com.github.platymemo.alaskanativecraft.entity.HarpoonEntity;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class AlaskaNativeCraftClient
implements ClientModInitializer {
    public void onInitializeClient() {
        AlaskaNativeCraftClient.registerEntityRenderers();
        this.registerHarpoonPacket();
    }

    private void registerHarpoonPacket() {
        ClientSidePacketRegistry.INSTANCE.register(HarpoonEntity.SPAWN_PACKET, (context, packet) -> {
            class_1299 type = (class_1299)class_2378.field_11145.method_10200(packet.method_10816());
            UUID entityUUID = packet.method_10790();
            int entityID = packet.method_10816();
            double x = packet.readDouble();
            double y = packet.readDouble();
            double z = packet.readDouble();
            float pitch = (float)(packet.readByte() * 360) / 256.0f;
            float yaw = (float)(packet.readByte() * 360) / 256.0f;
            class_638 world = class_310.method_1551().field_1687;
            class_1297 entity = type.method_5883((class_1937)world);
            context.getTaskQueue().execute(() -> {
                if (entity != null) {
                    entity.method_5814(x, y, z);
                    entity.method_18003(x, y, z);
                    entity.field_5965 = pitch;
                    entity.field_6031 = yaw;
                    entity.method_5838(entityID);
                    entity.method_5826(entityUUID);
                    assert (world != null);
                    world.method_2942(entityID, entity);
                }
            });
        });
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.WOODEN_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.STONE_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.IRON_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.GOLDEN_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.DIAMOND_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.NETHERITE_HARPOON, (dispatcher, context) -> new HarpoonEntityRenderer(dispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.HARP_SEAL, (entityRenderDispatcher, context) -> new SealEntityRenderer(entityRenderDispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.PTARMIGAN, (entityRenderDispatcher, context) -> new PtarmiganEntityRenderer(entityRenderDispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.MOOSE, (entityRenderDispatcher, context) -> new MooseEntityRenderer(entityRenderDispatcher));
        EntityRendererRegistry.INSTANCE.register(AlaskaNativeEntities.DOGSLED, (entityRenderDispatcher, context) -> new DogsledEntityRenderer(entityRenderDispatcher));
    }
}

