/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.client.model.entity;

import com.github.platymemo.alaskanativecraft.entity.PtarmiganEntity;
import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class PtarmiganEntityModel
extends class_4595<PtarmiganEntity> {
    private final class_630 torso;
    private final class_630 tail;
    private final class_630 leftWing;
    private final class_630 rightWing;
    private final class_630 head;
    private final class_630 beak;
    private final class_630 leftLeg;
    private final class_630 rightLeg;

    public PtarmiganEntityModel() {
        this.field_17138 = 32;
        this.field_17139 = 32;
        this.torso = new class_630((class_3879)this, 0, 7);
        this.torso.method_2844(-2.5f, 0.0f, -2.5f, 5.0f, 6.0f, 5.0f);
        this.torso.method_2851(0.0f, 16.5f, -3.0f);
        this.tail = new class_630((class_3879)this, 24, 0);
        this.tail.method_2844(-1.5f, -1.0f, 0.0f, 3.0f, 4.0f, 1.0f);
        this.tail.method_2851(0.0f, 21.07f, 1.16f);
        this.leftWing = new class_630((class_3879)this, 2, 22);
        this.leftWing.method_2844(-2.0f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.leftWing.method_2851(2.5f, 16.94f, -2.76f);
        this.rightWing = new class_630((class_3879)this, 2, 22);
        this.rightWing.method_2844(1.0f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.rightWing.method_2851(-2.5f, 16.94f, -2.76f);
        this.head = new class_630((class_3879)this, 0, 0);
        this.head.method_2844(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        this.head.method_2851(0.0f, 15.69f, -2.76f);
        this.beak = new class_630((class_3879)this, 9, 0);
        this.beak.method_2844(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.beak.method_2851(0.0f, -0.5f, -1.5f);
        this.head.method_2845(this.beak);
        this.leftLeg = new class_630((class_3879)this, 14, 24);
        this.leftLeg.method_2844(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.leftLeg.method_2851(1.0f, 22.0f, -1.05f);
        this.rightLeg = new class_630((class_3879)this, 14, 24);
        this.rightLeg.method_2844(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.rightLeg.method_2851(-1.0f, 22.0f, -1.05f);
    }

    public Iterable<class_630> method_22960() {
        return ImmutableList.of((Object)this.torso, (Object)this.leftWing, (Object)this.rightWing, (Object)this.tail, (Object)this.head, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void setAngles(PtarmiganEntity ptarmiganEntity, float f, float g, float h, float i, float j) {
        this.setAngles(PtarmiganEntityModel.getPose(ptarmiganEntity), ptarmiganEntity.field_6012, f, g, h, i, j);
    }

    public void animateModel(PtarmiganEntity ptarmiganEntity, float f, float g, float h) {
        this.animateModel(PtarmiganEntityModel.getPose(ptarmiganEntity));
    }

    public void poseOnShoulder(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float limbAngle, float limbDistance, float headYaw, float headPitch, int danceAngle) {
        this.animateModel(Pose.ON_SHOULDER);
        this.setAngles(Pose.ON_SHOULDER, danceAngle, limbAngle, limbDistance, 0.0f, headYaw, headPitch);
        this.method_22960().forEach(modelPart -> modelPart.method_22698(matrices, vertexConsumer, light, overlay));
    }

    private void setAngles(Pose pose, int danceAngle, float limbAngle, float limbDistance, float age, float headYaw, float headPitch) {
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.head.field_3674 = 0.0f;
        this.head.field_3657 = 0.0f;
        this.torso.field_3657 = 0.0f;
        this.tail.field_3657 = 0.0f;
        this.rightWing.field_3657 = -1.5f;
        this.leftWing.field_3657 = 1.5f;
        switch (pose) {
            case SITTING: {
                break;
            }
            case PARTY: {
                float cosDanceAngle = class_3532.method_15362((float)danceAngle);
                float sinDanceAngle = class_3532.method_15374((float)danceAngle);
                this.head.field_3657 = cosDanceAngle;
                this.head.field_3656 = 15.69f + sinDanceAngle;
                this.head.field_3654 = 0.0f;
                this.head.field_3675 = 0.0f;
                this.head.field_3674 = class_3532.method_15374((float)danceAngle) * 0.4f;
                this.torso.field_3657 = cosDanceAngle;
                this.torso.field_3656 = 16.5f + sinDanceAngle;
                this.leftWing.field_3674 = -0.0873f - age;
                this.leftWing.field_3657 = 1.5f + cosDanceAngle;
                this.leftWing.field_3656 = 16.94f + sinDanceAngle;
                this.rightWing.field_3674 = 0.0873f + age;
                this.rightWing.field_3657 = -1.5f + cosDanceAngle;
                this.rightWing.field_3656 = 16.94f + sinDanceAngle;
                this.tail.field_3657 = cosDanceAngle;
                this.tail.field_3656 = 21.07f + sinDanceAngle;
                break;
            }
            case STANDING: {
                class_630 leg = this.leftLeg;
                leg.field_3654 += class_3532.method_15362((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
                leg = this.rightLeg;
                leg.field_3654 += class_3532.method_15362((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
            }
            default: {
                float thirdOfAge = age * 0.3f;
                this.head.field_3656 = 15.69f + thirdOfAge;
                this.tail.field_3654 = 1.015f + class_3532.method_15362((float)(limbAngle * 0.6662f)) * 0.3f * limbDistance;
                this.tail.field_3656 = 21.07f + thirdOfAge;
                this.torso.field_3656 = 16.5f + thirdOfAge;
                this.leftWing.field_3674 = -0.0873f - age;
                this.leftWing.field_3656 = 16.94f + thirdOfAge;
                this.rightWing.field_3674 = 0.0873f + age;
                this.rightWing.field_3656 = 16.94f + thirdOfAge;
                this.leftLeg.field_3656 = 22.0f + thirdOfAge;
                this.rightLeg.field_3656 = 22.0f + thirdOfAge;
            }
        }
    }

    private void animateModel(Pose pose) {
        this.torso.field_3654 = 0.4937f;
        this.leftWing.field_3654 = -0.6981f;
        this.leftWing.field_3675 = (float)(-Math.PI);
        this.rightWing.field_3654 = -0.6981f;
        this.rightWing.field_3675 = (float)(-Math.PI);
        this.leftLeg.field_3654 = -0.0299f;
        this.rightLeg.field_3654 = -0.0299f;
        this.leftLeg.field_3656 = 22.0f;
        this.rightLeg.field_3656 = 22.0f;
        this.leftLeg.field_3674 = 0.0f;
        this.rightLeg.field_3674 = 0.0f;
        switch (pose) {
            case SITTING: {
                float f = 1.9f;
                this.head.field_3656 = 17.59f;
                this.tail.field_3654 = 1.5388988f;
                this.tail.field_3656 = 22.97f;
                this.torso.field_3656 = 18.4f;
                this.leftWing.field_3674 = -0.0873f;
                this.leftWing.field_3656 = 18.84f;
                this.rightWing.field_3674 = 0.0873f;
                this.rightWing.field_3656 = 18.84f;
                this.leftLeg.field_3656 += 1.0f;
                this.rightLeg.field_3656 += 1.0f;
                this.leftLeg.field_3654 += 1.0f;
                this.rightLeg.field_3654 += 1.0f;
                break;
            }
            case PARTY: {
                this.leftLeg.field_3674 = -0.34906584f;
                this.rightLeg.field_3674 = 0.34906584f;
            }
            default: {
                break;
            }
            case FLYING: {
                this.leftLeg.field_3654 += 0.6981317f;
                this.rightLeg.field_3654 += 0.6981317f;
            }
        }
    }

    private static Pose getPose(PtarmiganEntity ptarmigan) {
        if (ptarmigan.method_6582()) {
            return Pose.PARTY;
        }
        if (ptarmigan.method_6172()) {
            return Pose.SITTING;
        }
        return ptarmigan.method_6581() ? Pose.FLYING : Pose.STANDING;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Pose {
        FLYING,
        STANDING,
        SITTING,
        PARTY,
        ON_SHOULDER;

    }
}

