/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.entity;

import com.github.platymemo.alaskanativecraft.entity.AlaskaNativeEntities;
import com.github.platymemo.alaskanativecraft.item.AlaskaNativeItems;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1690;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_47;
import net.minecraft.class_4838;
import net.minecraft.class_52;
import net.minecraft.class_5275;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;

public class DogsledEntity
extends class_1297
implements class_1263,
class_3908 {
    private static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(DogsledEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(DogsledEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(DogsledEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> DOGSLED_TYPE = class_2945.method_12791(DogsledEntity.class, (class_2941)class_2943.field_13327);
    private float ticksUnderwater;
    private float yawVelocity;
    private float velocityDecay;
    private int clientInterpolationSteps;
    private double x;
    private double y;
    private double z;
    private double dogsledYaw;
    private double dogsledPitch;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private double waterLevel;
    private Location location;
    private class_2371<class_1799> inventory;
    @Nullable
    private class_2960 lootTableId;
    private long lootSeed;

    public DogsledEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        this.inventory = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
        this.field_23807 = true;
    }

    public DogsledEntity(class_1937 world, double x, double y, double z) {
        this(AlaskaNativeEntities.DOGSLED, world);
        this.method_5814(x, y, z);
        this.method_18003(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_6011.method_12784(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_6011.method_12784(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DOGSLED_TYPE, (Object)Type.OAK.ordinal());
    }

    public boolean method_30949(class_1297 other) {
        return DogsledEntity.method_30959(this, other);
    }

    public static boolean method_30959(class_1297 entity, class_1297 entity2) {
        return (entity2.method_30948() || entity2.method_5810()) && !entity.method_5794(entity2);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_30633(class_2350.class_2351 axis, class_5459.class_5460 arg) {
        return class_1309.method_31079((class_243)super.method_30633(axis, arg));
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof class_1690) {
            if (entity.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entity);
            }
        } else if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public class_1792 asItem() {
        switch (this.getDogsledType()) {
            default: {
                return AlaskaNativeItems.OAK_DOGSLED;
            }
            case SPRUCE: {
                return AlaskaNativeItems.SPRUCE_DOGSLED;
            }
            case BIRCH: {
                return AlaskaNativeItems.BIRCH_DOGSLED;
            }
            case JUNGLE: {
                return AlaskaNativeItems.JUNGLE_DOGSLED;
            }
            case ACACIA: {
                return AlaskaNativeItems.ACACIA_DOGSLED;
            }
            case DARK_OAK: 
        }
        return AlaskaNativeItems.DARK_OAK_DOGSLED;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5879() {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean method_5863() {
        return !this.field_5988;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dogsledYaw = yaw;
        this.dogsledPitch = pitch;
        this.clientInterpolationSteps = 10;
    }

    public class_2350 method_5755() {
        return this.method_5735().method_10170();
    }

    public void method_5773() {
        this.location = this.checkLocation();
        this.ticksUnderwater = this.location != Location.UNDER_WATER && this.location != Location.UNDER_FLOWING_WATER ? 0.0f : (this.ticksUnderwater += 1.0f);
        if (!this.field_6002.field_9236 && this.ticksUnderwater >= 60.0f) {
            this.method_5772();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.clientInterpolation();
        if (this.method_5787()) {
            this.updateVelocity();
            if (this.field_6002.field_9236) {
                this.updateMovement();
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.method_5852();
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            boolean bl = !this.field_6002.field_9236;
            for (class_1297 entity : list) {
                if (entity.method_5626((class_1297)this)) continue;
                if (bl && this.method_5685().size() < 2 && !entity.method_5765() && entity.method_17681() < this.method_17681() && entity instanceof class_1493) {
                    entity.method_5804((class_1297)this);
                    continue;
                }
                this.method_5697(entity);
            }
        }
    }

    private void clientInterpolation() {
        if (this.method_5787()) {
            this.clientInterpolationSteps = 0;
            this.method_18003(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.clientInterpolationSteps > 0) {
            double d = this.method_23317() + (this.x - this.method_23317()) / (double)this.clientInterpolationSteps;
            double e = this.method_23318() + (this.y - this.method_23318()) / (double)this.clientInterpolationSteps;
            double f = this.method_23321() + (this.z - this.method_23321()) / (double)this.clientInterpolationSteps;
            double g = class_3532.method_15338((double)(this.dogsledYaw - (double)this.field_6031));
            this.field_6031 = (float)((double)this.field_6031 + g / (double)this.clientInterpolationSteps);
            this.field_5965 = (float)((double)this.field_5965 + (this.dogsledPitch - (double)this.field_5965) / (double)this.clientInterpolationSteps);
            --this.clientInterpolationSteps;
            this.method_5814(d, e, f);
            this.method_5710(this.field_6031, this.field_5965);
        }
    }

    private Location checkLocation() {
        Location location = this.getUnderWaterLocation();
        if (location != null) {
            this.waterLevel = this.method_5829().field_1325;
            return location;
        }
        float f = this.getBlockSlipperiness();
        if (f > 0.0f) {
            return Location.ON_LAND;
        }
        return Location.IN_AIR;
    }

    public float getBlockSlipperiness() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.field_6002.method_8320((class_2338)mutable);
                    class_2680 topBlock = this.field_6002.method_8320(mutable.method_10084());
                    if (blockState.method_27852(class_2246.field_10491) || topBlock.method_27852(class_2246.field_10477)) {
                        f += 0.95f;
                        ++o;
                        continue;
                    }
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.field_6002, (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    @Nullable
    private Location getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.field_6002.method_8316((class_2338)mutable);
                    if (!fluidState.method_15767((class_3494)class_3486.field_15517)) continue;
                    float f = (float)p + fluidState.method_15763((class_1922)this.field_6002, (class_2338)mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= box.field_1322 < (double)f;
                    if (!(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.field_6002, (class_2338)mutable)))) continue;
                    if (!fluidState.method_15771()) {
                        return Location.UNDER_FLOWING_WATER;
                    }
                    bl = true;
                }
            }
        }
        return bl ? Location.UNDER_WATER : null;
    }

    private void updateMovement() {
        if (this.method_5782()) {
            float f = 0.0f;
            if (this.pressingLeft) {
                this.yawVelocity -= 1.0f;
            }
            if (this.pressingRight) {
                this.yawVelocity += 1.0f;
            }
            if (this.pressingRight != this.pressingLeft && !this.pressingForward && !this.pressingBack) {
                f += 0.005f;
            }
            this.field_6031 += this.yawVelocity;
            if (this.pressingForward) {
                f += 0.04f;
            }
            if (this.pressingBack) {
                f -= 0.005f;
            }
            this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.field_6031 * ((float)Math.PI / 180))) * f), 0.0, (double)(class_3532.method_15362((float)(this.field_6031 * ((float)Math.PI / 180))) * f)));
        }
    }

    private void updateVelocity() {
        double e = this.method_5740() ? 0.0 : (double)-0.04f;
        double f = 0.0;
        if (this.location == Location.ON_LAND) {
            this.velocityDecay = this.getBlockSlipperiness();
        } else {
            if (this.location == Location.UNDER_FLOWING_WATER) {
                e = -7.0E-4;
            } else if (this.location == Location.UNDER_WATER) {
                f = 0.01f;
            }
            this.velocityDecay *= 0.95f;
        }
        if (this.method_5685().size() < 2) {
            this.velocityDecay /= 1.15f;
        }
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * (double)this.velocityDecay, vec3d.field_1351 + e, vec3d.field_1350 * (double)this.velocityDecay);
        this.yawVelocity *= this.velocityDecay / 1.5f;
        if (f > 0.0) {
            class_243 vec3d2 = this.method_18798();
            this.method_18800(vec3d2.field_1352, (vec3d2.field_1351 + f * 0.06153846016296973) * 0.75, vec3d2.field_1350);
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        double e;
        class_243 vec3d = DogsledEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)this.field_6031);
        double d = this.method_23317() + vec3d.field_1352;
        class_2338 blockPos = new class_2338(d, this.method_5829().field_1325, e = this.method_23321() + vec3d.field_1350);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.field_6002.method_22351(blockPos2)) {
            double f = (double)blockPos.method_10264() + this.field_6002.method_30347(blockPos);
            double g = (double)blockPos.method_10264() + this.field_6002.method_30347(blockPos2);
            for (class_4050 entityPose : passenger.method_24831()) {
                class_243 vec3d2 = class_5275.method_30342((class_1941)this.field_6002, (double)d, (double)f, (double)e, (class_1309)passenger, (class_4050)entityPose);
                if (vec3d2 != null) {
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
                class_243 vec3d3 = class_5275.method_30342((class_1941)this.field_6002, (double)d, (double)g, (double)e, (class_1309)passenger, (class_4050)entityPose);
                if (vec3d3 == null) continue;
                passenger.method_18380(entityPose);
                return vec3d3;
            }
        }
        return super.method_24829(passenger);
    }

    protected void copyEntityData(class_1297 entity) {
        entity.method_5636(this.field_6031);
        float f = class_3532.method_15393((float)(entity.field_6031 - this.field_6031));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.field_6031 += g - f;
        entity.method_5847(entity.field_6031);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5644(class_1297 passenger) {
        this.copyEntityData(passenger);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        if (!this.method_5765()) {
            if (onGround) {
                if (this.field_6017 > 3.0f) {
                    if (this.location != Location.ON_LAND) {
                        this.field_6017 = 0.0f;
                        return;
                    }
                    this.method_5747(this.field_6017, 1.0f);
                    if (!this.field_6002.field_9236 && !this.field_5988) {
                        this.method_5650();
                        if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                            int j;
                            for (j = 0; j < 3; ++j) {
                                this.method_5706((class_1935)this.getDogsledType().getBaseBlock());
                            }
                            for (j = 0; j < 2; ++j) {
                                this.method_5706((class_1935)class_1802.field_8600);
                            }
                            this.dropItems(null);
                        }
                    }
                }
                this.field_6017 = 0.0f;
            } else if (!this.field_6002.method_8316(this.method_24515().method_10074()).method_15767((class_3494)class_3486.field_15517) && heightDifference < 0.0) {
                this.field_6017 = (float)((double)this.field_6017 - heightDifference);
            }
        }
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    public void setDogsledType(Type type) {
        this.field_6011.method_12778(DOGSLED_TYPE, (Object)type.ordinal());
    }

    public Type getDogsledType() {
        return Type.getType((Integer)this.field_6011.method_12789(DOGSLED_TYPE));
    }

    protected boolean method_5818(class_1297 passenger) {
        int i = this.method_5685().size();
        if (this.method_5777((class_3494)class_3486.field_15517)) {
            return false;
        }
        if (i == 0) {
            return passenger instanceof class_1657 || passenger instanceof class_1493;
        }
        if (i == 1) {
            return passenger instanceof class_1657;
        }
        return false;
    }

    @Nullable
    public class_1297 method_5642() {
        List list = this.method_5685();
        return list.isEmpty() ? null : (class_1297)list.get(0);
    }

    public boolean method_5869() {
        return this.location == Location.UNDER_WATER || this.location == Location.UNDER_FLOWING_WATER;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    @Environment(value=EnvType.CLIENT)
    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
    }

    public int method_5439() {
        return 27;
    }

    public double method_5621() {
        return 0.2;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.field_6002.field_9236 && !this.field_5988) {
            boolean bl;
            if (this.method_5679(source)) {
                return false;
            }
            this.setDamageWobbleSide(-this.getDamageWobbleSide());
            this.setDamageWobbleTicks(10);
            this.method_5785();
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
            boolean bl2 = bl = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).field_7503.field_7477;
            if (bl || this.getDamageWobbleStrength() > 40.0f) {
                this.method_5772();
                if (bl && !this.method_16914()) {
                    this.method_5650();
                } else {
                    this.dropItems(source);
                }
            }
            return true;
        }
        return true;
    }

    public void method_5772() {
        for (int i = this.method_5685().size() - 1; i >= 0; --i) {
            class_1297 entity = (class_1297)this.method_5685().get(i);
            if (entity instanceof class_1493) {
                entity.field_5960 = false;
            }
            entity.method_5848();
        }
    }

    public void method_5650() {
        if (!this.field_6002.field_9236) {
            class_1264.method_5452((class_1937)this.field_6002, (class_1297)this, (class_1263)this);
        }
        this.method_5772();
        super.method_5650();
    }

    public void dropItems(class_1282 damageSource) {
        this.method_5650();
        if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
            class_1297 entity;
            if (damageSource != null) {
                class_1799 itemStack = new class_1799((class_1935)this.asItem());
                if (this.method_16914()) {
                    itemStack.method_7977(this.method_5797());
                }
                this.method_5775(itemStack);
            }
            class_1264.method_5452((class_1937)this.field_6002, (class_1297)this, (class_1263)this);
            if (damageSource != null && !this.field_6002.field_9236 && (entity = damageSource.method_5526()) != null && entity.method_5864() == class_1299.field_6097) {
                class_4838.method_24733((class_1657)((class_1657)entity), (boolean)true);
            }
        }
    }

    public void method_5865(class_1297 passenger) {
        this.updatePassengerPosition(passenger, class_1297::method_5814);
    }

    private void updatePassengerPosition(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (this.method_5626(passenger)) {
            if (passenger instanceof class_1657) {
                float g = (float)((this.field_5988 ? (double)0.01f : this.method_5621()) + passenger.method_5678());
                double x = class_3532.method_15362((float)((this.field_6031 + 90.0f) * 0.0174533f));
                double z = class_3532.method_15374((float)((this.field_6031 + 90.0f) * 0.0174533f));
                positionUpdater.accept(passenger, this.method_23317() - x, this.method_23318() + (double)g, this.method_23321() - z);
            } else if (passenger instanceof class_1493) {
                passenger.field_5960 = true;
                class_243 vec3d = new class_243(1.5, 0.0, 0.0).method_1024(-this.field_6031 * ((float)Math.PI / 180) - 1.5707964f);
                positionUpdater.accept(passenger, this.method_23317() + vec3d.field_1352, this.method_23318(), this.method_23321() + vec3d.field_1350);
                passenger.field_6031 += this.yawVelocity;
                passenger.method_5847(passenger.method_5791() + this.yawVelocity);
                this.copyEntityData(passenger);
            }
        }
    }

    public void method_5652(class_2487 tag) {
        tag.method_10582("Type", this.getDogsledType().getName());
        if (this.lootTableId != null) {
            tag.method_10582("LootTable", this.lootTableId.toString());
            if (this.lootSeed != 0L) {
                tag.method_10544("LootTableSeed", this.lootSeed);
            }
        } else {
            class_1262.method_5426((class_2487)tag, this.inventory);
        }
    }

    public void method_5749(class_2487 tag) {
        if (tag.method_10573("Type", 8)) {
            this.setDogsledType(Type.getType(tag.method_10558("Type")));
        }
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (tag.method_10573("LootTable", 8)) {
            this.lootTableId = new class_2960(tag.method_10558("LootTable"));
            this.lootSeed = tag.method_10537("LootTableSeed");
        } else {
            class_1262.method_5429((class_2487)tag, this.inventory);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            player.method_17355((class_3908)this);
            if (!player.field_6002.field_9236) {
                class_4838.method_24733((class_1657)player, (boolean)true);
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        if (this.ticksUnderwater < 60.0f) {
            if (!this.field_6002.field_9236) {
                return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        this.generateLoot(null);
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.generateLoot(null);
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        this.generateLoot(null);
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.inventory.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.generateLoot(null);
        this.inventory.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public boolean method_5758(int slot, class_1799 item) {
        if (slot >= 0 && slot < this.method_5439()) {
            this.method_5447(slot, item);
            return true;
        }
        return false;
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_5988) {
            return false;
        }
        return player.method_5858((class_1297)this) <= 64.0;
    }

    public void generateLoot(@Nullable class_1657 player) {
        if (this.lootTableId != null && this.field_6002.method_8503() != null) {
            class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(this.lootTableId);
            if (player instanceof class_3222) {
                class_174.field_24479.method_27993((class_3222)player, this.lootTableId);
            }
            this.lootTableId = null;
            class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_312(class_181.field_24424, (Object)this.method_19538()).method_304(this.lootSeed);
            if (player != null) {
                builder.method_303(player.method_7292()).method_312(class_181.field_1226, (Object)player);
            }
            lootTable.method_329((class_1263)this, builder.method_309(class_173.field_1179));
        }
    }

    public void method_5448() {
        this.generateLoot(null);
        this.inventory.clear();
    }

    public void setLootTable(class_2960 id, long lootSeed) {
        this.lootTableId = id;
        this.lootSeed = lootSeed;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        if (this.lootTableId != null && playerEntity.method_7325()) {
            return null;
        }
        this.generateLoot(playerInventory.field_7546);
        return this.getScreenHandler(i, playerInventory);
    }

    public class_1703 getScreenHandler(int syncId, class_1661 playerInventory) {
        return class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)this);
    }

    public static enum Type {
        OAK(class_2246.field_10161, "oak"),
        SPRUCE(class_2246.field_9975, "spruce"),
        BIRCH(class_2246.field_10148, "birch"),
        JUNGLE(class_2246.field_10334, "jungle"),
        ACACIA(class_2246.field_10218, "acacia"),
        DARK_OAK(class_2246.field_10075, "dark_oak");

        private final String name;
        private final class_2248 baseBlock;

        private Type(class_2248 baseBlock, String name) {
            this.name = name;
            this.baseBlock = baseBlock;
        }

        public String getName() {
            return this.name;
        }

        public class_2248 getBaseBlock() {
            return this.baseBlock;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(int i) {
            Type[] types = Type.values();
            if (i < 0 || i >= types.length) {
                i = 0;
            }
            return types[i];
        }

        public static Type getType(String string) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(string)) continue;
                return type;
            }
            return types[0];
        }
    }

    public static enum Location {
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

