/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.entity;

import com.github.platymemo.alaskanativecraft.entity.AlaskaNativeEntities;
import com.github.platymemo.alaskanativecraft.sound.AlaskaNativeSoundEvents;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1379;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1414;
import net.minecraft.class_1429;
import net.minecraft.class_1431;
import net.minecraft.class_1456;
import net.minecraft.class_1462;
import net.minecraft.class_1477;
import net.minecraft.class_15;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class SealEntity
extends class_1429 {
    public static final class_4048 ADULT = class_4048.method_18384((float)1.0f, (float)0.6f);
    public static final class_4048 PUP = class_4048.method_18384((float)0.5f, (float)0.3f);
    private static final class_2940<class_2338> TRAVEL_POS = class_2945.method_12791(SealEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> ACTIVELY_TRAVELLING = class_2945.method_12791(SealEntity.class, (class_2941)class_2943.field_13323);

    public SealEntity(class_1299<? extends SealEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new SealMoveControl(this);
        this.field_6013 = 1.0f;
    }

    private void setTravelPos(class_2338 pos) {
        this.field_6011.method_12778(TRAVEL_POS, (Object)pos);
    }

    private class_2338 getTravelPos() {
        return (class_2338)this.field_6011.method_12789(TRAVEL_POS);
    }

    private boolean isActivelyTravelling() {
        return (Boolean)this.field_6011.method_12789(ACTIVELY_TRAVELLING);
    }

    private void setActivelyTravelling(boolean travelling) {
        this.field_6011.method_12778(ACTIVELY_TRAVELLING, (Object)travelling);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TRAVEL_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(ACTIVELY_TRAVELLING, (Object)false);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("TravelPosX", this.getTravelPos().method_10263());
        tag.method_10569("TravelPosY", this.getTravelPos().method_10264());
        tag.method_10569("TravelPosZ", this.getTravelPos().method_10260());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        int l = tag.method_10550("TravelPosX");
        int m = tag.method_10550("TravelPosY");
        int n = tag.method_10550("TravelPosZ");
        this.setTravelPos(new class_2338(l, m, n));
    }

    public static class_5132.class_5133 createSealAttributes() {
        return SealEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.75).method_26868(class_5134.field_23721, 1.5);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.setTravelPos(class_2338.field_10980);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1338((class_1314)this, class_1456.class, 8.0f, 1.0, 1.5));
        this.field_6201.method_6277(0, (class_1352)new SealEscapeDangerGoal(this, 2.0));
        this.field_6201.method_6277(1, (class_1352)new MateGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new ApproachFoodHoldingPlayerGoal(this, 1.1, class_1802.field_8209.method_8389()));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1657.class, 16.0f, 1.0, 1.5));
        this.field_6201.method_6277(3, (class_1352)new WanderInWaterGoal(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new TravelGoal(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new WanderOnLandGoal(this, 1.0, 100));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1366((class_1314)this, (double)1.2f, true));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1462.class, true));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1431.class, true));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1477.class, true));
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.method_6109() ? PUP : ADULT;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    public int method_5970() {
        return 200;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (!this.method_5799() && this.field_5952) {
            return this.method_6109() ? AlaskaNativeSoundEvents.ENTITY_SEAL_AMBIENT_BABY : AlaskaNativeSoundEvents.ENTITY_SEAL_AMBIENT;
        }
        return super.method_5994();
    }

    protected void method_5734(float volume) {
        super.method_5734(volume * 1.5f);
    }

    protected class_3414 method_5737() {
        return class_3417.field_14764;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return AlaskaNativeSoundEvents.ENTITY_SEAL_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return AlaskaNativeSoundEvents.ENTITY_SEAL_HURT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        class_3414 soundEvent = this.method_6109() ? class_3417.field_14864 : class_3417.field_14549;
        this.method_5783(soundEvent, 0.15f, 1.0f);
    }

    public boolean method_6482() {
        return super.method_6482();
    }

    protected float method_5867() {
        return this.field_5994 + 0.15f;
    }

    public float method_17825() {
        return this.method_6109() ? 0.3f : 1.0f;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new SealSwimNavigation(this, world);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)AlaskaNativeEntities.HARP_SEAL.method_5883((class_1937)world);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8209;
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (world.method_8316(pos).method_15767((class_3494)class_3486.field_15517)) {
            return 15.0f;
        }
        return world.method_8320(pos).method_27852(class_2246.field_10102) ? 10.0f : world.method_22349(pos) - 0.5f;
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(0.1f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean method_5931(class_1657 player) {
        return true;
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        this.method_5643(class_1282.field_5861, Float.MAX_VALUE);
    }

    public boolean method_6121(class_1297 target) {
        boolean bl = target.method_5643(class_1282.method_5511((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (bl) {
            this.method_5723((class_1309)this, target);
        }
        return bl;
    }

    static class SealMoveControl
    extends class_1335 {
        private final SealEntity seal;

        SealMoveControl(SealEntity seal) {
            super((class_1308)seal);
            this.seal = seal;
        }

        private void updateVelocity() {
            if (this.seal.method_5799()) {
                this.seal.method_18799(this.seal.method_18798().method_1031(0.0, 0.005, 0.0));
                this.seal.method_6125(Math.max(this.seal.method_6029() / 1.5f, 0.1f));
                if (this.seal.method_6109()) {
                    this.seal.method_6125(Math.max(this.seal.method_6029() / 2.0f, 0.08f));
                }
            } else if (this.seal.field_5952) {
                this.seal.method_6125(Math.max(this.seal.method_6029() / 1.5f, 0.08f));
            }
        }

        public void method_6240() {
            this.updateVelocity();
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.seal.method_5942().method_6357()) {
                double d = this.field_6370 - this.seal.method_23317();
                double e = this.field_6369 - this.seal.method_23318();
                double f = this.field_6367 - this.seal.method_23321();
                double g = class_3532.method_15368((double)(d * d + e * e + f * f));
                e /= g;
                float h = (float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.seal.field_6283 = this.seal.field_6031 = this.method_6238(this.seal.field_6031, h, 90.0f);
                this.seal.field_6241 = this.seal.field_6031;
                float i = (float)(this.field_6372 * this.seal.method_26825(class_5134.field_23719));
                this.seal.method_6125(class_3532.method_16439((float)0.125f, (float)this.seal.method_6029(), (float)i));
                this.seal.method_18799(this.seal.method_18798().method_1031(0.0, (double)this.seal.method_6029() * e * 0.1, 0.0));
            } else {
                this.seal.method_6125(0.0f);
            }
        }
    }

    static class SealEscapeDangerGoal
    extends class_1374 {
        SealEscapeDangerGoal(SealEntity seal, double speed) {
            super((class_1314)seal, speed);
        }

        public boolean method_6264() {
            if (this.field_6549.method_6065() == null && !this.field_6549.method_5809()) {
                return false;
            }
            class_2338 blockPos = this.method_6300((class_1922)this.field_6549.field_6002, (class_1297)this.field_6549, 16, 4);
            if (blockPos != null) {
                this.field_6547 = blockPos.method_10263();
                this.field_6546 = blockPos.method_10264();
                this.field_6550 = blockPos.method_10260();
                return true;
            }
            return this.method_6301();
        }
    }

    static class MateGoal
    extends class_1341 {
        private final SealEntity seal;

        MateGoal(SealEntity seal, double speed) {
            super((class_1429)seal, speed);
            this.seal = seal;
        }

        protected void method_6249() {
            class_3222 serverPlayerEntity = this.field_6404.method_6478();
            if (serverPlayerEntity == null && this.field_6406.method_6478() != null) {
                serverPlayerEntity = this.field_6406.method_6478();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(serverPlayerEntity, this.field_6404, this.field_6406, null);
            }
            this.field_6404.method_6477();
            this.field_6406.method_6477();
            Random random = this.field_6404.method_6051();
            if (this.field_6405.method_8450().method_8355(class_1928.field_19391)) {
                this.field_6405.method_8649((class_1297)new class_1303(this.field_6405, this.field_6404.method_23317(), this.field_6404.method_23318(), this.field_6404.method_23321(), random.nextInt(7) + 1));
            }
        }
    }

    static class ApproachFoodHoldingPlayerGoal
    extends class_1352 {
        private static final class_4051 CLOSE_ENTITY_PREDICATE = new class_4051().method_18418(10.0).method_18421().method_18417();
        private final SealEntity seal;
        private final double speed;
        private class_1657 targetPlayer;
        private int cooldown;
        private final Set<class_1792> attractiveItems;

        ApproachFoodHoldingPlayerGoal(SealEntity seal, double speed, class_1792 attractiveItem) {
            this.seal = seal;
            this.speed = speed;
            this.attractiveItems = Sets.newHashSet((Object[])new class_1792[]{attractiveItem});
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetPlayer = this.seal.field_6002.method_18462(CLOSE_ENTITY_PREDICATE, (class_1309)this.seal);
            if (this.targetPlayer == null) {
                return false;
            }
            return this.isAttractive(this.targetPlayer.method_6047()) || this.isAttractive(this.targetPlayer.method_6079());
        }

        private boolean isAttractive(class_1799 stack) {
            return this.attractiveItems.contains(stack.method_7909());
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6270() {
            this.targetPlayer = null;
            this.seal.method_5942().method_6340();
            this.cooldown = 100;
        }

        public void method_6268() {
            this.seal.method_5988().method_6226((class_1297)this.targetPlayer, (float)(this.seal.method_5986() + 20), (float)this.seal.method_5978());
            if (this.seal.method_5858((class_1297)this.targetPlayer) < 6.25) {
                this.seal.method_5942().method_6340();
            } else {
                this.seal.method_5942().method_6335((class_1297)this.targetPlayer, this.speed);
            }
        }
    }

    static class WanderInWaterGoal
    extends class_1367 {
        private final SealEntity seal;

        private WanderInWaterGoal(SealEntity seal, double speed) {
            super((class_1314)seal, seal.method_6109() ? 2.0 : speed, 24);
            this.seal = seal;
            this.field_6515 = -1;
        }

        public boolean method_6266() {
            return !this.seal.method_5799() && this.field_6517 <= 1200 && this.method_6296((class_4538)this.seal.field_6002, this.field_6512);
        }

        public boolean method_6264() {
            if (this.seal.method_6109() && !this.seal.method_5799()) {
                return super.method_6264();
            }
            return !this.seal.method_5799() && super.method_6264();
        }

        public boolean method_6294() {
            return this.field_6517 % 160 == 0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return world.method_8320(pos).method_27852(class_2246.field_10382);
        }
    }

    static class TravelGoal
    extends class_1352 {
        private final SealEntity seal;
        private final double speed;
        private boolean noPath;

        TravelGoal(SealEntity seal, double speed) {
            this.seal = seal;
            this.speed = speed;
        }

        public boolean method_6264() {
            return this.seal.method_5799();
        }

        public void method_6269() {
            boolean i = true;
            boolean j = true;
            Random random = this.seal.field_5974;
            int k = random.nextInt(1025) - 512;
            int l = random.nextInt(9) - 4;
            int m = random.nextInt(1025) - 512;
            if ((double)l + this.seal.method_23318() > (double)(this.seal.field_6002.method_8615() - 1)) {
                l = 0;
            }
            class_2338 blockPos = new class_2338((double)k + this.seal.method_23317(), (double)l + this.seal.method_23318(), (double)m + this.seal.method_23321());
            this.seal.setTravelPos(blockPos);
            this.seal.setActivelyTravelling(true);
            this.noPath = false;
        }

        public void method_6268() {
            if (this.seal.method_5942().method_6357()) {
                class_243 vec3d = class_243.method_24955((class_2382)this.seal.getTravelPos());
                class_243 vec3d2 = class_1414.method_6377((class_1314)this.seal, (int)16, (int)3, (class_243)vec3d, (double)0.3141592741012573);
                if (vec3d2 == null) {
                    vec3d2 = class_1414.method_23735((class_1314)this.seal, (int)8, (int)7, (class_243)vec3d);
                }
                if (vec3d2 != null) {
                    int i = class_3532.method_15357((double)vec3d2.field_1352);
                    int j = class_3532.method_15357((double)vec3d2.field_1350);
                    boolean k = true;
                    if (!this.seal.field_6002.method_22341(i - 34, 0, j - 34, i + 34, 0, j + 34)) {
                        vec3d2 = null;
                    }
                }
                if (vec3d2 == null) {
                    this.noPath = true;
                    return;
                }
                this.seal.method_5942().method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, this.speed);
            }
        }

        public boolean method_6266() {
            return !this.seal.method_5942().method_6357() && !this.noPath && !this.seal.method_6479();
        }

        public void method_6270() {
            this.seal.setActivelyTravelling(false);
            super.method_6270();
        }
    }

    static class WanderOnLandGoal
    extends class_1379 {
        private final SealEntity seal;

        private WanderOnLandGoal(SealEntity seal, double speed, int chance) {
            super((class_1314)seal, speed, chance);
            this.seal = seal;
        }

        public boolean method_6264() {
            return !this.field_6566.method_5799() && super.method_6264();
        }
    }

    static class SealSwimNavigation
    extends class_1412 {
        SealSwimNavigation(SealEntity owner, class_1937 world) {
            super((class_1308)owner, world);
        }

        protected boolean method_6358() {
            return true;
        }

        protected class_13 method_6336(int range) {
            this.field_6678 = new class_15();
            return new class_13(this.field_6678, range);
        }

        public boolean method_6333(class_2338 pos) {
            SealEntity sealEntity;
            if (this.field_6684 instanceof SealEntity && (sealEntity = (SealEntity)this.field_6684).isActivelyTravelling()) {
                return this.field_6677.method_8320(pos).method_27852(class_2246.field_10382);
            }
            return !this.field_6677.method_8320(pos.method_10074()).method_26215();
        }
    }
}

