/*
 * Decompiled with CFR 0.152.
 */
package lucie.alchemist.item;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucie.alchemist.Alchemist;
import lucie.alchemist.enchantment.AlchemicalEnchantments;
import lucie.alchemist.function.FunctionMixture;
import lucie.alchemist.function.FunctionTools;
import lucie.alchemist.item.AlchemicalItems;
import lucie.alchemist.utility.UtilityCompound;
import lucie.alchemist.utility.UtilityGetter;
import lucie.alchemist.utility.UtilityTooltip;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMixture
extends Item {
    private FunctionMixture.Mixture mixture;

    public ItemMixture(String name) {
        super(new Item.Properties().func_208103_a(Alchemist.RARITY).func_200917_a(1));
        this.setRegistryName(name + "_ingredients");
        this.mixture = (FunctionMixture.Mixture)new Gson().fromJson(new JsonParser().parse((Reader)new InputStreamReader(Objects.requireNonNull(FunctionMixture.Mixture.class.getClassLoader().getResourceAsStream("data/alchemist/mixtures/" + name + ".json")), StandardCharsets.UTF_8)).toString(), FunctionMixture.Mixture.class);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        String type = ItemMixture.compoundCheck(stack) ? "item.alchemist.mixture" : "item.alchemist.ingredient";
        return new StringTextComponent(I18n.func_135052_a((String)type, (Object[])new Object[]{I18n.func_135052_a((String)("effect." + this.mixture.getResourceLocation().func_110624_b() + "." + this.mixture.getResourceLocation().func_110623_a()), (Object[])new Object[0])}));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        UtilityTooltip utility = new UtilityTooltip(tooltip);
        UtilityCompound.Pouch pouch = UtilityCompound.Pouch.convert(stack);
        if (pouch.doesExist()) {
            String campfire = pouch.isSoulfire() ? "soul_campfire" : "campfire";
            utility.color(new String[]{I18n.func_135052_a((String)"tooltip.alchemist.requires", (Object[])new Object[0]) + ": ", I18n.func_135052_a((String)("block.minecraft." + campfire), (Object[])new Object[0])}, new TextFormatting[]{TextFormatting.GRAY, TextFormatting.WHITE});
            utility.space();
            utility.color(new String[]{I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]) + " ", "[", String.valueOf(pouch.getUses()), "]"}, new TextFormatting[]{this.func_77613_e((ItemStack)stack).field_77937_e, TextFormatting.GRAY, TextFormatting.WHITE, TextFormatting.GRAY});
            utility.effect(UtilityGetter.getEffectInstance(new ResourceLocation(pouch.getEffect()), pouch.getDuration(), pouch.getAmplifier()), TextFormatting.WHITE);
        } else if (Screen.func_231173_s_()) {
            int number = I18n.func_135052_a((String)"journal.alchemist.mixture", (Object[])new Object[0]).length();
            utility.clear();
            utility.color(new String[]{I18n.func_135052_a((String)"journal.alchemist", (Object[])new Object[0]) + " ", I18n.func_135052_a((String)"journal.alchemist.page", (Object[])new Object[]{number})}, new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.WHITE});
            utility.trim("\"" + I18n.func_135052_a((String)"journal.alchemist.mixture", (Object[])new Object[0]) + "\"", 3);
        } else {
            utility.trim(I18n.func_135052_a((String)"description.alchemist.ingredients", (Object[])new Object[0]), 3);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() == null) {
            return super.func_195939_a(context);
        }
        ItemStack hand_right = context.func_195999_j().func_184586_b(Hand.MAIN_HAND);
        ItemStack hand_left = context.func_195999_j().func_184586_b(Hand.OFF_HAND);
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (!state.func_177230_c().equals(Blocks.field_222433_lV) && !state.func_177230_c().equals(Blocks.field_235367_mf_) || !((Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            return super.func_195939_a(context);
        }
        if (context.func_221531_n().equals((Object)Hand.MAIN_HAND)) {
            if (FunctionTools.getItems().contains(hand_left.func_77973_b())) {
                return super.func_195939_a(context);
            }
            context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true)));
            context.func_195999_j().func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)AlchemicalItems.POUCH));
            return ActionResultType.SUCCESS;
        }
        if (!hand_left.func_77973_b().equals((Object)this) || !FunctionTools.getItems().contains(hand_right.func_77973_b())) {
            return super.func_195939_a(context);
        }
        UtilityCompound.Pouch pouch = UtilityCompound.Pouch.convert(hand_left);
        UtilityCompound.Tool tool_primary = UtilityCompound.Tool.convert(hand_right, true);
        UtilityCompound.Tool tool_secondary = UtilityCompound.Tool.convert(hand_right, false);
        if (!pouch.doesExist()) {
            return super.func_195939_a(context);
        }
        if (pouch.isSoulfire() && !state.func_177230_c().equals(Blocks.field_235367_mf_)) {
            return super.func_195939_a(context);
        }
        if (tool_primary.getUses() != 0 && (tool_secondary.getUses() != 0 || EnchantmentHelper.func_77506_a((Enchantment)AlchemicalEnchantments.KNOWLEDGE, (ItemStack)hand_right) == 0)) {
            return super.func_195939_a(context);
        }
        if (pouch.getEffect().equals(tool_primary.getEffect()) && tool_primary.getUses() > 0 || pouch.getEffect().equals(tool_secondary.getEffect()) && tool_secondary.getUses() > 0) {
            return super.func_195939_a(context);
        }
        context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        context.func_195999_j().func_184611_a(Hand.MAIN_HAND, this.compoundInject(hand_left, hand_right));
        context.func_195999_j().func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)AlchemicalItems.POUCH));
        Alchemist.LOGGER.debug((Object)context.func_195999_j().func_184586_b(Hand.MAIN_HAND).func_77978_p());
        return ActionResultType.SUCCESS;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group.equals(Alchemist.GROUP_MIXTURES) || group.equals(ItemGroup.field_78027_g)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)this.compoundWrite(new ItemStack((IItemProvider)this), 0, true));
        }
    }

    private int roll(int times, int current, int[] values) {
        if (values.length == 1) {
            return current;
        }
        for (int i = 0; i < times; ++i) {
            int rnd = values[field_77697_d.nextInt(values.length)];
            if (rnd <= current || times < 3 && field_77697_d.nextInt(3 - times) != 0) continue;
            current = rnd;
        }
        return current;
    }

    public ItemStack compoundWrite(ItemStack stack, int level, boolean master) {
        int duration;
        CompoundNBT nbt = new CompoundNBT();
        int amplifier = master ? this.mixture.getAmplifiers()[this.mixture.getAmplifiers().length - 1] : this.mixture.getAmplifiers()[0];
        int uses = master ? this.mixture.getUses()[this.mixture.getUses().length - 1] : this.mixture.getUses()[0];
        int n = duration = master ? this.mixture.getDurations()[this.mixture.getDurations().length - 1] : this.mixture.getDurations()[0];
        if (level > 0 && !master) {
            amplifier = this.roll(level, amplifier, this.mixture.getAmplifiers());
            uses = this.roll(level, uses, this.mixture.getUses());
            duration = this.roll(level, duration, this.mixture.getDurations());
        }
        nbt.func_74768_a("duration", duration);
        nbt.func_74778_a("effect", this.mixture.getEffect());
        nbt.func_74757_a("soulfire", this.mixture.isSoulfire());
        nbt.func_74768_a("amplifier", amplifier);
        nbt.func_74768_a("uses", uses);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_218657_a("mixture", (INBT)nbt);
        return stack;
    }

    public ItemStack compoundInject(ItemStack mixture, ItemStack tool) {
        boolean hasKnowledge = EnchantmentHelper.func_77506_a((Enchantment)AlchemicalEnchantments.KNOWLEDGE, (ItemStack)tool) > 0;
        UtilityCompound.Pouch pouch = UtilityCompound.Pouch.convert(mixture);
        UtilityCompound.Tool tool_primary = UtilityCompound.Tool.convert(tool, true);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("uses", pouch.getUses());
        nbt.func_74768_a("duration", pouch.getDuration());
        nbt.func_74768_a("amplifier", pouch.getAmplifier());
        nbt.func_74778_a("effect", pouch.getEffect());
        if (tool.func_77978_p() == null) {
            tool.func_77982_d(new CompoundNBT());
        }
        if (!tool_primary.doesExist() || tool_primary.getUses() == 0) {
            if (!tool.func_77978_p().func_74764_b("mixture")) {
                tool.func_77978_p().func_218657_a("mixture", (INBT)new CompoundNBT());
            }
            tool.func_77978_p().func_74775_l("mixture").func_218657_a("primary", (INBT)nbt);
        } else if (hasKnowledge) {
            tool.func_77978_p().func_74775_l("mixture").func_218657_a("secondary", (INBT)nbt);
        }
        return tool;
    }

    public static boolean compoundCheck(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("mixture");
    }
}

