/*
 * Decompiled with CFR 0.152.
 */
package lucie.alchemist.utility;

import java.util.List;
import lucie.alchemist.Alchemist;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class UtilityTooltip {
    private List<ITextComponent> tooltip;

    public UtilityTooltip(List<ITextComponent> tooltip) {
        this.tooltip = tooltip;
    }

    public void clear() {
        this.tooltip.clear();
    }

    public void space() {
        this.tooltip.add((ITextComponent)new StringTextComponent(""));
    }

    public void trim(String localized, int rows) {
        StringTextComponent s;
        rows = localized.length() / rows;
        StringBuilder builder = new StringBuilder();
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY).func_240722_b_(Boolean.valueOf(true));
        int size = 0;
        for (int i = 0; i < localized.length(); ++i) {
            char c = localized.charAt(i);
            if (c == ' ' && size >= rows) {
                s = new StringTextComponent(builder.toString());
                s.func_230530_a_(style);
                this.tooltip.add((ITextComponent)s);
                builder = new StringBuilder();
                size = 0;
                continue;
            }
            ++size;
            builder.append(c);
        }
        s = new StringTextComponent(builder.toString());
        s.func_230530_a_(style);
        this.tooltip.add((ITextComponent)s);
    }

    public void color(String[] texts, TextFormatting[] formattings) {
        if (texts.length != formattings.length) {
            Alchemist.LOGGER.error("colorTooltip mismatch! Texts: '" + texts.length + "', Formattings: '" + formattings.length + "'. Returning without formatting.");
            return;
        }
        StringTextComponent output = new StringTextComponent("");
        for (int i = 0; i < texts.length; ++i) {
            StringTextComponent c = new StringTextComponent(texts[i]);
            c.func_230530_a_(Style.field_240709_b_.func_240712_a_(formattings[i]));
            output.func_230529_a_((ITextComponent)c);
        }
        this.tooltip.add((ITextComponent)output);
    }

    public void effect(EffectInstance effect, TextFormatting color) {
        String text;
        int seconds = effect.func_76459_b() / 20;
        int t1 = seconds % 60;
        int t2 = seconds / 60;
        int t3 = t2 % 60;
        t2 /= 60;
        String time = t3 < 10 ? "(0" + t3 + ":" : "(" + t3 + ":";
        String string = time = t1 < 10 ? time + "0" + t1 + ")" : time + t1 + ")";
        if (seconds > 3599) {
            time = t2 + ":" + time;
        }
        if (effect.func_76458_c() != 0) {
            String amplifier;
            switch (effect.func_76458_c() + 1) {
                case 2: {
                    amplifier = "II";
                    break;
                }
                case 3: {
                    amplifier = "III";
                    break;
                }
                case 4: {
                    amplifier = "IV";
                    break;
                }
                case 5: {
                    amplifier = "V";
                    break;
                }
                default: {
                    amplifier = "?";
                }
            }
            text = effect.func_76459_b() == 1 ? I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + " " + amplifier : I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + " " + amplifier + " " + time;
        } else {
            text = effect.func_76459_b() == 1 ? I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) : I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + " " + time;
        }
        StringTextComponent component = new StringTextComponent(" " + text);
        component.func_230530_a_(Style.field_240709_b_.func_240712_a_(color));
        this.tooltip.add((ITextComponent)component);
    }

    public void mixture(EffectInstance effect, int uses, ResourceLocation location, TextFormatting primary, TextFormatting secondary) {
        this.color(new String[]{I18n.func_135052_a((String)"item.alchemist.mixture", (Object[])new Object[]{I18n.func_135052_a((String)("effect." + location.func_110624_b() + "." + location.func_110623_a()), (Object[])new Object[0])}) + ": ", "[", String.valueOf(uses), "]"}, new TextFormatting[]{primary, TextFormatting.GRAY, TextFormatting.WHITE, TextFormatting.GRAY});
        this.effect(effect, secondary);
    }
}

