/*
 * Decompiled with CFR 0.152.
 */
package al132.chemlib.items;

import al132.chemlib.ChemLib;
import al132.chemlib.Utils;
import al132.chemlib.chemistry.ChemicalStack;
import al132.chemlib.chemistry.CompoundRegistry;
import al132.chemlib.items.BaseItem;
import al132.chemlib.items.DankMolecule;
import al132.chemlib.items.IChemical;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CompoundItem
extends BaseItem
implements IChemical {
    private List<ChemicalStack> components;
    public int color;
    public final String internalName;
    public final int shiftedSlots;
    public int burnTime = 0;
    private String abbreviation = "";

    public CompoundItem(String name, Color color, List<ChemicalStack> components, int shiftedSlots) {
        super("compound_" + name, new Item.Properties());
        this.components = components;
        this.color = color.getRGB();
        this.internalName = name;
        CompoundRegistry.compounds.add(this);
        this.shiftedSlots = shiftedSlots;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(this.getAbbreviation()).func_240699_a_(ChemLib.CHEM_TOOLTIP_COLOR));
        if (DankMolecule.hasDankMolecule(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"tooltip.chemlib.generic_potion_compound", (Object[])new Object[0])));
        }
    }

    @Override
    public String getAbbreviation() {
        if (this.abbreviation.isEmpty()) {
            this.abbreviation = Utils.getAbbreviation(this.components);
        }
        return this.abbreviation;
    }

    public String getASCIIAbbreviation() {
        return this.getAbbreviation().chars().map(x -> x >= 8320 ? x - 8320 + 48 : x).filter(x -> x != 40 && x != 41).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public String getChemicalName() {
        return this.internalName;
    }

    public List<ChemicalStack> getComponents() {
        return this.components;
    }

    public List<ItemStack> getComponentStacks() {
        return this.components.stream().map(ChemicalStack::toItemStack).collect(Collectors.toList());
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            DankMolecule.getDankMolecule(stack).ifPresent(molecule -> {
                molecule.activateForPlayer((PlayerEntity)entity);
                stack.func_190918_g(1);
            });
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        if (DankMolecule.hasDankMolecule(stack)) {
            return 36;
        }
        return super.func_77626_a(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (DankMolecule.hasDankMolecule(stack)) {
            return UseAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (DankMolecule.hasDankMolecule(stack)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex > 0 ? -1 : this.color;
    }
}

