/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.atomizer;

import al132.alchemistry.blocks.atomizer.AtomizerRecipe;
import al132.alchemistry.misc.ProcessingRecipe;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AtomizerRecipeSerializer<T extends AtomizerRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private IFactory<T> factory;

    public AtomizerRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        ItemStack output;
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonObject inputObject = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        ResourceLocation fluidLocation = new ResourceLocation(inputObject.get("fluid").getAsString());
        int fluidAmount = inputObject.get("amount").getAsInt();
        FluidStack inputStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation), fluidAmount);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            output = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(resourcelocation));
        }
        return (T)((AtomizerRecipe)this.factory.create(recipeId, group, inputStack, output));
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        FluidStack input = buffer.readFluidStack();
        ItemStack output = buffer.func_150791_c();
        return (T)((AtomizerRecipe)this.factory.create(recipeId, group, input, output));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).func_193358_e());
        buffer.writeFluidStack(((AtomizerRecipe)recipe).input);
        buffer.func_150788_a(((AtomizerRecipe)recipe).output);
    }

    public static interface IFactory<T extends ProcessingRecipe> {
        public T create(ResourceLocation var1, String var2, FluidStack var3, ItemStack var4);
    }
}

