/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.combiner;

import al132.alchemistry.blocks.combiner.CombinerRecipe;
import al132.alchemistry.misc.ProcessingRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombinerRecipeSerializer<T extends CombinerRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private IFactory<T> factory;

    public CombinerRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ArrayList input = Lists.newArrayList();
        JsonArray inputJson = JSONUtils.func_151214_t((JsonObject)json, (String)"input");
        inputJson.forEach(entry -> {
            JsonObject obj = entry.getAsJsonObject();
            Item item = JSONUtils.func_188180_i((JsonObject)obj, (String)"item");
            int count = JSONUtils.func_151204_g((JsonObject)obj, (String)"count") ? JSONUtils.func_151203_m((JsonObject)obj, (String)"count") : 1;
            input.add(new ItemStack((IItemProvider)item, count));
        });
        ItemStack output = ItemStack.field_190927_a;
        if (json.get("result").isJsonObject()) {
            JsonObject obj = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            Item item = JSONUtils.func_188180_i((JsonObject)obj, (String)"item");
            int count = JSONUtils.func_151204_g((JsonObject)obj, (String)"count") ? JSONUtils.func_151203_m((JsonObject)obj, (String)"count") : 1;
            output = new ItemStack((IItemProvider)item, count);
        } else {
            Item item = JSONUtils.func_188180_i((JsonObject)json, (String)"result");
            output = new ItemStack((IItemProvider)item);
        }
        return (T)((CombinerRecipe)this.factory.create(recipeId, group, input, output));
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        ArrayList input = Lists.newArrayList();
        for (int i = 0; i < 9; ++i) {
            input.add(buffer.func_150791_c());
        }
        ItemStack output = buffer.func_150791_c();
        return (T)((CombinerRecipe)this.factory.create(recipeId, group, input, output));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).func_193358_e());
        for (int i = 0; i < 9; ++i) {
            buffer.func_150788_a(((CombinerRecipe)recipe).inputs.get(i));
        }
        buffer.func_150788_a(((CombinerRecipe)recipe).output);
    }

    public static interface IFactory<T extends ProcessingRecipe> {
        public T create(ResourceLocation var1, String var2, List<ItemStack> var3, ItemStack var4);
    }
}

