/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.liquifier;

import al132.alchemistry.blocks.liquifier.LiquifierRecipe;
import al132.alchemistry.misc.ProcessingRecipe;
import al132.alchemistry.utils.IngredientStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LiquifierRecipeSerializer<T extends LiquifierRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private IFactory<T> factory;

    public LiquifierRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient input = Ingredient.func_199802_a((JsonElement)jsonelement);
        JsonObject inputObject = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        int inputCount = JSONUtils.func_151204_g((JsonObject)json, (String)"inputCount") ? JSONUtils.func_151203_m((JsonObject)json, (String)"inputCount") : 1;
        ResourceLocation fluidLocation = new ResourceLocation(inputObject.get("fluid").getAsString());
        int fluidAmount = inputObject.get("amount").getAsInt();
        FluidStack output = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation), fluidAmount);
        return (T)((LiquifierRecipe)this.factory.create(recipeId, group, new IngredientStack(input, inputCount), output));
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        IngredientStack input = IngredientStack.read(buffer);
        FluidStack output = buffer.readFluidStack();
        return (T)((LiquifierRecipe)this.factory.create(recipeId, group, input, output));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).func_193358_e());
        ((LiquifierRecipe)recipe).input.write(buffer);
        buffer.writeFluidStack(((LiquifierRecipe)recipe).output);
    }

    public static interface IFactory<T extends ProcessingRecipe> {
        public T create(ResourceLocation var1, String var2, IngredientStack var3, FluidStack var4);
    }
}

