/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.datagen;

import al132.alchemistry.Ref;
import al132.alchemistry.blocks.dissolver.DissolverTagData;
import al132.alchemistry.datagen.recipe.CombinerRecipeBuilder;
import al132.alchemistry.datagen.recipe.DissolverRecipeBuilder;
import al132.alchemistry.datagen.recipe.FissionRecipeBuilder;
import al132.alchemistry.misc.ProbabilityGroup;
import al132.alchemistry.misc.ProbabilitySet;
import al132.alchemistry.utils.StackUtils;
import al132.chemlib.chemistry.CompoundRegistry;
import al132.chemlib.chemistry.ElementRegistry;
import al132.chemlib.items.CompoundItem;
import al132.chemlib.items.ElementItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Recipes
extends RecipeProvider {
    public static List<DissolverTagData> metalTagData = new ArrayList<DissolverTagData>();
    public static List<String> metals = new ArrayList<String>();
    public static final String heathenSpelling = "aluminium";
    private Consumer<IFinishedRecipe> consumer;

    public Recipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
        this.initMetals();
        this.registerFissionRecipes();
        this.registerCombinerRecipes();
        this.registerDissolverRecipes();
    }

    private void combiner(Item output, List<ItemStack> input) {
        this.combiner(output, 1, input);
    }

    private void combiner(Item output, int outputCount, List<ItemStack> input) {
        CombinerRecipeBuilder.recipe(new ItemStack((IItemProvider)output, outputCount), input.stream().map(x -> {
            if (x == null) {
                return ItemStack.field_190927_a;
            }
            return x;
        }).collect(Collectors.toList())).build(this.consumer);
    }

    public static ProbabilitySet.Builder set() {
        return new ProbabilitySet.Builder();
    }

    public void dissolver(String tag, ProbabilitySet set) {
        this.dissolver(Ingredient.func_199805_a((ITag)ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)new ResourceLocation(tag))), set, tag.replace(":", "."));
    }

    public void dissolver(Ingredient input, ProbabilitySet set, String name) {
        DissolverRecipeBuilder.recipe(input, set, name).build(this.consumer);
    }

    public void dissolver(Ingredient input, ProbabilitySet set, String name, boolean reversible) {
        DissolverRecipeBuilder.recipe(input, set, name).build(this.consumer);
        if (reversible) {
            CombinerRecipeBuilder.recipe(input.func_193365_a()[0], set.getSet().get(0).getOutputs());
        }
    }

    public void dissolver(Item input, ProbabilitySet set) {
        this.dissolver(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), set, input.getRegistryName().func_110623_a(), false);
    }

    public void dissolver(Item input, ProbabilitySet set, boolean reversible) {
        this.dissolver(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), set, input.getRegistryName().func_110623_a(), reversible);
    }

    public void dissolver(ItemStack input, ProbabilitySet set) {
        this.dissolver(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), set, input.func_77973_b().getRegistryName().func_110623_a(), false);
    }

    public void dissolver(ItemStack input, ProbabilitySet set, boolean reversible) {
        this.dissolver(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), set, input.func_77973_b().getRegistryName().func_110623_a(), reversible);
    }

    private void registerFissionRecipes() {
        for (int i = 2; i <= 118; ++i) {
            FissionRecipeBuilder.recipe(i).build(this.consumer);
        }
    }

    private void registerDissolverRecipes() {
        boolean reversible;
        int multiplier;
        int rolls;
        this.dissolver("minecraft:logs", Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose")).build());
        this.dissolver("minecraft:planks", Recipes.set().relative(false).addGroup(25.0, StackUtils.toStack("cellulose")).build());
        this.dissolver("minecraft:leaves", Recipes.set().relative(false).addGroup(5.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_221585_m, Recipes.set().addGroup(700.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("aluminum")).addGroup(4.0, StackUtils.toStack("iron")).addGroup(1.5, StackUtils.toStack("gold")).addGroup(10.0, StackUtils.toStack("silicon_dioxide")).addGroup(1.0, StackUtils.toStack("dysprosium")).addGroup(1.5, StackUtils.toStack("zirconium")).addGroup(1.0, StackUtils.toStack("nickel")).addGroup(1.0, StackUtils.toStack("gallium")).addGroup(1.0, StackUtils.toStack("tungsten")).build());
        this.dissolver(Items.field_221653_bO, Recipes.set().addGroup(697.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("aluminum")).addGroup(4.0, StackUtils.toStack("iron")).addGroup(1.5, StackUtils.toStack("gold")).addGroup(10.0, StackUtils.toStack("silicon_dioxide")).addGroup(1.0, StackUtils.toStack("dysprosium")).addGroup(1.5, StackUtils.toStack("zirconium")).addGroup(1.0, StackUtils.toStack("nickel")).addGroup(1.0, StackUtils.toStack("gallium")).addGroup(1.0, StackUtils.toStack("tungsten")).addGroup(3.0, StackUtils.toStack("cellulose")).build());
        Lists.newArrayList((Object[])new Item[]{Items.field_221575_c, Items.field_221576_d}).forEach(item -> this.dissolver((Item)item, Recipes.set().addGroup(5.0, StackUtils.toStack("aluminum_oxide")).addGroup(2.0, StackUtils.toStack("iron")).addGroup(2.0, StackUtils.toStack("potassium_chloride")).addGroup(10.0, StackUtils.toStack("silicon_dioxide")).addGroup(1.0, StackUtils.toStack("technetium")).addGroup(1.5, StackUtils.toStack("manganese")).addGroup(1.5, StackUtils.toStack("radium")).build()));
        Lists.newArrayList((Object[])new Item[]{Items.field_221577_e, Items.field_221578_f}).forEach(item -> this.dissolver((Item)item, Recipes.set().addGroup(4.0, StackUtils.toStack("aluminum_oxide")).addGroup(2.0, StackUtils.toStack("iron")).addGroup(4.0, StackUtils.toStack("potassium_chloride")).addGroup(10.0, StackUtils.toStack("silicon_dioxide")).addGroup(1.5, StackUtils.toStack("indium")).addGroup(2.0, StackUtils.toStack("manganese")).addGroup(2.0, StackUtils.toStack("osmium")).addGroup(3.0, StackUtils.toStack("tin")).build()));
        this.dissolver(Items.field_221958_gk, Recipes.set().rolls(2).addGroup(10.0, StackUtils.toStack("manganese", 2)).addGroup(5.0, StackUtils.toStack("aluminum_oxide")).addGroup(20.0, StackUtils.toStack("magnesium_oxide")).addGroup(2.0, StackUtils.toStack("potassium_chloride")).addGroup(10.0, StackUtils.toStack("silicon_dioxide", 2)).addGroup(20.0, StackUtils.toStack("sulfur", 2)).addGroup(10.0, StackUtils.toStack("iron_oxide")).addGroup(8.0, StackUtils.toStack("lead", 2)).addGroup(4.0, StackUtils.toStack("fluorine")).addGroup(4.0, StackUtils.toStack("bromine")).build());
        Lists.newArrayList((Object[])new Item[]{Items.field_221579_g, Items.field_221580_h}).forEach(item -> this.dissolver((Item)item, Recipes.set().addGroup(4.0, StackUtils.toStack("aluminum_oxide")).addGroup(3.0, StackUtils.toStack("iron")).addGroup(4.0, StackUtils.toStack("potassium_chloride")).addGroup(10.0, StackUtils.toStack("silicon_dioxide")).addGroup(2.0, StackUtils.toStack("platinum")).addGroup(4.0, StackUtils.toStack("calcium")).build()));
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221574_b, Items.field_221645_bK, Items.field_221726_by, Items.field_221723_cX, Items.field_221727_cZ, Items.field_221782_da})) {
            rolls = 1;
            if (item2 == Items.field_221723_cX || item2 == Items.field_221727_cZ || item2 == Items.field_221782_da) {
                rolls = 4;
            } else if (item2 == Items.field_221726_by) {
                rolls = 2;
            }
            this.dissolver(item2, Recipes.set().rolls(rolls).addGroup(20.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("aluminum")).addGroup(4.0, StackUtils.toStack("iron")).addGroup(1.5, StackUtils.toStack("gold")).addGroup(20.0, StackUtils.toStack("silicon_dioxide")).addGroup(0.5, StackUtils.toStack("dysprosium")).addGroup(1.25, StackUtils.toStack("zirconium")).addGroup(1.0, StackUtils.toStack("tungsten")).addGroup(1.0, StackUtils.toStack("nickel")).addGroup(1.0, StackUtils.toStack("gallium")).build());
        }
        this.dissolver("forge:chests/wooden", Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose", 2)).build());
        this.dissolver(Items.field_221734_cc, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_221672_ax, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221916_fp, Items.field_221600_aB, Items.field_221674_ay, Items.field_221599_aA})) {
            this.dissolver(item2, Recipes.set().relative(false).addGroup(25.0, StackUtils.toStack("cellulose")).build());
        }
        this.dissolver(Items.field_151145_ak, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide", 3)).build());
        this.dissolver(Items.field_196130_bo, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("caffeine")).addGroup(50.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_151034_e, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose"), StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_221553_F, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 32), StackUtils.toStack("sulfur", 8)).build());
        this.dissolver(Items.field_221896_ff, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 72)).build());
        this.dissolver(Items.field_151044_h, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 8)).build());
        this.dissolver(Items.field_196155_l, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 8)).build());
        this.dissolver("minecraft:wooden_slabs", Recipes.set().relative(false).addGroup(12.0, StackUtils.toStack("cellulose")).build());
        this.dissolver("forge:slimeballs", Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2), StackUtils.toStack("sucrose", 2)).build());
        this.dissolver(Items.field_221904_fj, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 18), StackUtils.toStack("sucrose", 18)).build());
        this.dissolver((Item)Ref.condensedMilk, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium", 4), StackUtils.toStack("protein", 2), StackUtils.toStack("sucrose")).build());
        this.dissolver(Items.field_151055_y, Recipes.set().relative(false).addGroup(10.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_151079_bi, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon", 16), StackUtils.toStack("mercury", 16), StackUtils.toStack("neodymium", 16)).build(), true);
        this.dissolver(Items.field_151014_N, Recipes.set().relative(false).addGroup(10.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_221691_cH, Recipes.set().addGroup(15.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("zinc_oxide")).addGroup(1.0, StackUtils.toStack("gold")).addGroup(1.0, StackUtils.toStack("phosphorus")).addGroup(3.0, StackUtils.toStack("sulfur")).addGroup(1.0, StackUtils.toStack("germanium")).addGroup(4.0, StackUtils.toStack("silicon")).build());
        this.dissolver(Items.field_234767_m_, Recipes.set().addGroup(10.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("cellulose")).addGroup(4.0, StackUtils.toStack("zinc_oxide")).addGroup(1.0, StackUtils.toStack("gold")).addGroup(1.0, StackUtils.toStack("phosphorus")).addGroup(3.0, StackUtils.toStack("sulfur")).addGroup(3.0, StackUtils.toStack("germanium")).addGroup(5.0, StackUtils.toStack("silicon")).addGroup(1.0, StackUtils.toStack("selenium")).build());
        this.dissolver(Items.field_234768_n_, Recipes.set().addGroup(10.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("cellulose")).addGroup(4.0, StackUtils.toStack("zinc_oxide")).addGroup(1.0, StackUtils.toStack("gold")).addGroup(1.0, StackUtils.toStack("phosphorus")).addGroup(3.0, StackUtils.toStack("sulfur")).addGroup(1.0, StackUtils.toStack("mercury")).addGroup(5.0, StackUtils.toStack("silicon")).addGroup(1.0, StackUtils.toStack("neodymium")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196154_dH, Items.field_221818_ds, Items.field_234744_ef_, Items.field_234745_eg_, Items.field_221962_gm})) {
            rolls = 1;
            if (item2 != Items.field_196154_dH) {
                rolls = 4;
            }
            this.dissolver(item2, Recipes.set().rolls(rolls).addGroup(5.0, ItemStack.field_190927_a).addGroup(2.0, StackUtils.toStack("zinc_oxide")).addGroup(1.0, StackUtils.toStack("gold")).addGroup(1.0, StackUtils.toStack("phosphorus")).addGroup(4.0, StackUtils.toStack("sulfur")).addGroup(1.0, StackUtils.toStack("germanium")).addGroup(4.0, StackUtils.toStack("silicon")).build());
        }
        this.dissolver(Items.field_151070_bp, Recipes.set().addGroup(1.0, StackUtils.toStack("beta_carotene", 2), StackUtils.toStack("protein", 2)).build());
        this.dissolver(Items.field_151138_bX, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 64)).build());
        this.dissolver(Items.field_151136_bY, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 64)).build());
        this.dissolver(Items.field_151125_bZ, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 2048)).build());
        this.dissolver("minecraft:wool", Recipes.set().addGroup(1.0, StackUtils.toStack("protein"), StackUtils.toStack("triglyceride")).build());
        this.dissolver("minecraft:carpets", Recipes.set().relative(false).addGroup(66.66666666666666, StackUtils.toStack("protein"), StackUtils.toStack("triglyceride")).build());
        this.dissolver(Items.field_221844_ef, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 496)).build());
        this.dissolver(Items.field_222013_iM, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 32)).build());
        this.dissolver(Items.field_221805_eM, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 64)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151166_bC, Items.field_221733_dC, Items.field_221739_dF})) {
            multiplier = 1;
            reversible = false;
            if (item2 == Items.field_151166_bC) {
                reversible = true;
            } else if (item2 == Items.field_221733_dC) {
                multiplier = 2;
            } else if (item2 == Items.field_221739_dF) {
                multiplier = 9;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("beryl", 8 * multiplier), StackUtils.toStack("chromium", 8 * multiplier), StackUtils.toStack("vanadium", 4 * multiplier)).build(), reversible);
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151045_i, Items.field_221730_ca, Items.field_221732_cb})) {
            multiplier = 1;
            if (item2 == Items.field_221730_ca) {
                multiplier = 2;
            } else if (item2 == Items.field_221732_cb) {
                multiplier = 9;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 512 * multiplier)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221828_dx, Items.field_221830_dy})) {
            this.dissolver(item2, Recipes.set().addGroup(50.0, StackUtils.toStack("mercury")).addGroup(5.0, StackUtils.toStack("neodymium")).addGroup(250.0, StackUtils.toStack("silicon_dioxide")).addGroup(50.0, StackUtils.toStack("lithium")).addGroup(2.0, StackUtils.toStack("thorium")).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221772_cv, Items.field_221770_cu})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("water", 16)).build());
        }
        this.dissolver(Items.field_221898_fg, Recipes.set().addGroup(1.0, StackUtils.toStack("water", 144)).build());
        this.dissolver(Items.field_222047_ii, Recipes.set().addGroup(1.0, StackUtils.toStack("water", 576)).build());
        this.dissolver(Items.field_151126_ay, Recipes.set().addGroup(1.0, StackUtils.toStack("water", 4)).build());
        this.dissolver(Items.field_221768_ct, Recipes.set().addGroup(1.0, StackUtils.toStack("water", 4)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_179562_cC, Items.field_221879_fX, Items.field_221881_fY})) {
            multiplier = 1;
            if (item2 == Items.field_221879_fX) {
                multiplier = 4;
            } else if (item2 == Items.field_221881_fY) {
                multiplier = 9;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("beryl", 4 * multiplier), StackUtils.toStack("niobium", 3 * multiplier), StackUtils.toStack("selenium", multiplier)).build());
        }
        this.dissolver(Items.field_179563_cD, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide", 4), StackUtils.toStack("phosphorus", 3), StackUtils.toStack("selenium", 1)).build());
        this.dissolver(Items.field_221883_fZ, Recipes.set().addGroup(1.0, StackUtils.toStack("beryl", 32), StackUtils.toStack("niobium", 24), StackUtils.toStack("selenium", 8), StackUtils.toStack("titanium_dioxide", 4)).build());
        this.dissolver("minecraft:music_discs", Recipes.set().addGroup(1.0, StackUtils.toStack("polyvinyl_chloride", 64), StackUtils.toStack("lead", 16), StackUtils.toStack("cadmium", 16)).build());
        this.dissolver(Items.field_221778_cy, Recipes.set().addGroup(1.0, StackUtils.toStack("carbon", 512), StackUtils.toStack("cellulose", 2)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221582_j, Items.field_221583_k, Items.field_221584_l})) {
            this.dissolver(item2, Recipes.set().addGroup(30.0, StackUtils.toStack("water")).addGroup(50.0, StackUtils.toStack("silicon_dioxide")).addGroup(10.0, StackUtils.toStack("cellulose")).addGroup(10.0, StackUtils.toStack("kaolinite")).build());
        }
        this.dissolver(Items.field_221814_dq, Recipes.set().addGroup(30.0, StackUtils.toStack("water")).addGroup(50.0, StackUtils.toStack("silicon_dioxide")).addGroup(10.0, StackUtils.toStack("cellulose")).addGroup(10.0, StackUtils.toStack("kaolinite")).addGroup(30.0, StackUtils.toStack("psilocybin")).build());
        this.dissolver(Items.field_221581_i, Recipes.set().addGroup(30.0, StackUtils.toStack("water")).addGroup(50.0, StackUtils.toStack("silicon_dioxide")).addGroup(10.0, StackUtils.toStack("cellulose")).addGroup(10.0, StackUtils.toStack("kaolinite")).build());
        this.dissolver("forge:glass", Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide", 4)).build());
        this.dissolver("minecraft:saplings", Recipes.set().relative(false).addGroup(25.0, StackUtils.toStack("cellulose", 1)).build());
        this.dissolver(Items.field_221796_dh, Recipes.set().relative(false).addGroup(25.0, StackUtils.toStack("cellulose", 1)).build());
        this.dissolver(Items.field_151121_aF, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_221816_dr, Recipes.set().relative(false).addGroup(25.0, StackUtils.toStack("cellulose", 1)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221687_cF, Items.field_221689_cG})) {
            this.dissolver(item2, Recipes.set().relative(false).addGroup(50.0, StackUtils.toStack("cucurbitacin", 1)).build());
        }
        this.dissolver(Items.field_151128_bU, Recipes.set().addGroup(1.0, StackUtils.toStack("barium", 16), StackUtils.toStack("silicon_dioxide", 32)).build(), true);
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221860_en, Items.field_221625_bA, Items.field_221999_iF})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("barium", 32), StackUtils.toStack("silicon_dioxide", 64)).build());
        }
        this.dissolver("forge:storage_blocks/quartz", Recipes.set().addGroup(1.0, StackUtils.toStack("barium", 64), StackUtils.toStack("silicon_dioxide", 128)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221864_ep, Items.field_221639_bH, Items.field_221868_er, Items.field_234750_fo_})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("barium", 64), StackUtils.toStack("silicon_dioxide", 128)).build());
        }
        this.dissolver(Items.field_221692_bh, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("psilocybin")).build(), true);
        this.dissolver(Items.field_221694_bi, Recipes.set().addGroup(1.0, StackUtils.toStack("psilocybin"), StackUtils.toStack("cellulose")).build(), true);
        this.dissolver(Items.field_234722_bw_, Recipes.set().addGroup(1.0, StackUtils.toStack("psilocybin"), StackUtils.toStack("cellulose"), StackUtils.toStack("selenium")).build(), true);
        this.dissolver(Items.field_234723_bx_, Recipes.set().addGroup(1.0, StackUtils.toStack("psilocybin"), StackUtils.toStack("cellulose"), StackUtils.toStack("mercury")).build(), true);
        this.dissolver(Items.field_234724_by_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("mercury_sulfide")).build(), true);
        this.dissolver(Items.field_234725_bz_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("copper_chloride")).build(), true);
        this.dissolver(Items.field_234717_bA_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("copper_chloride")).build(), true);
        this.dissolver(Items.field_234719_bC_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("copper_chloride")).build(), true);
        this.dissolver(Items.field_234718_bB_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("mercury_sulfide")).build(), true);
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221693_cI, Items.field_234734_dm_})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("thulium"), StackUtils.toStack("silicon_dioxide", 4)).build(), true);
        }
        this.dissolver(Items.field_222065_kN, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose")).build());
        this.dissolver(Items.field_221548_A, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("silicon_dioxide", 4)).addGroup(1.0, StackUtils.toStack("gold")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221658_aq, Items.field_221660_ar, Items.field_221662_as})) {
            this.dissolver(item2, Recipes.set().rolls(4).relative(false).addGroup(100.0, StackUtils.toStack("silicon_dioxide", 4)).addGroup(1.0, StackUtils.toStack("gold")).build());
        }
        this.dissolver(Items.field_221549_B, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("silicon_dioxide", 4)).addGroup(10.0, StackUtils.toStack("iron_oxide")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221946_ge, Items.field_221950_gg, Items.field_221641_bI})) {
            this.dissolver(item2, Recipes.set().rolls(4).relative(false).addGroup(100.0, StackUtils.toStack("silicon_dioxide", 4)).addGroup(10.0, StackUtils.toStack("iron_oxide")).build());
        }
        this.dissolver(Items.field_151102_aT, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose")).build());
        this.dissolver(Items.field_151016_H, Recipes.set().addGroup(1.0, StackUtils.toStack("potassium_nitrate", 2), StackUtils.toStack("sulfur", 8), StackUtils.toStack("carbon", 8)).build(), true);
        this.dissolver(Items.field_151065_br, Recipes.set().addGroup(1.0, StackUtils.toStack("germanium", 8), StackUtils.toStack("carbon", 8), StackUtils.toStack("sulfur", 8)).build(), true);
        this.dissolver(Items.field_151075_bm, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("germanium", 4), StackUtils.toStack("selenium", 4)).build(), true);
        this.dissolver(Items.field_221960_gl, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose", 9), StackUtils.toStack("germanium", 36), StackUtils.toStack("selenium", 36)).build());
        this.dissolver(Items.field_234751_hk_, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose", 9), StackUtils.toStack("neodymium", 4), StackUtils.toStack("mercury", 4)).build());
        this.dissolver(Items.field_151114_aO, Recipes.set().addGroup(1.0, StackUtils.toStack("phosphorus", 4)).build(), true);
        this.dissolver(Items.field_221695_cJ, Recipes.set().addGroup(1.0, StackUtils.toStack("phosphorus", 16)).build());
        this.dissolver(Items.field_221790_de, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 6)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_234735_dn_, Items.field_234736_do_, Items.field_234777_rA_, Items.field_234784_rH_, Items.field_234788_rL_})) {
            this.dissolver(item2, Recipes.set().addGroup(49.0, StackUtils.toStack("silicon_dioxide")).addGroup(5.0, StackUtils.toStack("sodium_oxide")).addGroup(2.0, StackUtils.toStack("potassium_oxide")).addGroup(2.0, StackUtils.toStack("titanium_oxide")).addGroup(7.0, StackUtils.toStack("iron_ii_oxide")).addGroup(15.0, StackUtils.toStack("aluminum_oxide")).addGroup(10.0, StackUtils.toStack("calcium_oxide")).addGroup(10.0, StackUtils.toStack("magnesium_oxide")).build());
        }
        this.dissolver(Items.field_234781_rE_, Recipes.set().addGroup(29.0, StackUtils.toStack("silicon_dioxide")).addGroup(20.0, StackUtils.toStack("gold", 8)).addGroup(5.0, StackUtils.toStack("sodium_oxide")).addGroup(2.0, StackUtils.toStack("potassium_oxide")).addGroup(2.0, StackUtils.toStack("titanium_oxide")).addGroup(7.0, StackUtils.toStack("iron_ii_oxide")).addGroup(15.0, StackUtils.toStack("aluminum_oxide")).addGroup(10.0, StackUtils.toStack("calcium_oxide")).addGroup(10.0, StackUtils.toStack("magnesium_oxide")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196128_bn, Items.field_221654_ao, Items.field_221652_an})) {
            multiplier = 1;
            reversible = false;
            if (item2 == Items.field_221654_ao) {
                multiplier = 9;
            } else if (item2 == Items.field_221652_an) {
                multiplier = 4;
            } else {
                reversible = true;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("sodium", 6 * multiplier), StackUtils.toStack("calcium", 2 * multiplier), StackUtils.toStack("aluminum", 6 * multiplier), StackUtils.toStack("silicon", 6 * multiplier), StackUtils.toStack("oxygen", 24 * multiplier), StackUtils.toStack("sulfur", 2 * multiplier)).build(), reversible);
        }
        this.dissolver(Items.field_151007_F, Recipes.set().relative(false).addGroup(50.0, StackUtils.toStack("protein")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151015_O, Items.field_221807_eN})) {
            rolls = 1;
            if (item2 == Items.field_221807_eN) {
                rolls = 9;
            }
            this.dissolver(item2, Recipes.set().relative(false).rolls(rolls).addGroup(5.0, StackUtils.toStack("starch")).addGroup(25.0, StackUtils.toStack("cellulose")).build());
        }
        this.dissolver(Items.field_221794_dg, Recipes.set().relative(false).addGroup(50.0, StackUtils.toStack("cucurbitacin")).addGroup(1.0, StackUtils.toStack("water", 4), StackUtils.toStack("sucrose", 2)).build());
        this.dissolver(Items.field_221774_cw, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("mescaline")).build(), true);
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221894_fe, Items.field_221929_gW, Items.field_221801_eK, Items.field_221921_gS, Items.field_221793_eG, Items.field_221923_gT, Items.field_221795_eH, Items.field_221917_gQ, Items.field_221789_eE, Items.field_221913_gO, Items.field_221785_eC, Items.field_221925_gU, Items.field_221797_eI, Items.field_221905_gK, Items.field_221882_ey, Items.field_221915_gP, Items.field_221787_eD, Items.field_221909_gM, Items.field_221781_eA, Items.field_221903_gJ, Items.field_221880_ex, Items.field_221901_gI, Items.field_221878_ew, Items.field_221783_eB, Items.field_221911_gN, Items.field_221884_ez, Items.field_221907_gL, Items.field_221791_eF, Items.field_221919_gR, Items.field_221799_eJ, Items.field_221927_gV})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("kaolinite", 4)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221941_hC, Items.field_222037_hy, Items.field_222034_hw, Items.field_222038_hz, Items.field_222030_hu, Items.field_221937_hA, Items.field_222022_hq, Items.field_222032_hv, Items.field_222026_hs, Items.field_222020_hp, Items.field_222018_ho, Items.field_222028_ht, Items.field_222036_hx, Items.field_221939_hB, Items.field_222016_hn, Items.field_222024_hr})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide", 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_222014_hm, Items.field_222006_hi, Items.field_222002_hg, Items.field_222008_hj, Items.field_221998_he, Items.field_222010_hk, Items.field_221990_ha, Items.field_222000_hf, Items.field_221994_hc, Items.field_221935_gZ, Items.field_221933_gY, Items.field_221996_hd, Items.field_222004_hh, Items.field_222012_hl, Items.field_221931_gX, Items.field_221992_hb})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide", 2), StackUtils.toStack("water", 4)).build());
        }
        this.dissolver(Items.field_221550_C, Recipes.set().addGroup(1.0, StackUtils.toStack("silicon_dioxide")).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221975_hT, Items.field_221947_hF, Items.field_222043_ie, Items.field_221977_hU, Items.field_221949_hG, Items.field_222044_if, Items.field_221979_hV, Items.field_221951_hH, Items.field_222045_ig, Items.field_221981_hW, Items.field_221953_hI, Items.field_222046_ih, Items.field_221983_hX, Items.field_221945_hE, Items.field_222042_id})) {
            int quantity = 4;
            if (item2 == Items.field_221947_hF || item2 == Items.field_221949_hG || item2 == Items.field_221951_hH || item2 == Items.field_221953_hI || item2 == Items.field_221945_hE) {
                quantity = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", quantity)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221967_hP, Items.field_221957_hK, Items.field_221987_hZ})) {
            multiplier = 4;
            if (item2 == Items.field_221957_hK) {
                multiplier = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", multiplier), StackUtils.toStack("arsenic_sulfide", multiplier / 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221969_hQ, Items.field_221959_hL, Items.field_222039_ia})) {
            multiplier = 4;
            if (item2 == Items.field_221959_hL) {
                multiplier = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", multiplier), StackUtils.toStack("han_purple", multiplier / 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221971_hR, Items.field_221961_hM, Items.field_222040_ib})) {
            multiplier = 4;
            if (item2 == Items.field_221961_hM) {
                multiplier = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", multiplier), StackUtils.toStack("cobalt_nitrate", multiplier / 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221973_hS, Items.field_221963_hN, Items.field_222041_ic})) {
            multiplier = 4;
            if (item2 == Items.field_221963_hN) {
                multiplier = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", multiplier), StackUtils.toStack("lead_iodide", multiplier / 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221965_hO, Items.field_221955_hJ, Items.field_221985_hY})) {
            multiplier = 4;
            if (item2 == Items.field_221955_hJ) {
                multiplier = 16;
            }
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", multiplier), StackUtils.toStack("cobalt_aluminate", multiplier / 2)).build());
        }
        this.dissolver(Items.field_222066_kO, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("cellulose")).addGroup(17.0, StackUtils.toStack("sodium_carbonate", 2)).addGroup(5.0, StackUtils.toStack("potassium_iodide", 2)).build());
        this.dissolver(Items.field_203180_bP, Recipes.set().addGroup(1.0, StackUtils.toStack("sodium_carbonate"), StackUtils.toStack("potassium_iodide")).build());
        this.dissolver(Items.field_222067_kP, Recipes.set().addGroup(1.0, StackUtils.toStack("sodium_carbonate", 9), StackUtils.toStack("potassium_iodide", 9)).build());
        this.dissolver(Items.field_221601_aC, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("cadmium_sulfide", 2), StackUtils.toStack("chromium_oxide", 2)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151174_bG, Items.field_151168_bH})) {
            this.dissolver(item2, Recipes.set().relative(false).addGroup(10.0, StackUtils.toStack("starch")).addGroup(25.0, StackUtils.toStack("potassium", 5)).build());
        }
        this.dissolver(Items.field_151137_ax, Recipes.set().addGroup(1.0, StackUtils.toStack("iron_oxide"), StackUtils.toStack("strontium_carbonate")).build(), true);
        this.dissolver(Items.field_221762_cq, Recipes.set().addGroup(1.0, StackUtils.toStack("iron_oxide", 4), StackUtils.toStack("strontium_carbonate", 4)).build());
        this.dissolver(Items.field_221858_em, Recipes.set().addGroup(1.0, StackUtils.toStack("iron_oxide", 9), StackUtils.toStack("strontium_carbonate", 9)).build());
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151082_bd, Items.field_151147_al, Items.field_179561_bm, Items.field_151157_am, Items.field_151083_be, Items.field_179557_bn, Items.field_151076_bf, Items.field_151077_bg, Items.field_179558_bo, Items.field_179559_bp})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 4)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196086_aW, Items.field_196102_ba, Items.field_196088_aY})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 4), StackUtils.toStack("selenium", 2)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196087_aX, Items.field_196104_bb})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 4), StackUtils.toStack("selenium", 4)).build());
        }
        this.dissolver(Items.field_196089_aZ, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 4), StackUtils.toStack("potassium_cyanide", 4)).build());
        this.dissolver(Items.field_221646_ak, Recipes.set().addGroup(1.0, StackUtils.toStack("kaolinite", 8), StackUtils.toStack("calcium_carbonate", 8)).build(), true);
        this.dissolver(Items.field_151116_aA, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 3)).build());
        this.dissolver(Items.field_151078_bh, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 3)).build());
        this.dissolver(Items.field_151008_G, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2)).build());
        this.dissolver(Items.field_196106_bc, Recipes.set().relative(false).addGroup(50.0, StackUtils.toStack("hydroxylapatite")).build());
        this.dissolver(Items.field_221964_gn, Recipes.set().rolls(9).relative(false).addGroup(50.0, StackUtils.toStack("hydroxylapatite")).build());
        this.dissolver(Items.field_151110_aK, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", 8), StackUtils.toStack("protein", 2)).build(), true);
        this.dissolver((Item)Ref.mineralSalt, Recipes.set().addGroup(60.0, StackUtils.toStack("sodium_chloride")).addGroup(5.0, StackUtils.toStack("lithium")).addGroup(10.0, StackUtils.toStack("potassium_chloride")).addGroup(10.0, StackUtils.toStack("magnesium")).addGroup(5.0, StackUtils.toStack("iron")).addGroup(4.0, StackUtils.toStack("copper")).addGroup(2.0, StackUtils.toStack("zinc")).build());
        this.dissolver(Items.field_151172_bF, Recipes.set().relative(false).addGroup(20.0, StackUtils.toStack("beta_carotene")).build());
        this.dissolver("forge:dyes/red", Recipes.set().addGroup(1.0, StackUtils.toStack("mercury_sulfide", 4)).build());
        this.dissolver("forge:dyes/pink", Recipes.set().addGroup(1.0, StackUtils.toStack("arsenic_sulfide", 4)).build());
        this.dissolver("forge:dyes/green", Recipes.set().addGroup(1.0, StackUtils.toStack("nickel_chloride", 4)).build());
        this.dissolver("forge:dyes/lime", Recipes.set().addGroup(1.0, StackUtils.toStack("cadmium_sulfide", 2), StackUtils.toStack("chromium_oxide", 2)).build());
        this.dissolver("forge:dyes/purple", Recipes.set().addGroup(1.0, StackUtils.toStack("potassium_permanganate", 4)).build());
        this.dissolver("forge:dyes/yellow", Recipes.set().addGroup(1.0, StackUtils.toStack("lead_iodide", 4)).build());
        this.dissolver("forge:dyes/orange", Recipes.set().addGroup(1.0, StackUtils.toStack("potassium_dichromate", 4)).build());
        this.dissolver("forge:dyes/black", Recipes.set().addGroup(1.0, StackUtils.toStack("titanium_oxide", 4)).build());
        this.dissolver("forge:dyes/gray", Recipes.set().addGroup(1.0, StackUtils.toStack("barium_sulfate", 4)).build());
        this.dissolver("forge:dyes/magenta", Recipes.set().addGroup(1.0, StackUtils.toStack("han_purple", 4)).build());
        this.dissolver("forge:dyes/light_blue", Recipes.set().addGroup(1.0, StackUtils.toStack("cobalt_aluminate", 2), StackUtils.toStack("antimony_trioxide", 2)).build());
        this.dissolver("forge:dyes/blue", Recipes.set().addGroup(1.0, StackUtils.toStack("cobalt_aluminate", 4)).build());
        this.dissolver("forge:dyes/light_gray", Recipes.set().addGroup(1.0, StackUtils.toStack("magnesium_sulfate", 4)).build());
        this.dissolver("forge:dyes/cyan", Recipes.set().addGroup(1.0, StackUtils.toStack("copper_chloride", 4)).build());
        this.dissolver(Items.field_196183_dw, Recipes.set().addGroup(1.0, StackUtils.toStack("hydroxylapatite", 8), StackUtils.toStack("mendelevium", 32)).build());
        this.dissolver(Items.field_196182_dv, Recipes.set().addGroup(1.0, StackUtils.toStack("hydroxylapatite", 8)).build());
        this.dissolver(Items.field_222109_pP, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 64)).build());
        this.dissolver(Items.field_234792_ro_, Recipes.set().addGroup(1.0, StackUtils.toStack("phosphorus", 16), StackUtils.toStack("psilocybin"), StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_226635_pU_, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose", 3)).build());
        this.dissolver(Items.field_226638_pX_, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose", 3)).build());
        this.dissolver(Items.field_226639_pY_, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose", 12)).build());
        this.dissolver(Items.field_226640_pZ_, Recipes.set().addGroup(1.0, StackUtils.toStack("sucrose", 12)).build());
        this.dissolver(Items.field_221943_hD, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 4), StackUtils.toStack("calcium_carbonate", 8)).build());
        this.dissolver(Items.field_203183_eM, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2)).build());
        this.dissolver(Items.field_234760_kn_, Recipes.set().addGroup(1.0, StackUtils.toStack("tungsten", 16)).build());
        this.dissolver(Items.field_234795_rx_, Recipes.set().addGroup(1.0, StackUtils.toStack("tungsten", 16)).build());
        this.dissolver(Items.field_151153_ao, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 128), StackUtils.toStack("cellulose"), StackUtils.toStack("sucrose")).build());
        this.dissolver(Items.field_221663_bT, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("cellulose")).addGroup(50.0, StackUtils.toStack("lutetium")).build());
        this.dissolver(Items.field_185161_cS, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("cellulose")).addGroup(50.0, StackUtils.toStack("lutetium")).build());
        this.dissolver(Items.field_221661_bS, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("cellulose")).addGroup(50.0, StackUtils.toStack("lutetium")).build());
        this.dissolver(Items.field_185162_cT, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("cellulose")).addGroup(50.0, StackUtils.toStack("lutetium")).build());
        Lists.newArrayList((Object[])new Item[]{Items.field_221665_bU, Items.field_221667_bV}).forEach(item -> this.dissolver((Item)item, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("silicon_dioxide", 4)).addGroup(50.0, StackUtils.toStack("lutetium")).build()));
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151119_aD, Items.field_151118_aC})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("kaolinite", 1)).build());
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221776_cx, Items.field_221647_bL})) {
            this.dissolver(item2, Recipes.set().addGroup(1.0, StackUtils.toStack("kaolinite", 4)).build());
        }
        this.dissolver(Items.field_221724_bx, Recipes.set().addGroup(1.0, StackUtils.toStack("kaolinite", 2)).build());
        this.dissolver(Items.field_185164_cV, Recipes.set().relative(false).addGroup(100.0, StackUtils.toStack("sucrose")).addGroup(50.0, StackUtils.toStack("iron_oxide")).build());
        this.dissolver(Items.field_151103_aS, Recipes.set().relative(false).addGroup(50.0, StackUtils.toStack("hydroxylapatite", 3)).build(), true);
        this.dissolver(Items.field_221655_bP, Recipes.set().addGroup(1.0, StackUtils.toStack("magnesium_oxide", 8), StackUtils.toStack("potassium_chloride", 8), StackUtils.toStack("aluminum_oxide", 8), StackUtils.toStack("silicon_dioxide", 24)).build(), true);
        this.dissolver(Items.field_222068_kQ, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose")).build());
        this.dissolver(Items.field_179556_br, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2)).build());
        this.dissolver(Items.field_179555_bs, Recipes.set().addGroup(1.0, StackUtils.toStack("protein", 2)).build());
        this.dissolver(Items.field_190930_cZ, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", 8), StackUtils.toStack("lutetium", 8)).build());
        this.dissolver(Items.field_185157_bK, Recipes.set().addGroup(1.0, StackUtils.toStack("xenon", 8), StackUtils.toStack("xenon", 8), StackUtils.toStack("radon", 8), StackUtils.toStack("oganesson", 8)).build());
        this.dissolver(Items.field_151073_bk, Recipes.set().addGroup(1.0, StackUtils.toStack("polonium", 16)).build());
        this.dissolver(Items.field_205157_eZ, Recipes.set().addGroup(1.0, StackUtils.toStack("calcium_carbonate", 16)).build());
        this.dissolver(Items.field_204840_eX, Recipes.set().addGroup(1.0, StackUtils.toStack("cerium", 8)).build());
        this.dissolver(Items.field_222112_pR, Recipes.set().addGroup(1.0, StackUtils.toStack("cellulose"), StackUtils.toStack("sucrose")).build());
        for (CompoundItem compound : CompoundRegistry.compounds) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            compound.getComponentStacks().forEach(x -> stacks.add((ItemStack)x));
            ProbabilityGroup group = new ProbabilityGroup(stacks, 1.0);
            this.dissolver((Item)compound, Recipes.set().addGroup(group).build());
        }
        for (ElementItem element : ElementRegistry.elements.values()) {
            Item ingot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("chemlib", "ingot_" + element.getChemicalName()));
            if (ingot == Items.field_190931_a) continue;
            this.dissolver("forge:ingots/" + element.getChemicalName(), Recipes.set().addGroup(1.0, new ItemStack((IItemProvider)element, 16)).build());
        }
        this.dissolver(Items.field_151042_j, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 16)).build());
        this.dissolver(Items.field_191525_da, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 1)).build());
        this.dissolver(Items.field_221698_bk, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 144)).build());
        this.dissolver(Items.field_221552_E, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 32)).build());
        this.dissolver(Items.field_234729_dO_, Recipes.set().addGroup(1.0, StackUtils.toStack("iron", 18)).build());
        this.dissolver(Items.field_151043_k, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 16)).build());
        this.dissolver(Items.field_151074_bl, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 1)).build());
        this.dissolver(Items.field_221696_bj, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 144)).build());
        this.dissolver(Items.field_221551_D, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 32)).build());
        this.dissolver(Items.field_234708_K_, Recipes.set().addGroup(1.0, StackUtils.toStack("gold", 32)).build());
        this.dissolver(Items.field_196136_br, Recipes.set().addGroup(1.0, StackUtils.toStack("titanium_oxide", 4)).build());
    }

    private void initMetals() {
        HashSet nonMetals = Sets.newHashSet((Object[])new Integer[]{1, 2, 6, 7, 8, 9, 10, 15, 16, 17, 18, 35, 36, 53, 54, 80, 86});
        metals.addAll(ElementRegistry.elements.values().stream().filter(it -> !nonMetals.contains(it.atomicNumber)).map(it -> it.internalName).collect(Collectors.toList()));
        metalTagData.add(new DissolverTagData("ingots", 16, metals));
        metalTagData.add(new DissolverTagData("ores", 32, metals));
        metalTagData.add(new DissolverTagData("dusts", 16, metals));
        metalTagData.add(new DissolverTagData("storage_blocks", 144, metals));
        metalTagData.add(new DissolverTagData("nuggets", 1, metals));
        metalTagData.add(new DissolverTagData("plates", 16, metals));
    }

    private void registerCombinerRecipes() {
        this.combiner(Items.field_151166_bC, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("beryl", 8), StackUtils.toStack("chromium", 8), StackUtils.toStack("vanadium", 4)}));
        this.combiner(Items.field_196128_bn, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("beryl", 8), StackUtils.toStack("chromium", 8), StackUtils.toStack("vanadium", 4)}));
        this.combiner(Items.field_222068_kQ, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_151123_aH, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("protein", 2), StackUtils.toStack("sucrose", 2)}));
        this.combiner(Items.field_151075_bm, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("cellulose"), StackUtils.toStack("germanium", 4), StackUtils.toStack("selenium", 4)}));
        this.combiner(Items.field_222078_li, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("mercury_sulfide", 4)}));
        this.combiner(Items.field_196118_bi, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("arsenic_sulfide", 4)}));
        this.combiner(Items.field_222079_lj, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("nickel_chloride", 4)}));
        this.combiner(Items.field_196116_bh, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("cadmium_sulfide", 2), StackUtils.toStack("chromium_oxide", 2)}));
        this.combiner(Items.field_196126_bm, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("potassium_permanganate", 4)}));
        this.combiner(Items.field_222081_ls, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("lead_iodide", 4)}));
        this.combiner(Items.field_196108_bd, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("potassium_dichromate", 4)}));
        this.combiner(Items.field_222086_lz, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("titanium_oxide", 4)}));
        this.combiner(Items.field_196120_bj, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("barium_sulfate", 4)}));
        this.combiner(Items.field_196110_be, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("han_purple", 4)}));
        this.combiner(Items.field_196112_bf, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("cobalt_aluminate", 2), StackUtils.toStack("antimony_trioxide", 2)}));
        this.combiner(Items.field_196122_bk, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("magnesium_sulfate", 4)}));
        this.combiner(Items.field_196124_bl, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("copper_chloride", 4)}));
        this.combiner(Items.field_196155_l, Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("carbon", 8)}));
        this.combiner(Items.field_151044_h, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("carbon", 8)}));
        this.combiner(Items.field_221695_cJ, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("phosphorus", 16)}));
        this.combiner(Items.field_151114_aO, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("phosphorus", 4)}));
        this.combiner(Items.field_151045_i, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64), null, StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64), StackUtils.toStack("carbon", 64)}));
        this.combiner(Items.field_221548_A, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, null, StackUtils.toStack("silicon_dioxide", 4)}));
        this.combiner(Items.field_221585_m, 2, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_221574_b, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_221776_cx, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("kaolinite", 4)}));
        this.combiner(Items.field_221582_j, 4, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("water"), StackUtils.toStack("cellulose"), StackUtils.toStack("kaolinite")}));
        this.combiner(Items.field_221814_dq, 4, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, StackUtils.toStack("psilocybin"), StackUtils.toStack("water"), StackUtils.toStack("cellulose"), StackUtils.toStack("kaolinite")}));
        this.combiner(Items.field_151008_G, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, StackUtils.toStack("protein", 2)}));
        this.combiner(Items.field_151070_bp, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("beta_carotene", 2), StackUtils.toStack("protein", 2)}));
        this.combiner(Items.field_221581_i, 4, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("water"), StackUtils.toStack("cellulose"), StackUtils.toStack("kaolinite")}));
        this.combiner(Items.field_221550_C, Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_151131_as, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("water", 16), null, null, StackUtils.toStack(Items.field_151133_ar), null}));
        this.combiner(Items.field_151117_aB, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("calcium", 4), null, StackUtils.toStack("protein", 2), StackUtils.toStack("water", 16), StackUtils.toStack("sucrose"), null, StackUtils.toStack(Items.field_151133_ar), null}));
        this.combiner(Items.field_221858_em, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("iron_oxide", 9), StackUtils.toStack("strontium_carbonate", 9)}));
        this.combiner(Items.field_151137_ax, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("iron_oxide"), StackUtils.toStack("strontium_carbonate")}));
        this.combiner(Items.field_151007_F, 4, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("protein", 2)}));
        this.combiner(Items.field_221603_aE, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, StackUtils.toStack("protein"), StackUtils.toStack("triglyceride")}));
        this.combiner(Items.field_151172_bF, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("cellulose"), StackUtils.toStack("beta_carotene")}));
        this.combiner(Items.field_222065_kN, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("cellulose"), StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_151102_aT, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_151110_aK, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("calcium_carbonate", 8), StackUtils.toStack("protein", 2)}));
        this.combiner(Items.field_221575_c, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_221577_e, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_221579_g, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, StackUtils.toStack("silicon_dioxide")}));
        this.combiner(Items.field_151145_ak, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, StackUtils.toStack("silicon_dioxide", 3)}));
        this.combiner(Items.field_151174_bG, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("starch"), StackUtils.toStack("potassium", 4)}));
        this.combiner(Items.field_151034_e, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("cellulose"), null, null, StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_151014_N, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("triglyceride"), null, StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_151080_bb, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("triglyceride"), null, null, StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_151081_bc, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("triglyceride"), null, null, null, StackUtils.toStack("sucrose")}));
        this.combiner(Items.field_185163_cU, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("triglyceride"), null, null, null, null, StackUtils.toStack("sucrose"), StackUtils.toStack("iron_oxide")}));
        this.combiner(Items.field_185164_cV, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("sucrose"), StackUtils.toStack("iron_oxide")}));
        this.combiner(Items.field_221592_t, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221593_u, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221595_w, Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221596_x, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221597_y, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221594_v, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, StackUtils.toStack("oxygen"), StackUtils.toStack("cellulose", 2)}));
        this.combiner(Items.field_221554_G, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_221555_H, Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_221557_J, Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_221558_K, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_221559_L, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_221556_I, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, StackUtils.toStack("cellulose")}));
        this.combiner(Items.field_151126_ay, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, StackUtils.toStack("water", 4)}));
        this.combiner(Items.field_221768_ct, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, StackUtils.toStack("water", 16)}));
        this.combiner(Items.field_221770_cu, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, null, StackUtils.toStack("water", 16)}));
        this.combiner(Items.field_196106_bc, 3, Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("hydroxylapatite", 2)}));
        this.combiner(Items.field_151116_aA, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("protein", 3)}));
        this.combiner(Items.field_151078_bh, Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, null, null, null, StackUtils.toStack("protein", 3)}));
        this.combiner(Items.field_151156_bN, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("lutetium", 64), StackUtils.toStack("hydrogen", 64), StackUtils.toStack("titanium", 64), StackUtils.toStack("hydrogen", 64), StackUtils.toStack("hydrogen", 64), StackUtils.toStack("hydrogen", 64), StackUtils.toStack("dysprosium", 64), StackUtils.toStack("hydrogen", 64), StackUtils.toStack("mendelevium", 64)}));
        this.combiner(Items.field_221774_cw, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("cellulose"), StackUtils.toStack("mescaline")}));
        HashMap overrides = new HashMap();
        overrides.put(CompoundRegistry.getByName((String)"triglyceride").get(), Lists.newArrayList((Object[])new ItemStack[]{null, null, StackUtils.toStack("oxygen", 2), null, StackUtils.toStack("hydrogen", 32), null, StackUtils.toStack("carbon", 18)}));
        overrides.put(CompoundRegistry.getByName((String)"cucurbitacin").get(), Lists.newArrayList((Object[])new ItemStack[]{null, null, null, null, StackUtils.toStack("hydrogen", 44), null, StackUtils.toStack("carbon", 32), null, StackUtils.toStack("oxygen", 8)}));
        overrides.put(CompoundRegistry.getByName((String)"acetic_acid").get(), Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("carbon", 2), null, StackUtils.toStack("hydrogen", 4), null, null, StackUtils.toStack("oxygen", 2)}));
        overrides.put(CompoundRegistry.getByName((String)"carbon_monoxide").get(), Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("oxygen"), null, null, null, null, StackUtils.toStack("carbon")}));
        overrides.put(CompoundRegistry.getByName((String)"carbon_dioxide").get(), Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("oxygen", 2), null, null, null, null, null, StackUtils.toStack("carbon")}));
        overrides.put(CompoundRegistry.getByName((String)"carbonate").get(), Lists.newArrayList((Object[])new ItemStack[]{null, StackUtils.toStack("oxygen", 3), null, null, null, null, null, null, StackUtils.toStack("carbon")}));
        for (CompoundItem compound : CompoundRegistry.compounds) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            if (overrides.containsKey(compound)) {
                inputs = ((List)overrides.get(compound)).stream().map(x -> {
                    if (x == null) {
                        return ItemStack.field_190927_a;
                    }
                    return x;
                }).collect(Collectors.toList());
            } else {
                for (int i = 0; i < compound.shiftedSlots; ++i) {
                    inputs.add(ItemStack.field_190927_a);
                }
                for (ItemStack component : compound.getComponentStacks()) {
                    inputs.add(component.func_77946_l());
                }
            }
            this.combiner((Item)compound, inputs);
        }
        for (ElementItem element : ElementRegistry.elements.values()) {
            Item ingot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("chemlib", "ingot_" + element.getChemicalName()));
            if (ingot == Items.field_190931_a) continue;
            this.combiner(ingot, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack(element.getItem(), 16)}));
        }
        this.combiner(Items.field_151042_j, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("iron", 16)}));
        this.combiner(Items.field_151043_k, Lists.newArrayList((Object[])new ItemStack[]{StackUtils.toStack("gold", 16)}));
    }
}

