/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.datagen.recipe;

import al132.alchemistry.Ref;
import al132.alchemistry.datagen.recipe.BaseRecipeBuilder;
import al132.alchemistry.misc.ProbabilitySet;
import al132.alchemistry.utils.IngredientStack;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class DissolverRecipeBuilder
extends BaseRecipeBuilder {
    private final String group = "minecraft:misc";
    private final String name;
    private final IngredientStack input;
    private final ProbabilitySet output;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    public DissolverRecipeBuilder(IngredientStack input, ProbabilitySet output, String name) {
        this.input = input;
        this.output = output;
        this.name = name;
    }

    public static DissolverRecipeBuilder recipe(IngredientStack input, ProbabilitySet output, String name) {
        return new DissolverRecipeBuilder(input, output, name);
    }

    public static DissolverRecipeBuilder recipe(Ingredient input, int count, ProbabilitySet output, String name) {
        return DissolverRecipeBuilder.recipe(new IngredientStack(input, count), output, name);
    }

    public static DissolverRecipeBuilder recipe(Ingredient input, ProbabilitySet output, String name) {
        return DissolverRecipeBuilder.recipe(new IngredientStack(input, 1), output, name);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, new ResourceLocation("alchemistry", "dissolver/" + this.name));
    }

    @Override
    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.input, this.output, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/dissolver/" + id.func_110623_a())));
    }

    @Override
    void validate(ResourceLocation id) {
    }

    public static class Result
    implements IFinishedRecipe {
        private final String group;
        private final ResourceLocation id;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementID;
        private final IngredientStack input;
        private final ProbabilitySet output;

        public Result(ResourceLocation id, String group, IngredientStack input, ProbabilitySet output, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.input = input;
            this.output = output;
            this.advancementBuilder = advancementBuilder;
            this.advancementID = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("input", this.input.ingredient.func_200304_c());
            json.add("output", this.output.serialize());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return Ref.DISSOLVER_SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementID;
        }
    }
}

