/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.misc;

import al132.alchemistry.misc.ProbabilityGroup;
import al132.alchemistry.utils.ListUtils;
import al132.alchemistry.utils.StackUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;

public class ProbabilitySet {
    private List<ProbabilityGroup> set;
    public final boolean relativeProbability;
    public final int rolls;

    public ProbabilitySet(List<ProbabilityGroup> set) {
        this(set, true, 1);
    }

    public ProbabilitySet(List<ProbabilityGroup> set, boolean relativeProbability, int rolls) {
        this.set = set;
        this.relativeProbability = relativeProbability;
        this.rolls = rolls;
    }

    public JsonElement serialize() {
        JsonObject temp = new JsonObject();
        temp.add("rolls", (JsonElement)new JsonPrimitive((Number)this.rolls));
        temp.add("relativeProbability", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.relativeProbability)));
        JsonArray setGroups = new JsonArray();
        for (ProbabilityGroup group : this.set) {
            setGroups.add(group.serialize());
        }
        temp.add("groups", (JsonElement)setGroups);
        return temp;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.set.size());
        for (ProbabilityGroup group : this.set) {
            group.write(buf);
        }
        buf.writeBoolean(this.relativeProbability);
        buf.writeInt(this.rolls);
    }

    public static ProbabilitySet read(PacketBuffer buf) {
        ArrayList set = Lists.newArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            set.add(ProbabilityGroup.read(buf));
        }
        boolean relativeProbability = buf.readBoolean();
        int rolls = buf.readInt();
        return new ProbabilitySet(set, relativeProbability, rolls);
    }

    public List<ProbabilityGroup> getSet() {
        return this.set;
    }

    public List<ItemStack> toStackList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.set.forEach(it -> builder.add((Object)ImmutableList.copyOf(it.getOutputs())));
        return builder.build().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ItemStack> filterNonEmpty() {
        return this.toStackList().stream().filter(x -> !x.func_190926_b()).collect(Collectors.toList());
    }

    public double probabilityAtIndex(int index) {
        double sum = this.getTotalProbability();
        if (this.relativeProbability) {
            return this.set.get(index).getProbability() / sum;
        }
        return this.set.get(index).getProbability();
    }

    private double getTotalProbability() {
        return this.set.stream().mapToDouble(ProbabilityGroup::getProbability).sum();
    }

    public NonNullList<ItemStack> calculateOutput() {
        NonNullList temp = NonNullList.func_191196_a();
        Random rando = new Random();
        block0: for (int i = 1; i <= this.rolls; ++i) {
            if (this.relativeProbability) {
                double totalProbability = this.getTotalProbability();
                double targetProbability = rando.nextDouble();
                double trackingProbability = 0.0;
                for (ProbabilityGroup component : this.set) {
                    if (!((trackingProbability += component.getProbability() / totalProbability) >= targetProbability)) continue;
                    component.getOutputs().stream().filter(x -> !x.func_190926_b()).forEach(x -> {
                        ItemStack stack = x.func_77946_l();
                        int index = ListUtils.indexOfFirst(temp, it -> StackUtils.areStacksEqualIgnoreQuantity(stack, it));
                        if (index != -1) {
                            ((ItemStack)temp.get(index)).func_190917_f(stack.func_190916_E());
                        } else {
                            temp.add((Object)stack);
                        }
                    });
                    continue block0;
                }
                continue;
            }
            for (ProbabilityGroup component : this.set) {
                if (!(component.getProbability() >= (double)rando.nextInt(101))) continue;
                component.getOutputs().stream().filter(x -> !x.func_190926_b()).forEach(x -> {
                    ItemStack stack = x.func_77946_l();
                    int index = ListUtils.indexOfFirst(temp, it -> StackUtils.areStacksEqualIgnoreQuantity(stack, it));
                    if (index != -1) {
                        ((ItemStack)temp.get(index)).func_190917_f(stack.func_190916_E());
                    } else {
                        temp.add((Object)stack);
                    }
                });
            }
        }
        return temp;
    }

    public static class Builder {
        private List<ProbabilityGroup> groups = new ArrayList<ProbabilityGroup>();
        private boolean relativeProbability = true;
        private int rolls = 1;

        public Builder addGroup(ProbabilityGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder rolls(int rolls) {
            this.rolls = rolls;
            return this;
        }

        public Builder relative(boolean relativeProbability) {
            this.relativeProbability = relativeProbability;
            return this;
        }

        public Builder addGroup(double probability, ItemStack ... stacks) {
            this.groups.add(new ProbabilityGroup(Lists.newArrayList((Object[])stacks), probability));
            return this;
        }

        public ProbabilitySet build() {
            return new ProbabilitySet(this.groups, this.relativeProbability, this.rolls);
        }
    }
}

